/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.sort;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.BooleanLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.IntLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.PrimitiveBooleanArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.PrimitiveIntArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.di.trans.steps.sort.SortRowsMeta;

public class SortRowsMetaTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Test
    public void testRoundTrips() throws KettleException {
        List<String> attributes = Arrays.asList("Directory", "Prefix", "SortSize", "FreeMemoryLimit", "CompressFiles", "CompressFilesVariable", "OnlyPassingUniqueRows", "FieldName", "Ascending", "CaseSensitive", "CollatorEnabled", "CollatorStrength", "PreSortedField");
        HashMap<String, String> getterMap = new HashMap<String, String>();
        HashMap<String, String> setterMap = new HashMap<String, String>();
        HashMap fieldLoadSaveValidatorAttributeMap = new HashMap();
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 25);
        PrimitiveBooleanArrayLoadSaveValidator booleanArrayLoadSaveValidator = new PrimitiveBooleanArrayLoadSaveValidator(new BooleanLoadSaveValidator(), 25);
        PrimitiveIntArrayLoadSaveValidator intArrayLoadSaveValidator = new PrimitiveIntArrayLoadSaveValidator(new IntLoadSaveValidator(), 25);
        fieldLoadSaveValidatorAttributeMap.put("FieldName", stringArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("Ascending", booleanArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("CaseSensitive", booleanArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("CollatorEnabled", booleanArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("CollatorStrength", intArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("PreSortedField", booleanArrayLoadSaveValidator);
        LoadSaveTester<SortRowsMeta> loadSaveTester = new LoadSaveTester<SortRowsMeta>(SortRowsMeta.class, attributes, getterMap, setterMap, fieldLoadSaveValidatorAttributeMap, new HashMap());
        loadSaveTester.testSerialization();
    }

    @Test
    public void testGetDefaultStrength() {
        SortRowsMeta srm = new SortRowsMeta();
        int usStrength = srm.getDefaultCollationStrength(Locale.US);
        Assert.assertEquals((long)2L, (long)usStrength);
        Assert.assertEquals((long)3L, (long)srm.getDefaultCollationStrength(null));
    }

    @Test
    public void testPDI16559() throws Exception {
        SortRowsMeta sortRowsReal = new SortRowsMeta();
        SortRowsMeta sortRows = (SortRowsMeta)Mockito.spy((Object)sortRowsReal);
        ((SortRowsMeta)Mockito.doNothing().when((Object)sortRows)).registerUrlWithDirectory();
        sortRows.setDirectory("/tmp");
        sortRows.setFieldName(new String[]{"field1", "field2", "field3", "field4", "field5"});
        sortRows.setAscending(new boolean[]{false, true, false});
        sortRows.setCaseSensitive(new boolean[]{true, false, true, false});
        sortRows.setCollatorEnabled(new boolean[]{false, false, true});
        sortRows.setCollatorStrength(new int[]{2, 1, 3});
        sortRows.setPreSortedField(new boolean[]{true, true, false});
        try {
            String badXml = sortRows.getXML();
            Assert.fail((String)"Before calling afterInjectionSynchronization, should have thrown an ArrayIndexOOB");
        }
        catch (Exception badXml) {
            // empty catch block
        }
        sortRows.afterInjectionSynchronization();
        String ktrXml = sortRows.getXML();
        int targetSz = sortRows.getFieldName().length;
        Assert.assertEquals((long)targetSz, (long)sortRows.getAscending().length);
        Assert.assertEquals((long)targetSz, (long)sortRows.getCaseSensitive().length);
        Assert.assertEquals((long)targetSz, (long)sortRows.getCollatorEnabled().length);
        Assert.assertEquals((long)targetSz, (long)sortRows.getCollatorStrength().length);
        Assert.assertEquals((long)targetSz, (long)sortRows.getPreSortedField().length);
    }
}

