/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.sftpput;

import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.job.entries.sftp.SFTPClient;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.StepMockUtil;
import org.pentaho.di.trans.steps.sftpput.SFTPPut;
import org.pentaho.di.trans.steps.sftpput.SFTPPutData;
import org.pentaho.di.trans.steps.sftpput.SFTPPutMeta;

public class SFTPPutTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private SFTPPut step;

    @BeforeClass
    public static void initKettle() throws Exception {
        KettleEnvironment.init();
    }

    @Before
    public void setUp() throws Exception {
        SFTPClient clientMock = (SFTPClient)Mockito.mock(SFTPClient.class);
        this.step = StepMockUtil.getStep(SFTPPut.class, SFTPPutMeta.class, "mock step");
        this.step = (SFTPPut)Mockito.spy((Object)this.step);
        ((SFTPPut)Mockito.doReturn((Object)clientMock).when((Object)this.step)).createSftpClient(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
    }

    private static RowMeta rowOfStringsMeta(String ... columns) {
        RowMeta rowMeta = new RowMeta();
        for (String column : columns) {
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString(column));
        }
        return rowMeta;
    }

    @Test
    public void checkRemoteFilenameField_FieldNameIsBlank() throws Exception {
        SFTPPutData data = new SFTPPutData();
        this.step.checkRemoteFilenameField("", data);
        Assert.assertEquals((long)-1L, (long)data.indexOfSourceFileFieldName);
    }

    @Test(expected=KettleStepException.class)
    public void checkRemoteFilenameField_FieldNameIsSet_NotFound() throws Exception {
        this.step.setInputRowMeta((RowMetaInterface)new RowMeta());
        this.step.checkRemoteFilenameField("remoteFileName", new SFTPPutData());
    }

    @Test
    public void checkRemoteFilenameField_FieldNameIsSet_Found() throws Exception {
        RowMeta rowMeta = SFTPPutTest.rowOfStringsMeta("some field", "remoteFileName");
        this.step.setInputRowMeta((RowMetaInterface)rowMeta);
        SFTPPutData data = new SFTPPutData();
        this.step.checkRemoteFilenameField("remoteFileName", data);
        Assert.assertEquals((long)1L, (long)data.indexOfRemoteFilename);
    }

    @Test(expected=KettleStepException.class)
    public void checkSourceFileField_NameIsBlank() throws Exception {
        SFTPPutData data = new SFTPPutData();
        this.step.checkSourceFileField("", data);
    }

    @Test(expected=KettleStepException.class)
    public void checkSourceFileField_NameIsSet_NotFound() throws Exception {
        this.step.setInputRowMeta((RowMetaInterface)new RowMeta());
        this.step.checkSourceFileField("sourceFile", new SFTPPutData());
    }

    @Test
    public void checkSourceFileField_NameIsSet_Found() throws Exception {
        RowMeta rowMeta = SFTPPutTest.rowOfStringsMeta("some field", "sourceFileFieldName");
        this.step.setInputRowMeta((RowMetaInterface)rowMeta);
        SFTPPutData data = new SFTPPutData();
        this.step.checkSourceFileField("sourceFileFieldName", data);
        Assert.assertEquals((long)1L, (long)data.indexOfSourceFileFieldName);
    }

    @Test(expected=KettleStepException.class)
    public void checkRemoteFoldernameField_NameIsBlank() throws Exception {
        SFTPPutData data = new SFTPPutData();
        this.step.checkRemoteFoldernameField("", data);
    }

    @Test(expected=KettleStepException.class)
    public void checkRemoteFoldernameField_NameIsSet_NotFound() throws Exception {
        this.step.setInputRowMeta((RowMetaInterface)new RowMeta());
        this.step.checkRemoteFoldernameField("remoteFolder", new SFTPPutData());
    }

    @Test
    public void checkRemoteFoldernameField_NameIsSet_Found() throws Exception {
        RowMeta rowMeta = SFTPPutTest.rowOfStringsMeta("some field", "remoteFoldernameFieldName");
        this.step.setInputRowMeta((RowMetaInterface)rowMeta);
        SFTPPutData data = new SFTPPutData();
        this.step.checkRemoteFoldernameField("remoteFoldernameFieldName", data);
        Assert.assertEquals((long)1L, (long)data.indexOfRemoteDirectory);
    }

    @Test(expected=KettleStepException.class)
    public void checkDestinationFolderField_NameIsBlank() throws Exception {
        SFTPPutData data = new SFTPPutData();
        this.step.checkDestinationFolderField("", data);
    }

    @Test(expected=KettleStepException.class)
    public void checkDestinationFolderField_NameIsSet_NotFound() throws Exception {
        this.step.setInputRowMeta((RowMetaInterface)new RowMeta());
        this.step.checkDestinationFolderField("destinationFolder", new SFTPPutData());
    }

    @Test
    public void checkDestinationFolderField_NameIsSet_Found() throws Exception {
        RowMeta rowMeta = SFTPPutTest.rowOfStringsMeta("some field", "destinationFolderFieldName");
        this.step.setInputRowMeta((RowMetaInterface)rowMeta);
        SFTPPutData data = new SFTPPutData();
        this.step.checkDestinationFolderField("destinationFolderFieldName", data);
        Assert.assertEquals((long)1L, (long)data.indexOfMoveToFolderFieldName);
    }

    @Test
    public void remoteFilenameFieldIsMandatoryWhenStreamingFromInputField() throws Exception {
        RowMeta rowMeta = SFTPPutTest.rowOfStringsMeta("sourceFilenameFieldName", "remoteDirectoryFieldName");
        this.step.setInputRowMeta((RowMetaInterface)rowMeta);
        ((SFTPPut)Mockito.doReturn((Object)new Object[]{"qwerty", "asdfg"}).when((Object)this.step)).getRow();
        SFTPPutMeta meta = new SFTPPutMeta();
        meta.setInputStream(true);
        meta.setPassword("qwerty");
        meta.setSourceFileFieldName("sourceFilenameFieldName");
        meta.setRemoteDirectoryFieldName("remoteDirectoryFieldName");
        this.step.processRow((StepMetaInterface)meta, (StepDataInterface)new SFTPPutData());
        Assert.assertEquals((long)1L, (long)this.step.getErrors());
    }
}

