/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.selectvalues;

import java.math.BigDecimal;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleConversionException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.row.value.ValueMetaBigNumber;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepAttributesInterface;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.StepMockUtil;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.selectvalues.SelectMetadataChange;
import org.pentaho.di.trans.steps.selectvalues.SelectValues;
import org.pentaho.di.trans.steps.selectvalues.SelectValuesData;
import org.pentaho.di.trans.steps.selectvalues.SelectValuesMeta;

public class SelectValuesTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private static final String SELECTED_FIELD = "field";
    private final Object[] inputRow = new Object[]{"a string"};
    private SelectValues step;
    private StepMockHelper<SelectValuesMeta, StepDataInterface> helper;

    @BeforeClass
    public static void initKettle() throws Exception {
        KettleEnvironment.init();
    }

    @Before
    public void setUp() throws Exception {
        this.helper = StepMockUtil.getStepMockHelper(SelectValuesMeta.class, "SelectValuesTest");
        Mockito.when((Object)this.helper.stepMeta.isDoingErrorHandling()).thenReturn((Object)true);
        this.step = new SelectValues(this.helper.stepMeta, this.helper.stepDataInterface, 1, this.helper.transMeta, this.helper.trans);
        this.step = (SelectValues)Mockito.spy((Object)this.step);
        ((SelectValues)Mockito.doReturn((Object)this.inputRow).when((Object)this.step)).getRow();
        ((SelectValues)Mockito.doNothing().when((Object)this.step)).putError((RowMetaInterface)Matchers.any(RowMetaInterface.class), (Object[])Matchers.any(Object[].class), Matchers.anyLong(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
        RowMeta inputRowMeta = new RowMeta();
        inputRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString(SELECTED_FIELD));
        this.step.setInputRowMeta((RowMetaInterface)inputRowMeta);
    }

    @After
    public void cleanUp() {
        this.helper.cleanUp();
    }

    @Test
    public void testPDI16368() throws Exception {
        SelectValuesHandler step2 = null;
        Object[] inputRow2 = null;
        RowMeta inputRowMeta = null;
        SelectValuesMeta stepMeta = null;
        SelectValuesData stepData = null;
        ValueMetaInterface vmi = null;
        step2 = new SelectValuesHandler(this.helper.stepMeta, (StepDataInterface)this.helper.stepDataInterface, 1, this.helper.transMeta, this.helper.trans);
        step2 = (SelectValuesHandler)((Object)Mockito.spy((Object)((Object)step2)));
        inputRow2 = new Object[]{new BigDecimal("589")};
        ((SelectValuesHandler)((Object)Mockito.doReturn((Object)inputRow2).when((Object)step2))).getRow();
        ((SelectValuesHandler)((Object)Mockito.doNothing().when((Object)step2))).putError((RowMetaInterface)Matchers.any(RowMetaInterface.class), (Object[])Matchers.any(Object[].class), Matchers.anyLong(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
        inputRowMeta = new RowMeta();
        inputRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaBigNumber(SELECTED_FIELD));
        step2.setInputRowMeta((RowMetaInterface)inputRowMeta);
        stepMeta = new SelectValuesMeta();
        stepMeta.allocate(1, 0, 1);
        stepMeta.getSelectFields()[0] = new SelectValuesMeta.SelectField();
        stepMeta.getSelectFields()[0].setName(SELECTED_FIELD);
        stepMeta.getMeta()[0] = new SelectMetadataChange((StepAttributesInterface)stepMeta, SELECTED_FIELD, null, 5, -2, -2, 0, null, false, null, null, false, null, null, null);
        stepData = new SelectValuesData();
        stepData.select = true;
        stepData.metadata = true;
        stepData.firstselect = true;
        stepData.firstmetadata = true;
        step2.processRow((StepMetaInterface)stepMeta, (StepDataInterface)stepData);
        vmi = step2.rowMeta.getValueMeta(0);
        Assert.assertEquals((Object)ValueMetaBase.DEFAULT_BIG_NUMBER_FORMAT_MASK, (Object)vmi.getConversionMask());
        step2 = new SelectValuesHandler(this.helper.stepMeta, (StepDataInterface)this.helper.stepDataInterface, 1, this.helper.transMeta, this.helper.trans);
        step2 = (SelectValuesHandler)((Object)Mockito.spy((Object)((Object)step2)));
        ((SelectValuesHandler)((Object)Mockito.doReturn((Object)inputRow2).when((Object)step2))).getRow();
        ((SelectValuesHandler)((Object)Mockito.doNothing().when((Object)step2))).putError((RowMetaInterface)Matchers.any(RowMetaInterface.class), (Object[])Matchers.any(Object[].class), Matchers.anyLong(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
        inputRowMeta = new RowMeta();
        inputRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaBigNumber(SELECTED_FIELD));
        step2.setInputRowMeta((RowMetaInterface)inputRowMeta);
        stepMeta = new SelectValuesMeta();
        stepMeta.allocate(1, 0, 1);
        stepMeta.getSelectFields()[0] = new SelectValuesMeta.SelectField();
        stepMeta.getSelectFields()[0].setName(SELECTED_FIELD);
        stepMeta.getMeta()[0] = new SelectMetadataChange((StepAttributesInterface)stepMeta, SELECTED_FIELD, null, 1, -2, -2, 0, null, false, null, null, false, null, null, null);
        stepData = new SelectValuesData();
        stepData.select = true;
        stepData.metadata = true;
        stepData.firstselect = true;
        stepData.firstmetadata = true;
        step2.processRow((StepMetaInterface)stepMeta, (StepDataInterface)stepData);
        vmi = step2.rowMeta.getValueMeta(0);
        Assert.assertEquals((Object)ValueMetaBase.DEFAULT_BIG_NUMBER_FORMAT_MASK, (Object)vmi.getConversionMask());
        step2 = new SelectValuesHandler(this.helper.stepMeta, (StepDataInterface)this.helper.stepDataInterface, 1, this.helper.transMeta, this.helper.trans);
        step2 = (SelectValuesHandler)((Object)Mockito.spy((Object)((Object)step2)));
        inputRow2 = new Object[]{new Long("589")};
        ((SelectValuesHandler)((Object)Mockito.doReturn((Object)inputRow2).when((Object)step2))).getRow();
        ((SelectValuesHandler)((Object)Mockito.doNothing().when((Object)step2))).putError((RowMetaInterface)Matchers.any(RowMetaInterface.class), (Object[])Matchers.any(Object[].class), Matchers.anyLong(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
        inputRowMeta = new RowMeta();
        inputRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaInteger(SELECTED_FIELD));
        step2.setInputRowMeta((RowMetaInterface)inputRowMeta);
        stepMeta = new SelectValuesMeta();
        stepMeta.allocate(1, 0, 1);
        stepMeta.getSelectFields()[0] = new SelectValuesMeta.SelectField();
        stepMeta.getSelectFields()[0].setName(SELECTED_FIELD);
        stepMeta.getMeta()[0] = new SelectMetadataChange((StepAttributesInterface)stepMeta, SELECTED_FIELD, null, 6, -2, -2, 0, null, false, null, null, false, null, null, null);
        stepData = new SelectValuesData();
        stepData.select = true;
        stepData.metadata = true;
        stepData.firstselect = true;
        stepData.firstmetadata = true;
        step2.processRow((StepMetaInterface)stepMeta, (StepDataInterface)stepData);
        vmi = step2.rowMeta.getValueMeta(0);
        Assert.assertEquals((Object)ValueMetaBase.DEFAULT_INTEGER_FORMAT_MASK, (Object)vmi.getConversionMask());
        step2 = new SelectValuesHandler(this.helper.stepMeta, (StepDataInterface)this.helper.stepDataInterface, 1, this.helper.transMeta, this.helper.trans);
        step2.setVariable("KETTLE_COMPATIBILITY_SELECT_VALUES_TYPE_CHANGE_USES_TYPE_DEFAULTS", "Y");
        step2 = (SelectValuesHandler)((Object)Mockito.spy((Object)((Object)step2)));
        inputRow2 = new Object[]{new BigDecimal("589")};
        ((SelectValuesHandler)((Object)Mockito.doReturn((Object)inputRow2).when((Object)step2))).getRow();
        ((SelectValuesHandler)((Object)Mockito.doNothing().when((Object)step2))).putError((RowMetaInterface)Matchers.any(RowMetaInterface.class), (Object[])Matchers.any(Object[].class), Matchers.anyLong(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
        inputRowMeta = new RowMeta();
        inputRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaBigNumber(SELECTED_FIELD));
        step2.setInputRowMeta((RowMetaInterface)inputRowMeta);
        stepMeta = new SelectValuesMeta();
        stepMeta.allocate(1, 0, 1);
        stepMeta.getSelectFields()[0] = new SelectValuesMeta.SelectField();
        stepMeta.getSelectFields()[0].setName(SELECTED_FIELD);
        stepMeta.getMeta()[0] = new SelectMetadataChange((StepAttributesInterface)stepMeta, SELECTED_FIELD, null, 5, -2, -2, 0, null, false, null, null, false, null, null, null);
        stepData = new SelectValuesData();
        stepData.select = true;
        stepData.metadata = true;
        stepData.firstselect = true;
        stepData.firstmetadata = true;
        step2.processRow((StepMetaInterface)stepMeta, (StepDataInterface)stepData);
        vmi = step2.rowMeta.getValueMeta(0);
        Assert.assertEquals((Object)ValueMetaBase.DEFAULT_INTEGER_FORMAT_MASK, (Object)vmi.getConversionMask());
        step2 = new SelectValuesHandler(this.helper.stepMeta, (StepDataInterface)this.helper.stepDataInterface, 1, this.helper.transMeta, this.helper.trans);
        step2.setVariable("KETTLE_COMPATIBILITY_SELECT_VALUES_TYPE_CHANGE_USES_TYPE_DEFAULTS", "Y");
        step2 = (SelectValuesHandler)((Object)Mockito.spy((Object)((Object)step2)));
        ((SelectValuesHandler)((Object)Mockito.doReturn((Object)inputRow2).when((Object)step2))).getRow();
        ((SelectValuesHandler)((Object)Mockito.doNothing().when((Object)step2))).putError((RowMetaInterface)Matchers.any(RowMetaInterface.class), (Object[])Matchers.any(Object[].class), Matchers.anyLong(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
        inputRowMeta = new RowMeta();
        inputRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaBigNumber(SELECTED_FIELD));
        step2.setInputRowMeta((RowMetaInterface)inputRowMeta);
        stepMeta = new SelectValuesMeta();
        stepMeta.allocate(1, 0, 1);
        stepMeta.getSelectFields()[0] = new SelectValuesMeta.SelectField();
        stepMeta.getSelectFields()[0].setName(SELECTED_FIELD);
        stepMeta.getMeta()[0] = new SelectMetadataChange((StepAttributesInterface)stepMeta, SELECTED_FIELD, null, 1, -2, -2, 0, null, false, null, null, false, null, null, null);
        stepData = new SelectValuesData();
        stepData.select = true;
        stepData.metadata = true;
        stepData.firstselect = true;
        stepData.firstmetadata = true;
        step2.processRow((StepMetaInterface)stepMeta, (StepDataInterface)stepData);
        vmi = step2.rowMeta.getValueMeta(0);
        Assert.assertEquals((Object)ValueMetaBase.DEFAULT_NUMBER_FORMAT_MASK, (Object)vmi.getConversionMask());
        step2 = new SelectValuesHandler(this.helper.stepMeta, (StepDataInterface)this.helper.stepDataInterface, 1, this.helper.transMeta, this.helper.trans);
        step2.setVariable("KETTLE_COMPATIBILITY_SELECT_VALUES_TYPE_CHANGE_USES_TYPE_DEFAULTS", "Y");
        step2 = (SelectValuesHandler)((Object)Mockito.spy((Object)((Object)step2)));
        inputRow2 = new Object[]{new Long("589")};
        ((SelectValuesHandler)((Object)Mockito.doReturn((Object)inputRow2).when((Object)step2))).getRow();
        ((SelectValuesHandler)((Object)Mockito.doNothing().when((Object)step2))).putError((RowMetaInterface)Matchers.any(RowMetaInterface.class), (Object[])Matchers.any(Object[].class), Matchers.anyLong(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
        inputRowMeta = new RowMeta();
        inputRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaInteger(SELECTED_FIELD));
        step2.setInputRowMeta((RowMetaInterface)inputRowMeta);
        stepMeta = new SelectValuesMeta();
        stepMeta.allocate(1, 0, 1);
        stepMeta.getSelectFields()[0] = new SelectValuesMeta.SelectField();
        stepMeta.getSelectFields()[0].setName(SELECTED_FIELD);
        stepMeta.getMeta()[0] = new SelectMetadataChange((StepAttributesInterface)stepMeta, SELECTED_FIELD, null, 6, -2, -2, 0, null, false, null, null, false, null, null, null);
        stepData = new SelectValuesData();
        stepData.select = true;
        stepData.metadata = true;
        stepData.firstselect = true;
        stepData.firstmetadata = true;
        step2.processRow((StepMetaInterface)stepMeta, (StepDataInterface)stepData);
        vmi = step2.rowMeta.getValueMeta(0);
        Assert.assertEquals((Object)ValueMetaBase.DEFAULT_BIG_NUMBER_FORMAT_MASK, (Object)vmi.getConversionMask());
    }

    @Test
    public void errorRowSetObtainsFieldName() throws Exception {
        SelectValuesMeta stepMeta = new SelectValuesMeta();
        stepMeta.allocate(1, 0, 1);
        stepMeta.getSelectFields()[0] = new SelectValuesMeta.SelectField();
        stepMeta.getSelectFields()[0].setName(SELECTED_FIELD);
        stepMeta.getMeta()[0] = new SelectMetadataChange((StepAttributesInterface)stepMeta, SELECTED_FIELD, null, 5, -2, -2, 0, null, false, null, null, false, null, null, null);
        SelectValuesData stepData = new SelectValuesData();
        stepData.select = true;
        stepData.metadata = true;
        stepData.firstselect = true;
        stepData.firstmetadata = true;
        this.step.processRow((StepMetaInterface)stepMeta, (StepDataInterface)stepData);
        ((SelectValues)Mockito.verify((Object)this.step)).putError((RowMetaInterface)Matchers.any(RowMetaInterface.class), (Object[])Matchers.any(Object[].class), Matchers.anyLong(), Matchers.anyString(), (String)Mockito.eq((Object)SELECTED_FIELD), Matchers.anyString());
        boolean properException = false;
        try {
            this.step.metadataValues(this.step.getInputRowMeta(), this.inputRow);
        }
        catch (KettleConversionException e) {
            properException = true;
        }
        Assert.assertTrue((boolean)properException);
    }

    public class SelectValuesHandler
    extends SelectValues {
        private Object[] resultRow;
        private RowMetaInterface rowMeta;
        private RowSet rowset;

        public SelectValuesHandler(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
            super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        }

        public void putRow(RowMetaInterface rm, Object[] row) throws KettleStepException {
            this.resultRow = row;
            this.rowMeta = rm;
        }

        public RowSet findInputRowSet(String sourceStep) throws KettleStepException {
            return this.rowset;
        }
    }
}

