/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.selectvalues;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepAttributesInterface;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.selectvalues.SelectMetadataChange;
import org.pentaho.di.trans.steps.selectvalues.SelectValuesMeta;

public class SelectValuesMetaTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private static final String FIRST_FIELD = "FIRST_FIELD";
    private static final String SECOND_FIELD = "SECOND_FIELD";
    private SelectValuesMeta selectValuesMeta;

    @Before
    public void before() {
        this.selectValuesMeta = new SelectValuesMeta();
    }

    @Test
    public void loadSaveTest() throws KettleException {
        List<String> attributes = Arrays.asList("selectFields", "deleteName");
        SelectValuesMeta.SelectField selectField = new SelectValuesMeta.SelectField();
        selectField.setName("TEST_NAME");
        selectField.setRename("TEST_RENAME");
        selectField.setLength(2);
        selectField.setPrecision(2);
        HashMap fieldLoadSaveValidatorTypeMap = new HashMap();
        fieldLoadSaveValidatorTypeMap.put(SelectValuesMeta.SelectField[].class.getCanonicalName(), new ArrayLoadSaveValidator<SelectValuesMeta.SelectField>(new SelectFieldLoadSaveValidator(selectField), 2));
        LoadSaveTester<SelectValuesMeta> tester = new LoadSaveTester<SelectValuesMeta>(SelectValuesMeta.class, attributes, new HashMap<String, String>(), new HashMap<String, String>(), new HashMap(), fieldLoadSaveValidatorTypeMap);
        tester.testSerialization();
    }

    @Test
    public void setSelectName() {
        this.selectValuesMeta.setSelectName(new String[]{FIRST_FIELD, SECOND_FIELD});
        Assert.assertArrayEquals((Object[])new String[]{FIRST_FIELD, SECOND_FIELD}, (Object[])this.selectValuesMeta.getSelectName());
    }

    @Test
    public void setSelectName_getOtherFields() {
        this.selectValuesMeta.setSelectName(new String[]{FIRST_FIELD, SECOND_FIELD});
        Assert.assertArrayEquals((Object[])new String[]{null, null}, (Object[])this.selectValuesMeta.getSelectRename());
        Assert.assertArrayEquals((int[])new int[]{-2, -2}, (int[])this.selectValuesMeta.getSelectLength());
        Assert.assertArrayEquals((int[])new int[]{-2, -2}, (int[])this.selectValuesMeta.getSelectPrecision());
    }

    @Test
    public void setSelectName_smallerThanPrevious() {
        this.selectValuesMeta.setSelectName(new String[]{FIRST_FIELD, SECOND_FIELD});
        this.selectValuesMeta.setSelectName(new String[]{FIRST_FIELD});
        Assert.assertArrayEquals((Object[])new String[]{FIRST_FIELD}, (Object[])this.selectValuesMeta.getSelectName());
    }

    @Test
    public void getSelectName() {
        Assert.assertArrayEquals((Object[])new String[0], (Object[])this.selectValuesMeta.getSelectName());
    }

    @Test
    public void setSelectRename() {
        this.selectValuesMeta.setSelectRename(new String[]{FIRST_FIELD, SECOND_FIELD});
        Assert.assertArrayEquals((Object[])new String[]{FIRST_FIELD, SECOND_FIELD}, (Object[])this.selectValuesMeta.getSelectRename());
    }

    @Test
    public void setSelectRename_getOtherFields() {
        this.selectValuesMeta.setSelectRename(new String[]{FIRST_FIELD, SECOND_FIELD});
        Assert.assertArrayEquals((Object[])new String[]{null, null}, (Object[])this.selectValuesMeta.getSelectName());
        Assert.assertArrayEquals((int[])new int[]{-2, -2}, (int[])this.selectValuesMeta.getSelectLength());
        Assert.assertArrayEquals((int[])new int[]{-2, -2}, (int[])this.selectValuesMeta.getSelectPrecision());
    }

    @Test
    public void setSelectRename_smallerThanPrevious() {
        this.selectValuesMeta.setSelectRename(new String[]{FIRST_FIELD, SECOND_FIELD});
        this.selectValuesMeta.setSelectRename(new String[]{FIRST_FIELD});
        Assert.assertArrayEquals((Object[])new String[]{FIRST_FIELD, null}, (Object[])this.selectValuesMeta.getSelectRename());
    }

    @Test
    public void getSelectRename() {
        Assert.assertArrayEquals((Object[])new String[0], (Object[])this.selectValuesMeta.getSelectRename());
    }

    @Test
    public void setSelectLength() {
        this.selectValuesMeta.setSelectLength(new int[]{1, 2});
        Assert.assertArrayEquals((int[])new int[]{1, 2}, (int[])this.selectValuesMeta.getSelectLength());
    }

    @Test
    public void setSelectLength_getOtherFields() {
        this.selectValuesMeta.setSelectLength(new int[]{1, 2});
        Assert.assertArrayEquals((Object[])new String[]{null, null}, (Object[])this.selectValuesMeta.getSelectName());
        Assert.assertArrayEquals((Object[])new String[]{null, null}, (Object[])this.selectValuesMeta.getSelectRename());
        Assert.assertArrayEquals((int[])new int[]{-2, -2}, (int[])this.selectValuesMeta.getSelectPrecision());
    }

    @Test
    public void setSelectLength_smallerThanPrevious() {
        this.selectValuesMeta.setSelectLength(new int[]{1, 2});
        this.selectValuesMeta.setSelectLength(new int[]{1});
        Assert.assertArrayEquals((int[])new int[]{1, -2}, (int[])this.selectValuesMeta.getSelectLength());
    }

    @Test
    public void getSelectLength() {
        Assert.assertArrayEquals((int[])new int[0], (int[])this.selectValuesMeta.getSelectLength());
    }

    @Test
    public void setSelectPrecision() {
        this.selectValuesMeta.setSelectPrecision(new int[]{1, 2});
        Assert.assertArrayEquals((int[])new int[]{1, 2}, (int[])this.selectValuesMeta.getSelectPrecision());
    }

    @Test
    public void setSelectPrecision_getOtherFields() {
        this.selectValuesMeta.setSelectPrecision(new int[]{1, 2});
        Assert.assertArrayEquals((Object[])new String[]{null, null}, (Object[])this.selectValuesMeta.getSelectName());
        Assert.assertArrayEquals((Object[])new String[]{null, null}, (Object[])this.selectValuesMeta.getSelectRename());
        Assert.assertArrayEquals((int[])new int[]{-2, -2}, (int[])this.selectValuesMeta.getSelectLength());
    }

    @Test
    public void setSelectPrecision_smallerThanPrevious() {
        this.selectValuesMeta.setSelectPrecision(new int[]{1, 2});
        this.selectValuesMeta.setSelectPrecision(new int[]{1});
        Assert.assertArrayEquals((int[])new int[]{1, -2}, (int[])this.selectValuesMeta.getSelectPrecision());
    }

    @Test
    public void setSelectFieldsNull() {
        this.selectValuesMeta.setSelectFields(null);
        Assert.assertNotNull((Object)this.selectValuesMeta.getSelectFields());
        Assert.assertEquals((long)0L, (long)this.selectValuesMeta.getSelectFields().length);
    }

    @Test
    public void setDeleteNameNull() {
        this.selectValuesMeta.setDeleteName(null);
        Assert.assertNotNull((Object)this.selectValuesMeta.getDeleteName());
        Assert.assertEquals((long)0L, (long)this.selectValuesMeta.getDeleteName().length);
    }

    @Test
    public void setMetaNull() {
        this.selectValuesMeta.setMeta(null);
        Assert.assertNotNull((Object)this.selectValuesMeta.getMeta());
        Assert.assertEquals((long)0L, (long)this.selectValuesMeta.getMeta().length);
    }

    @Test
    public void getSelectPrecision() {
        Assert.assertArrayEquals((int[])new int[0], (int[])this.selectValuesMeta.getSelectPrecision());
    }

    @Test
    public void testMetaDataFieldsRenameConflict() throws Exception {
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("A"));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("B"));
        SelectMetadataChange change = new SelectMetadataChange((StepAttributesInterface)this.selectValuesMeta);
        change.setName("A");
        change.setRename("B");
        this.selectValuesMeta.setMeta(new SelectMetadataChange[]{change});
        this.selectValuesMeta.getMetadataFields((RowMetaInterface)rowMeta, "select values", null);
        Assert.assertEquals((String)"rename conflict", (Object)"B_1", (Object)rowMeta.getValueMeta(0).getName());
    }

    public static class SelectFieldLoadSaveValidator
    implements FieldLoadSaveValidator<SelectValuesMeta.SelectField> {
        private final SelectValuesMeta.SelectField defaultValue;

        public SelectFieldLoadSaveValidator(SelectValuesMeta.SelectField defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public SelectValuesMeta.SelectField getTestObject() {
            return this.defaultValue;
        }

        @Override
        public boolean validateTestObject(SelectValuesMeta.SelectField testObject, Object actual) {
            return EqualsBuilder.reflectionEquals((Object)testObject, (Object)actual);
        }
    }
}

