/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.scriptvalues_mod;

import java.math.BigDecimal;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBigNumber;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.TransTestingUtil;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.StepMockUtil;
import org.pentaho.di.trans.steps.scriptvalues_mod.ScriptValuesMetaMod;
import org.pentaho.di.trans.steps.scriptvalues_mod.ScriptValuesMod;
import org.pentaho.di.trans.steps.scriptvalues_mod.ScriptValuesModData;
import org.pentaho.di.trans.steps.scriptvalues_mod.ScriptValuesScript;

public class ScriptValuesModTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @BeforeClass
    public static void initKettle() throws Exception {
        KettleEnvironment.init();
    }

    @Test
    public void bigNumberAreNotTrimmedToInt() throws Exception {
        ScriptValuesMod step = StepMockUtil.getStep(ScriptValuesMod.class, ScriptValuesMetaMod.class, "test");
        RowMeta input = new RowMeta();
        input.addValueMeta((ValueMetaInterface)new ValueMetaBigNumber("value_int"));
        input.addValueMeta((ValueMetaInterface)new ValueMetaBigNumber("value_double"));
        step.setInputRowMeta((RowMetaInterface)input);
        step = (ScriptValuesMod)Mockito.spy((Object)step);
        ((ScriptValuesMod)Mockito.doReturn((Object)new Object[]{BigDecimal.ONE, BigDecimal.ONE}).when((Object)step)).getRow();
        ScriptValuesMetaMod meta = new ScriptValuesMetaMod();
        meta.setCompatible(false);
        meta.allocate(2);
        meta.setFieldname(new String[]{"value_int", "value_double"});
        meta.setType(new int[]{6, 6});
        meta.setReplace(new boolean[]{true, true});
        meta.setJSScripts(new ScriptValuesScript[]{new ScriptValuesScript(0, "script", "value_int = 10.00;\nvalue_double = 10.50")});
        ScriptValuesModData data = new ScriptValuesModData();
        step.init((StepMetaInterface)meta, (StepDataInterface)data);
        Object[] expectedRow = new Object[]{BigDecimal.TEN, new BigDecimal("10.5")};
        Object[] row = TransTestingUtil.execute((BaseStep)step, (StepMetaInterface)meta, (StepDataInterface)data, 1, false).get(0);
        TransTestingUtil.assertResult(expectedRow, row);
    }

    @Test
    public void variableIsSetInScopeOfStep() throws Exception {
        ScriptValuesMod step = StepMockUtil.getStep(ScriptValuesMod.class, ScriptValuesMetaMod.class, "test");
        RowMeta input = new RowMeta();
        input.addValueMeta((ValueMetaInterface)new ValueMetaString("str"));
        step.setInputRowMeta((RowMetaInterface)input);
        step = (ScriptValuesMod)Mockito.spy((Object)step);
        ((ScriptValuesMod)Mockito.doReturn((Object)new Object[]{""}).when((Object)step)).getRow();
        ScriptValuesMetaMod meta = new ScriptValuesMetaMod();
        meta.setCompatible(false);
        meta.allocate(1);
        meta.setFieldname(new String[]{"str"});
        meta.setType(new int[]{2});
        meta.setReplace(new boolean[]{true});
        meta.setJSScripts(new ScriptValuesScript[]{new ScriptValuesScript(0, "script", "setVariable('temp', 'pass', 'r');\nstr = getVariable('temp', 'fail');")});
        ScriptValuesModData data = new ScriptValuesModData();
        step.init((StepMetaInterface)meta, (StepDataInterface)data);
        Object[] expectedRow = new Object[]{"pass"};
        Object[] row = TransTestingUtil.execute((BaseStep)step, (StepMetaInterface)meta, (StepDataInterface)data, 1, false).get(0);
        TransTestingUtil.assertResult(expectedRow, row);
    }
}

