/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.scriptvalues_mod;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.initializer.InitializerInterface;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.BooleanLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.IntLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.PrimitiveBooleanArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.PrimitiveIntArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.di.trans.steps.scriptvalues_mod.ScriptValuesMetaMod;
import org.pentaho.di.trans.steps.scriptvalues_mod.ScriptValuesScript;
import org.powermock.reflect.Whitebox;

public class ScriptValuesMetaModTest
implements InitializerInterface<StepMetaInterface> {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    LoadSaveTester loadSaveTester;
    Class<ScriptValuesMetaMod> testMetaClass = ScriptValuesMetaMod.class;

    @Before
    public void setUpLoadSave() throws Exception {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
        List<String> attributes = Arrays.asList("fieldname", "rename", "type", "length", "precision", "replace", "jsScripts", "compatible", "optimizationLevel");
        HashMap<String, String> getterMap = new HashMap<String, String>(){
            {
                this.put("fieldname", "getFieldname");
                this.put("rename", "getRename");
                this.put("type", "getType");
                this.put("length", "getLength");
                this.put("precision", "getPrecision");
                this.put("replace", "getReplace");
                this.put("compatible", "isCompatible");
                this.put("optimizationLevel", "getOptimizationLevel");
                this.put("jsScripts", "getJSScripts");
            }
        };
        HashMap<String, String> setterMap = new HashMap<String, String>(){
            {
                this.put("fieldname", "setFieldname");
                this.put("rename", "setRename");
                this.put("type", "setType");
                this.put("length", "setLength");
                this.put("precision", "setPrecision");
                this.put("replace", "setReplace");
                this.put("compatible", "setCompatible");
                this.put("optimizationLevel", "setOptimizationLevel");
                this.put("jsScripts", "setJSScripts");
            }
        };
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5);
        ArrayLoadSaveValidator<ScriptValuesScript> svsArrayLoadSaveValidator = new ArrayLoadSaveValidator<ScriptValuesScript>(new ScriptValuesScriptLoadSaveValidator(), 5);
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("fieldname", stringArrayLoadSaveValidator);
        attrValidatorMap.put("rename", stringArrayLoadSaveValidator);
        attrValidatorMap.put("type", new PrimitiveIntArrayLoadSaveValidator(new IntLoadSaveValidator(9), 5));
        attrValidatorMap.put("length", new PrimitiveIntArrayLoadSaveValidator(new IntLoadSaveValidator(100), 5));
        attrValidatorMap.put("precision", new PrimitiveIntArrayLoadSaveValidator(new IntLoadSaveValidator(6), 5));
        attrValidatorMap.put("replace", new PrimitiveBooleanArrayLoadSaveValidator(new BooleanLoadSaveValidator(), 5));
        attrValidatorMap.put("jsScripts", svsArrayLoadSaveValidator);
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<StepMetaInterface>(this.testMetaClass, attributes, new ArrayList<String>(), new ArrayList<String>(), (Map<String, String>)getterMap, (Map<String, String>)setterMap, attrValidatorMap, typeValidatorMap, this);
    }

    @Override
    public void modify(StepMetaInterface someMeta) {
        if (someMeta instanceof ScriptValuesMetaMod) {
            ((ScriptValuesMetaMod)someMeta).allocate(5);
        }
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    @Test
    public void testExtend() {
        ScriptValuesMetaMod meta = new ScriptValuesMetaMod();
        int size = 1;
        meta.extend(size);
        Assert.assertEquals((long)size, (long)meta.getFieldname().length);
        Assert.assertNull((Object)meta.getFieldname()[0]);
        Assert.assertEquals((long)size, (long)meta.getRename().length);
        Assert.assertNull((Object)meta.getRename()[0]);
        Assert.assertEquals((long)size, (long)meta.getType().length);
        Assert.assertEquals((long)-1L, (long)meta.getType()[0]);
        Assert.assertEquals((long)size, (long)meta.getLength().length);
        Assert.assertEquals((long)-1L, (long)meta.getLength()[0]);
        Assert.assertEquals((long)size, (long)meta.getPrecision().length);
        Assert.assertEquals((long)-1L, (long)meta.getPrecision()[0]);
        Assert.assertEquals((long)size, (long)meta.getReplace().length);
        Assert.assertFalse((boolean)meta.getReplace()[0]);
        meta = new ScriptValuesMetaMod();
        Whitebox.setInternalState((Object)meta, (String)"fieldname", (Object[])new String[]{"Field 1", "Field 2", "Field 3"});
        Whitebox.setInternalState((Object)meta, (String)"rename", (Object[])new String[]{"Field 1 - new"});
        Whitebox.setInternalState((Object)meta, (String)"type", (Object)new int[]{2, 5, 1});
        meta.extend(3);
        this.validateExtended(meta);
    }

    private void validateExtended(ScriptValuesMetaMod meta) {
        Assert.assertEquals((long)3L, (long)meta.getFieldname().length);
        Assert.assertEquals((Object)"Field 1", (Object)meta.getFieldname()[0]);
        Assert.assertEquals((Object)"Field 2", (Object)meta.getFieldname()[1]);
        Assert.assertEquals((Object)"Field 3", (Object)meta.getFieldname()[2]);
        Assert.assertEquals((long)3L, (long)meta.getRename().length);
        Assert.assertEquals((Object)"Field 1 - new", (Object)meta.getRename()[0]);
        Assert.assertNull((Object)meta.getRename()[1]);
        Assert.assertNull((Object)meta.getRename()[2]);
        Assert.assertEquals((long)3L, (long)meta.getType().length);
        Assert.assertEquals((long)2L, (long)meta.getType()[0]);
        Assert.assertEquals((long)5L, (long)meta.getType()[1]);
        Assert.assertEquals((long)1L, (long)meta.getType()[2]);
        Assert.assertEquals((long)3L, (long)meta.getLength().length);
        Assert.assertEquals((long)-1L, (long)meta.getLength()[0]);
        Assert.assertEquals((long)-1L, (long)meta.getLength()[1]);
        Assert.assertEquals((long)-1L, (long)meta.getLength()[2]);
        Assert.assertEquals((long)3L, (long)meta.getPrecision().length);
        Assert.assertEquals((long)-1L, (long)meta.getPrecision()[0]);
        Assert.assertEquals((long)-1L, (long)meta.getPrecision()[1]);
        Assert.assertEquals((long)-1L, (long)meta.getPrecision()[2]);
        Assert.assertEquals((long)3L, (long)meta.getReplace().length);
        Assert.assertFalse((boolean)meta.getReplace()[0]);
        Assert.assertFalse((boolean)meta.getReplace()[1]);
        Assert.assertFalse((boolean)meta.getReplace()[2]);
    }

    public class ScriptValuesScriptLoadSaveValidator
    implements FieldLoadSaveValidator<ScriptValuesScript> {
        final Random rand = new Random();

        @Override
        public ScriptValuesScript getTestObject() {
            int scriptType = this.rand.nextInt(4);
            if (scriptType == 3) {
                scriptType = -1;
            }
            ScriptValuesScript rtn = new ScriptValuesScript(scriptType, UUID.randomUUID().toString(), UUID.randomUUID().toString());
            return rtn;
        }

        @Override
        public boolean validateTestObject(ScriptValuesScript testObject, Object actual) {
            if (!(actual instanceof ScriptValuesScript)) {
                return false;
            }
            return actual.toString().equals(testObject.toString());
        }
    }
}

