/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.scriptvalues_mod;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.job.Job;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.steps.scriptvalues_mod.ScriptValuesAddedFunctions;

public class ScriptValueAddFunctions_SetVariableScopeTest {
    private static final String VARIABLE_NAME = "variable-name";
    private static final String VARIABLE_VALUE = "variable-value";

    @Test
    public void setParentScopeVariable_ParentIsTrans() {
        Trans parent = this.createTrans();
        Trans child = this.createTrans(parent);
        ScriptValuesAddedFunctions.setParentScopeVariable((Trans)child, (String)VARIABLE_NAME, (String)VARIABLE_VALUE);
        ((Trans)Mockito.verify((Object)child)).setVariable((String)Matchers.eq((Object)VARIABLE_NAME), (String)Matchers.eq((Object)VARIABLE_VALUE));
        ((Trans)Mockito.verify((Object)parent)).setVariable((String)Matchers.eq((Object)VARIABLE_NAME), (String)Matchers.eq((Object)VARIABLE_VALUE));
    }

    @Test
    public void setParentScopeVariable_ParentIsJob() {
        Job parent = this.createJob();
        Trans child = this.createTrans(parent);
        ScriptValuesAddedFunctions.setParentScopeVariable((Trans)child, (String)VARIABLE_NAME, (String)VARIABLE_VALUE);
        ((Trans)Mockito.verify((Object)child)).setVariable((String)Matchers.eq((Object)VARIABLE_NAME), (String)Matchers.eq((Object)VARIABLE_VALUE));
        ((Job)Mockito.verify((Object)parent)).setVariable((String)Matchers.eq((Object)VARIABLE_NAME), (String)Matchers.eq((Object)VARIABLE_VALUE));
    }

    @Test
    public void setParentScopeVariable_NoParent() {
        Trans trans = this.createTrans();
        ScriptValuesAddedFunctions.setParentScopeVariable((Trans)trans, (String)VARIABLE_NAME, (String)VARIABLE_VALUE);
        ((Trans)Mockito.verify((Object)trans)).setVariable((String)Matchers.eq((Object)VARIABLE_NAME), (String)Matchers.eq((Object)VARIABLE_VALUE));
    }

    @Test
    public void setGrandParentScopeVariable_TwoLevelHierarchy() {
        Trans parent = this.createTrans();
        Trans child = this.createTrans(parent);
        ScriptValuesAddedFunctions.setGrandParentScopeVariable((Trans)child, (String)VARIABLE_NAME, (String)VARIABLE_VALUE);
        ((Trans)Mockito.verify((Object)child)).setVariable((String)Matchers.eq((Object)VARIABLE_NAME), (String)Matchers.eq((Object)VARIABLE_VALUE));
        ((Trans)Mockito.verify((Object)parent)).setVariable((String)Matchers.eq((Object)VARIABLE_NAME), (String)Matchers.eq((Object)VARIABLE_VALUE));
    }

    @Test
    public void setGrandParentScopeVariable_ThreeLevelHierarchy() {
        Job grandParent = this.createJob();
        Trans parent = this.createTrans(grandParent);
        Trans child = this.createTrans(parent);
        ScriptValuesAddedFunctions.setGrandParentScopeVariable((Trans)child, (String)VARIABLE_NAME, (String)VARIABLE_VALUE);
        ((Trans)Mockito.verify((Object)child)).setVariable((String)Matchers.eq((Object)VARIABLE_NAME), (String)Matchers.eq((Object)VARIABLE_VALUE));
        ((Trans)Mockito.verify((Object)parent)).setVariable((String)Matchers.eq((Object)VARIABLE_NAME), (String)Matchers.eq((Object)VARIABLE_VALUE));
        ((Job)Mockito.verify((Object)grandParent)).setVariable((String)Matchers.eq((Object)VARIABLE_NAME), (String)Matchers.eq((Object)VARIABLE_VALUE));
    }

    @Test
    public void setGrandParentScopeVariable_FourLevelHierarchy() {
        Job grandGrandParent = this.createJob();
        Trans grandParent = this.createTrans(grandGrandParent);
        Trans parent = this.createTrans(grandParent);
        Trans child = this.createTrans(parent);
        ScriptValuesAddedFunctions.setGrandParentScopeVariable((Trans)child, (String)VARIABLE_NAME, (String)VARIABLE_VALUE);
        ((Trans)Mockito.verify((Object)child)).setVariable((String)Matchers.eq((Object)VARIABLE_NAME), (String)Matchers.eq((Object)VARIABLE_VALUE));
        ((Trans)Mockito.verify((Object)parent)).setVariable((String)Matchers.eq((Object)VARIABLE_NAME), (String)Matchers.eq((Object)VARIABLE_VALUE));
        ((Trans)Mockito.verify((Object)grandParent)).setVariable((String)Matchers.eq((Object)VARIABLE_NAME), (String)Matchers.eq((Object)VARIABLE_VALUE));
        ((Job)Mockito.verify((Object)grandGrandParent, (VerificationMode)Mockito.never())).setVariable((String)Matchers.eq((Object)VARIABLE_NAME), (String)Matchers.eq((Object)VARIABLE_VALUE));
    }

    @Test
    public void setGrandParentScopeVariable_NoParent() {
        Trans trans = this.createTrans();
        ScriptValuesAddedFunctions.setGrandParentScopeVariable((Trans)trans, (String)VARIABLE_NAME, (String)VARIABLE_VALUE);
        ((Trans)Mockito.verify((Object)trans)).setVariable((String)Matchers.eq((Object)VARIABLE_NAME), (String)Matchers.eq((Object)VARIABLE_VALUE));
    }

    @Test
    public void setRootScopeVariable_TwoLevelHierarchy() {
        Trans parent = this.createTrans();
        Trans child = this.createTrans(parent);
        ScriptValuesAddedFunctions.setRootScopeVariable((Trans)child, (String)VARIABLE_NAME, (String)VARIABLE_VALUE);
        ((Trans)Mockito.verify((Object)child)).setVariable((String)Matchers.eq((Object)VARIABLE_NAME), (String)Matchers.eq((Object)VARIABLE_VALUE));
        ((Trans)Mockito.verify((Object)parent)).setVariable((String)Matchers.eq((Object)VARIABLE_NAME), (String)Matchers.eq((Object)VARIABLE_VALUE));
    }

    @Test
    public void setRootScopeVariable_FourLevelHierarchy() {
        Job grandGrandParent = this.createJob();
        Trans grandParent = this.createTrans(grandGrandParent);
        Trans parent = this.createTrans(grandParent);
        Trans child = this.createTrans(parent);
        ScriptValuesAddedFunctions.setRootScopeVariable((Trans)child, (String)VARIABLE_NAME, (String)VARIABLE_VALUE);
        ((Trans)Mockito.verify((Object)child)).setVariable((String)Matchers.eq((Object)VARIABLE_NAME), (String)Matchers.eq((Object)VARIABLE_VALUE));
        ((Trans)Mockito.verify((Object)parent)).setVariable((String)Matchers.eq((Object)VARIABLE_NAME), (String)Matchers.eq((Object)VARIABLE_VALUE));
        ((Trans)Mockito.verify((Object)grandParent)).setVariable((String)Matchers.eq((Object)VARIABLE_NAME), (String)Matchers.eq((Object)VARIABLE_VALUE));
        ((Job)Mockito.verify((Object)grandGrandParent)).setVariable((String)Matchers.eq((Object)VARIABLE_NAME), (String)Matchers.eq((Object)VARIABLE_VALUE));
    }

    @Test
    public void setRootScopeVariable_NoParent() {
        Trans trans = this.createTrans();
        ScriptValuesAddedFunctions.setRootScopeVariable((Trans)trans, (String)VARIABLE_NAME, (String)VARIABLE_VALUE);
        ((Trans)Mockito.verify((Object)trans)).setVariable((String)Matchers.eq((Object)VARIABLE_NAME), (String)Matchers.eq((Object)VARIABLE_VALUE));
    }

    @Test
    public void setSystemScopeVariable_NoParent() {
        Trans trans = this.createTrans();
        Assert.assertNull((Object)System.getProperty(VARIABLE_NAME));
        try {
            ScriptValuesAddedFunctions.setSystemScopeVariable((Trans)trans, (String)VARIABLE_NAME, (String)VARIABLE_VALUE);
            Assert.assertEquals((Object)System.getProperty(VARIABLE_NAME), (Object)VARIABLE_VALUE);
            ((Trans)Mockito.verify((Object)trans)).setVariable((String)Matchers.eq((Object)VARIABLE_NAME), (String)Matchers.eq((Object)VARIABLE_VALUE));
        }
        finally {
            System.clearProperty(VARIABLE_NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void setSystemScopeVariable_FourLevelHierarchy() {
        Job grandGrandParent = this.createJob();
        Trans grandParent = this.createTrans(grandGrandParent);
        Trans parent = this.createTrans(grandParent);
        Trans child = this.createTrans(parent);
        Assert.assertNull((Object)System.getProperty(VARIABLE_NAME));
        try {
            ScriptValuesAddedFunctions.setSystemScopeVariable((Trans)child, (String)VARIABLE_NAME, (String)VARIABLE_VALUE);
            Assert.assertEquals((Object)System.getProperty(VARIABLE_NAME), (Object)VARIABLE_VALUE);
            ((Trans)Mockito.verify((Object)child)).setVariable((String)Matchers.eq((Object)VARIABLE_NAME), (String)Matchers.eq((Object)VARIABLE_VALUE));
            ((Trans)Mockito.verify((Object)parent)).setVariable((String)Matchers.eq((Object)VARIABLE_NAME), (String)Matchers.eq((Object)VARIABLE_VALUE));
            ((Trans)Mockito.verify((Object)grandParent)).setVariable((String)Matchers.eq((Object)VARIABLE_NAME), (String)Matchers.eq((Object)VARIABLE_VALUE));
            ((Job)Mockito.verify((Object)grandGrandParent)).setVariable((String)Matchers.eq((Object)VARIABLE_NAME), (String)Matchers.eq((Object)VARIABLE_VALUE));
        }
        finally {
            System.clearProperty(VARIABLE_NAME);
        }
    }

    private Trans createTrans(Trans parent) {
        Trans trans = this.createTrans();
        trans.setParent((LoggingObjectInterface)parent);
        trans.setParentVariableSpace((VariableSpace)parent);
        return trans;
    }

    private Trans createTrans(Job parent) {
        Trans trans = this.createTrans();
        trans.setParentJob(parent);
        trans.setParentVariableSpace((VariableSpace)parent);
        return trans;
    }

    private Trans createTrans() {
        Trans trans = new Trans();
        trans.setLog((LogChannelInterface)Mockito.mock(LogChannelInterface.class));
        trans = (Trans)Mockito.spy((Object)trans);
        return trans;
    }

    private Job createJob() {
        Job job = new Job();
        job = (Job)Mockito.spy((Object)job);
        return job;
    }
}

