/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.sasinput;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.ListLoadSaveValidator;
import org.pentaho.di.trans.steps.sasinput.SasInputField;
import org.pentaho.di.trans.steps.sasinput.SasInputMeta;

public class SasInputMetaTest {
    LoadSaveTester loadSaveTester;
    Class<SasInputMeta> testMetaClass = SasInputMeta.class;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Before
    public void setUpLoadSave() throws Exception {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
        List<String> attributes = Arrays.asList("acceptingField", "outputFields");
        HashMap<String, String> gsMap = new HashMap<String, String>();
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("outputFields", new ListLoadSaveValidator<SasInputField>(new SasInputFieldLoadSaveValidator(), 5));
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<SasInputMeta>(this.testMetaClass, attributes, gsMap, gsMap, attrValidatorMap, typeValidatorMap);
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    public class SasInputFieldLoadSaveValidator
    implements FieldLoadSaveValidator<SasInputField> {
        final Random rand = new Random();

        @Override
        public SasInputField getTestObject() {
            SasInputField rtn = new SasInputField();
            rtn.setRename(UUID.randomUUID().toString());
            rtn.setDecimalSymbol(UUID.randomUUID().toString());
            rtn.setConversionMask(UUID.randomUUID().toString());
            rtn.setGroupingSymbol(UUID.randomUUID().toString());
            rtn.setName(UUID.randomUUID().toString());
            rtn.setTrimType(this.rand.nextInt(4));
            rtn.setPrecision(this.rand.nextInt(9));
            rtn.setType(this.rand.nextInt(7));
            rtn.setLength(this.rand.nextInt(50));
            return rtn;
        }

        @Override
        public boolean validateTestObject(SasInputField testObject, Object actual) {
            if (!(actual instanceof SasInputField)) {
                return false;
            }
            SasInputField another = (SasInputField)actual;
            return new EqualsBuilder().append((Object)testObject.getName(), (Object)another.getName()).append(testObject.getTrimType(), another.getTrimType()).append(testObject.getType(), another.getType()).append(testObject.getPrecision(), another.getPrecision()).append((Object)testObject.getRename(), (Object)another.getRename()).append((Object)testObject.getDecimalSymbol(), (Object)another.getDecimalSymbol()).append((Object)testObject.getConversionMask(), (Object)another.getConversionMask()).append((Object)testObject.getGroupingSymbol(), (Object)another.getGroupingSymbol()).append(testObject.getLength(), another.getLength()).isEquals();
        }
    }
}

