/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.rssinput;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.initializer.InitializerInterface;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.di.trans.steps.rssinput.RssInputField;
import org.pentaho.di.trans.steps.rssinput.RssInputMeta;

public class RssInputMetaTest
implements InitializerInterface<StepMetaInterface> {
    LoadSaveTester loadSaveTester;
    Class<RssInputMeta> testMetaClass = RssInputMeta.class;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Before
    public void setUpLoadSave() throws Exception {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
        List<String> attributes = Arrays.asList("includeRowNumber", "rowNumberField", "includeUrl", "urlField", "rowLimit", "readfrom", "urlInField", "urlFieldname", "url", "inputFields");
        HashMap<String, String> getterMap = new HashMap<String, String>(){
            {
                this.put("includeRowNumber", "includeRowNumber");
                this.put("rowNumberField", "getRowNumberField");
                this.put("includeUrl", "includeUrl");
                this.put("urlField", "geturlField");
                this.put("rowLimit", "getRowLimit");
                this.put("readfrom", "getReadFrom");
                this.put("urlInField", "urlInField");
                this.put("urlFieldname", "getUrlFieldname");
                this.put("url", "getUrl");
                this.put("inputFields", "getInputFields");
            }
        };
        HashMap<String, String> setterMap = new HashMap<String, String>(){
            {
                this.put("includeRowNumber", "setIncludeRowNumber");
                this.put("rowNumberField", "setRowNumberField");
                this.put("includeUrl", "setIncludeUrl");
                this.put("urlField", "seturlField");
                this.put("rowLimit", "setRowLimit");
                this.put("readfrom", "setReadFrom");
                this.put("urlInField", "seturlInField");
                this.put("urlFieldname", "setUrlFieldname");
                this.put("url", "setUrl");
                this.put("inputFields", "setInputFields");
            }
        };
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5);
        ArrayLoadSaveValidator<RssInputField> rssInputFieldArrayLoadSaveValidator = new ArrayLoadSaveValidator<RssInputField>(new RssInputFieldLoadSaveValidator(), 5);
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("url", stringArrayLoadSaveValidator);
        attrValidatorMap.put("inputFields", rssInputFieldArrayLoadSaveValidator);
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<StepMetaInterface>(this.testMetaClass, attributes, new ArrayList<String>(), new ArrayList<String>(), (Map<String, String>)getterMap, (Map<String, String>)setterMap, attrValidatorMap, typeValidatorMap, this);
    }

    @Override
    public void modify(StepMetaInterface someMeta) {
        if (someMeta instanceof RssInputMeta) {
            ((RssInputMeta)someMeta).allocate(5, 5);
        }
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    public class RssInputFieldLoadSaveValidator
    implements FieldLoadSaveValidator<RssInputField> {
        final Random rand = new Random();

        @Override
        public RssInputField getTestObject() {
            RssInputField rtn = new RssInputField();
            rtn.setCurrencySymbol(UUID.randomUUID().toString());
            rtn.setDecimalSymbol(UUID.randomUUID().toString());
            rtn.setFormat(UUID.randomUUID().toString());
            rtn.setGroupSymbol(UUID.randomUUID().toString());
            rtn.setName(UUID.randomUUID().toString());
            rtn.setTrimType(this.rand.nextInt(ValueMetaBase.trimTypeCode.length));
            rtn.setPrecision(this.rand.nextInt(9));
            rtn.setRepeated(this.rand.nextBoolean());
            rtn.setLength(this.rand.nextInt(50));
            rtn.setType(this.rand.nextInt(ValueMetaBase.typeCodes.length));
            rtn.setColumn(this.rand.nextInt(RssInputField.ColumnCode.length));
            return rtn;
        }

        @Override
        public boolean validateTestObject(RssInputField testObject, Object actual) {
            if (!(actual instanceof RssInputField)) {
                return false;
            }
            RssInputField actualInput = (RssInputField)actual;
            boolean tst1 = testObject.getXML().equals(actualInput.getXML());
            RssInputField aClone = (RssInputField)((RssInputField)actual).clone();
            boolean tst2 = testObject.getXML().equals(aClone.getXML());
            return tst1 && tst2;
        }
    }
}

