/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.rowgenerator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.MemoryRepository;
import org.pentaho.di.trans.steps.loadsave.initializer.InitializerInterface;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.IntLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.PrimitiveIntArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.di.trans.steps.rowgenerator.RowGeneratorMeta;
import org.pentaho.metastore.api.IMetaStore;

public class RowGeneratorMetaTest
implements InitializerInterface<StepMetaInterface> {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private Repository rep;
    private ObjectId id_step;
    private final String launchVariable = "${ROW_LIMIT}";
    private final String rowGeneratorRowLimitCode = "limit";
    private LoadSaveTester<?> loadSaveTester;
    private Class<RowGeneratorMeta> testMetaClass = RowGeneratorMeta.class;

    @Before
    public void setUp() throws KettleException {
        this.rep = new MemoryRepository();
        this.id_step = new StringObjectId("aStringObjectID");
        this.rep.saveStepAttribute((ObjectId)new StringObjectId("transId"), this.id_step, "limit", "${ROW_LIMIT}");
    }

    @Test
    public void testReadRowLimitAsStringFromRepository() throws KettleException {
        RowGeneratorMeta rowGeneratorMeta = new RowGeneratorMeta();
        IMetaStore metaStore = (IMetaStore)Mockito.mock(IMetaStore.class);
        DatabaseMeta dbMeta = (DatabaseMeta)Mockito.mock(DatabaseMeta.class);
        rowGeneratorMeta.readRep(this.rep, metaStore, this.id_step, Collections.singletonList(dbMeta));
        Assert.assertEquals((Object)rowGeneratorMeta.getRowLimit(), (Object)"${ROW_LIMIT}");
    }

    @Before
    public void setUpLoadSave() throws Exception {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
        List<String> attributes = Arrays.asList("neverEnding", "intervalInMs", "rowTimeField", "lastTimeField", "rowLimit", "currency", "decimal", "group", "value", "fieldName", "fieldType", "fieldFormat", "fieldLength", "fieldPrecision");
        HashMap<String, String> getterMap = new HashMap<String, String>(){
            {
                this.put("neverEnding", "isNeverEnding");
                this.put("intervalInMs", "getIntervalInMs");
                this.put("rowTimeField", "getRowTimeField");
                this.put("lastTimeField", "getLastTimeField");
                this.put("rowLimit", "getRowLimit");
                this.put("currency", "getCurrency");
                this.put("decimal", "getDecimal");
                this.put("group", "getGroup");
                this.put("value", "getValue");
                this.put("fieldName", "getFieldName");
                this.put("fieldType", "getFieldType");
                this.put("fieldFormat", "getFieldFormat");
                this.put("fieldLength", "getFieldLength");
                this.put("fieldPrecision", "getFieldPrecision");
            }
        };
        HashMap<String, String> setterMap = new HashMap<String, String>(){
            {
                this.put("neverEnding", "setNeverEnding");
                this.put("intervalInMs", "setIntervalInMs");
                this.put("rowTimeField", "setRowTimeField");
                this.put("lastTimeField", "setLastTimeField");
                this.put("rowLimit", "setRowLimit");
                this.put("currency", "setCurrency");
                this.put("decimal", "setDecimal");
                this.put("group", "setGroup");
                this.put("value", "setValue");
                this.put("fieldName", "setFieldName");
                this.put("fieldType", "setFieldType");
                this.put("fieldFormat", "setFieldFormat");
                this.put("fieldLength", "setFieldLength");
                this.put("fieldPrecision", "setFieldPrecision");
            }
        };
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5);
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("currency", stringArrayLoadSaveValidator);
        attrValidatorMap.put("decimal", stringArrayLoadSaveValidator);
        attrValidatorMap.put("group", stringArrayLoadSaveValidator);
        attrValidatorMap.put("value", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fieldName", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fieldType", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fieldFormat", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fieldLength", new PrimitiveIntArrayLoadSaveValidator(new IntLoadSaveValidator(100), 5));
        attrValidatorMap.put("fieldPrecision", new PrimitiveIntArrayLoadSaveValidator(new IntLoadSaveValidator(9), 5));
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<StepMetaInterface>(this.testMetaClass, attributes, new ArrayList<String>(), new ArrayList<String>(), (Map<String, String>)getterMap, (Map<String, String>)setterMap, attrValidatorMap, typeValidatorMap, this);
    }

    @Override
    public void modify(StepMetaInterface someMeta) {
        if (someMeta instanceof RowGeneratorMeta) {
            ((RowGeneratorMeta)someMeta).allocate(5);
        }
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }
}

