/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.rest;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.rest.Rest;
import org.pentaho.di.trans.steps.rest.RestData;
import org.pentaho.di.trans.steps.rest.RestMeta;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ApacheHttpClient4.class})
public class RestTest {
    @Test
    public void testCreateMultivalueMap() {
        StepMeta stepMeta = new StepMeta();
        stepMeta.setName("TestRest");
        TransMeta transMeta = new TransMeta();
        transMeta.setName("TestRest");
        transMeta.addStep(stepMeta);
        Rest rest = new Rest(stepMeta, (StepDataInterface)Mockito.mock(StepDataInterface.class), 1, transMeta, (Trans)Mockito.mock(Trans.class));
        MultivaluedMapImpl map = rest.createMultivalueMap("param1", "{a:{[val1]}}");
        String val1 = map.getFirst("param1");
        Assert.assertTrue((boolean)val1.contains("%7D"));
    }

    @Test
    public void testCallEndpointWithDeleteVerb() throws KettleException {
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Content-Type", (Object)"application/json");
        ClientResponse response = (ClientResponse)Mockito.mock(ClientResponse.class);
        ((ClientResponse)Mockito.doReturn((Object)200).when((Object)response)).getStatus();
        ((ClientResponse)Mockito.doReturn((Object)headers).when((Object)response)).getHeaders();
        ((ClientResponse)Mockito.doReturn((Object)"true").when((Object)response)).getEntity(String.class);
        WebResource.Builder builder = (WebResource.Builder)Mockito.mock(WebResource.Builder.class);
        ((WebResource.Builder)Mockito.doReturn((Object)response).when((Object)builder)).delete(ClientResponse.class);
        WebResource resource = (WebResource)Mockito.mock(WebResource.class);
        ((WebResource)Mockito.doReturn((Object)builder).when((Object)resource)).getRequestBuilder();
        ApacheHttpClient4 client = (ApacheHttpClient4)Mockito.mock(ApacheHttpClient4.class);
        ((ApacheHttpClient4)Mockito.doReturn((Object)resource).when((Object)client)).resource(Matchers.anyString());
        PowerMockito.mockStatic(ApacheHttpClient4.class, (Class[])new Class[0]);
        Mockito.when((Object)ApacheHttpClient4.create((ClientConfig)((ClientConfig)Matchers.any()))).thenReturn((Object)client);
        RestMeta meta = (RestMeta)Mockito.mock(RestMeta.class);
        ((RestMeta)Mockito.doReturn((Object)false).when((Object)meta)).isDetailed();
        ((RestMeta)Mockito.doReturn((Object)false).when((Object)meta)).isUrlInField();
        ((RestMeta)Mockito.doReturn((Object)false).when((Object)meta)).isDynamicMethod();
        RowMetaInterface rmi = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        ((RowMetaInterface)Mockito.doReturn((Object)1).when((Object)rmi)).size();
        RestData data = (RestData)Mockito.mock(RestData.class);
        data.method = "DELETE";
        data.inputRowMeta = rmi;
        data.resultFieldName = "result";
        data.resultCodeFieldName = "status";
        data.resultHeaderFieldName = "headers";
        Rest rest = (Rest)Mockito.mock(Rest.class);
        ((Rest)Mockito.doCallRealMethod().when((Object)rest)).callRest((Object[])Matchers.any());
        ((Rest)Mockito.doCallRealMethod().when((Object)rest)).searchForHeaders((ClientResponse)Matchers.any());
        Whitebox.setInternalState((Object)rest, (String)"meta", (Object)meta);
        Whitebox.setInternalState((Object)rest, (String)"data", (Object)data);
        Object[] output = rest.callRest(new Object[]{0});
        ((WebResource.Builder)Mockito.verify((Object)builder, (VerificationMode)Mockito.times((int)1))).delete(ClientResponse.class);
        Assert.assertEquals((Object)"true", (Object)output[1]);
        Assert.assertEquals((Object)200L, (Object)output[2]);
        Assert.assertEquals((Object)"{\"Content-Type\":\"application\\/json\"}", (Object)output[3]);
    }
}

