/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.encryption.TwoWayPasswordEncoderPluginType;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.di.trans.steps.rest.RestMeta;
import org.pentaho.metastore.api.IMetaStore;

public class RestMetaTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @BeforeClass
    public static void beforeClass() throws KettleException {
        PluginRegistry.addPluginType((PluginTypeInterface)TwoWayPasswordEncoderPluginType.getInstance());
        PluginRegistry.init();
        String passwordEncoderPluginID = Const.NVL((String)EnvUtil.getSystemProperty((String)"KETTLE_PASSWORD_ENCODER_PLUGIN"), (String)"Kettle");
        Encr.init((String)passwordEncoderPluginID);
    }

    @Test
    public void testLoadSaveRoundTrip() throws KettleException {
        List<String> attributes = Arrays.asList("applicationType", "method", "url", "urlInField", "dynamicMethod", "methodFieldName", "urlField", "bodyField", "httpLogin", "httpPassword", "proxyHost", "proxyPort", "preemptive", "trustStoreFile", "trustStorePassword", "headerField", "headerName", "parameterField", "parameterName", "matrixParameterField", "matrixParameterName", "fieldName", "resultCodeFieldName", "responseTimeFieldName", "responseHeaderFieldName");
        HashMap fieldLoadSaveValidatorAttributeMap = new HashMap();
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 25);
        fieldLoadSaveValidatorAttributeMap.put("headerField", stringArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("headerName", stringArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("parameterField", stringArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("parameterName", stringArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("matrixParameterField", stringArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("matrixParameterName", stringArrayLoadSaveValidator);
        LoadSaveTester<RestMeta> loadSaveTester = new LoadSaveTester<RestMeta>(RestMeta.class, attributes, new HashMap<String, String>(), new HashMap<String, String>(), fieldLoadSaveValidatorAttributeMap, new HashMap());
        loadSaveTester.testSerialization();
    }

    @Test
    public void testStepChecks() {
        RestMeta meta = new RestMeta();
        ArrayList<CheckResultInterface> remarks = new ArrayList<CheckResultInterface>();
        TransMeta transMeta = new TransMeta();
        StepMeta step = new StepMeta();
        RowMeta prev = new RowMeta();
        RowMeta info = new RowMeta();
        String[] input = new String[]{};
        String[] output = new String[]{};
        Variables variables = new Variables();
        Repository repo = null;
        IMetaStore metaStore = null;
        remarks.clear();
        meta.check(remarks, transMeta, step, (RowMetaInterface)prev, input, output, (RowMetaInterface)info, (VariableSpace)variables, repo, metaStore);
        int errorsDefault = RestMetaTest.getCheckResultErrorCount(remarks);
        Assert.assertTrue((errorsDefault > 0 ? 1 : 0) != 0);
        meta.setUrlInField(true);
        meta.setUrlField("urlField");
        prev.addValueMeta((ValueMetaInterface)new ValueMetaString("urlField"));
        remarks.clear();
        meta.check(remarks, transMeta, step, (RowMetaInterface)prev, input, output, (RowMetaInterface)info, (VariableSpace)variables, repo, metaStore);
        int errorsCurrent = RestMetaTest.getCheckResultErrorCount(remarks);
        Assert.assertTrue((errorsDefault > errorsCurrent ? 1 : 0) != 0);
    }

    private static int getCheckResultErrorCount(List<CheckResultInterface> remarks) {
        return remarks.stream().filter(p -> p.getType() == 4).collect(Collectors.toList()).size();
    }

    @Test
    public void testEntityEnclosingMethods() {
        Assert.assertTrue((boolean)RestMeta.isActiveBody((String)"POST"));
        Assert.assertTrue((boolean)RestMeta.isActiveBody((String)"PUT"));
        Assert.assertTrue((boolean)RestMeta.isActiveBody((String)"PATCH"));
        Assert.assertFalse((boolean)RestMeta.isActiveBody((String)"GET"));
        Assert.assertFalse((boolean)RestMeta.isActiveBody((String)"DELETE"));
        Assert.assertFalse((boolean)RestMeta.isActiveBody((String)"HEAD"));
        Assert.assertFalse((boolean)RestMeta.isActiveBody((String)"OPTIONS"));
    }
}

