/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.replacestring;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.replacestring.ReplaceString;
import org.pentaho.di.trans.steps.replacestring.ReplaceStringData;
import org.pentaho.di.trans.steps.replacestring.ReplaceStringMeta;

public class ReplaceStringTest {
    private static final String LITERAL_STRING = "[a-z]{2,7}";
    private static final String INPUT_STRING = "This is String This Is String THIS IS STRING";
    private Object[] row = new Object[]{"some data", "another data"};
    private Object[] expectedRow = new Object[]{"some data", "1nother d1t1", "1no2her d121", null, null, null, null, null, null, null, null, null, null};
    private StepMockHelper<ReplaceStringMeta, ReplaceStringData> stepMockHelper;

    @Before
    public void setUp() throws Exception {
        this.stepMockHelper = new StepMockHelper<ReplaceStringMeta, ReplaceStringData>("REPLACE STRING TEST", ReplaceStringMeta.class, ReplaceStringData.class);
        Mockito.when((Object)this.stepMockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.stepMockHelper.logChannelInterface);
        ((LogChannelInterface)Mockito.verify((Object)this.stepMockHelper.logChannelInterface, (VerificationMode)Mockito.never())).logError(Matchers.anyString());
        ((LogChannelInterface)Mockito.verify((Object)this.stepMockHelper.logChannelInterface, (VerificationMode)Mockito.never())).logError(Matchers.anyString(), (Object[])Matchers.any(Object[].class));
        ((LogChannelInterface)Mockito.verify((Object)this.stepMockHelper.logChannelInterface, (VerificationMode)Mockito.never())).logError(Matchers.anyString(), (Throwable)Matchers.anyObject());
        Mockito.when((Object)this.stepMockHelper.trans.isRunning()).thenReturn((Object)true);
    }

    @After
    public void tearDown() throws Exception {
        this.stepMockHelper.cleanUp();
    }

    @Test
    public void testGetOneRow() throws Exception {
        ReplaceStringData data = new ReplaceStringData();
        ReplaceString replaceString = new ReplaceString(this.stepMockHelper.stepMeta, (StepDataInterface)data, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        RowMeta inputRowMeta = new RowMeta();
        inputRowMeta.addValueMeta(0, (ValueMetaInterface)new ValueMetaString("SomeDataMeta"));
        inputRowMeta.addValueMeta(1, (ValueMetaInterface)new ValueMetaString("AnotherDataMeta"));
        replaceString.init(this.stepMockHelper.processRowsStepMetaInterface, (StepDataInterface)data);
        replaceString.setInputRowMeta((RowMetaInterface)inputRowMeta);
        data.outputRowMeta = inputRowMeta;
        data.outputRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("AnotherDataMeta"));
        data.inputFieldsNr = 2;
        data.numFields = 2;
        data.inStreamNrs = new int[]{1, 1};
        data.patterns = new Pattern[]{Pattern.compile("a"), Pattern.compile("t")};
        data.replaceFieldIndex = new int[]{-1, -1};
        data.outStreamNrs = new String[]{"", "1"};
        data.replaceByString = new String[]{"1", "2"};
        data.setEmptyString = new boolean[]{false, false};
        Object[] output = replaceString.getOneRow((RowMetaInterface)inputRowMeta, this.row);
        Assert.assertArrayEquals((String)"Output varies", (Object[])this.expectedRow, (Object[])output);
    }

    @Test
    public void testSynchronizeDifferentFieldsArraysLengths() throws Exception {
        ReplaceStringData data = new ReplaceStringData();
        ReplaceString replaceString = new ReplaceString(this.stepMockHelper.stepMeta, (StepDataInterface)data, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        ReplaceStringMeta meta = new ReplaceStringMeta();
        replaceString.init((StepMetaInterface)meta, (StepDataInterface)data);
        meta.setFieldInStream(new String[]{"input1", "input2"});
        meta.setFieldOutStream(new String[]{"out"});
        meta.setUseRegEx(new int[]{1});
        meta.setCaseSensitive(new int[]{0});
        meta.setWholeWord(new int[]{1});
        meta.setReplaceString(new String[]{"string"});
        meta.setReplaceByString(new String[]{"string"});
        meta.setEmptyString(new boolean[]{true});
        meta.setFieldReplaceByString(new String[]{"string"});
        meta.afterInjectionSynchronization();
        Assert.assertEquals((long)meta.getFieldInStream().length, (long)meta.getFieldOutStream().length);
        Assert.assertEquals((Object)"", (Object)meta.getFieldOutStream()[1]);
        Assert.assertEquals((long)meta.getFieldInStream().length, (long)meta.getUseRegEx().length);
        Assert.assertEquals((long)0L, (long)meta.getUseRegEx()[1]);
        Assert.assertEquals((long)meta.getFieldInStream().length, (long)meta.getCaseSensitive().length);
        Assert.assertEquals((long)0L, (long)meta.getCaseSensitive()[1]);
        Assert.assertEquals((long)meta.getFieldInStream().length, (long)meta.getWholeWord().length);
        Assert.assertEquals((long)0L, (long)meta.getWholeWord()[1]);
        Assert.assertEquals((long)meta.getFieldInStream().length, (long)meta.getReplaceString().length);
        Assert.assertEquals((Object)"", (Object)meta.getReplaceString()[1]);
        Assert.assertEquals((long)meta.getFieldInStream().length, (long)meta.getReplaceByString().length);
        Assert.assertEquals((Object)"", (Object)meta.getReplaceByString()[1]);
        Assert.assertEquals((long)meta.getFieldInStream().length, (long)meta.isSetEmptyString().length);
        Assert.assertEquals((Object)false, (Object)meta.isSetEmptyString()[1]);
        Assert.assertEquals((long)meta.getFieldInStream().length, (long)meta.getFieldReplaceByString().length);
        Assert.assertEquals((Object)"", (Object)meta.getFieldReplaceByString()[1]);
    }

    @Test
    public void testBuildPatternWithLiteralParsingAndWholeWord() throws Exception {
        Pattern actualPattern = ReplaceString.buildPattern((boolean)true, (boolean)true, (boolean)true, (String)LITERAL_STRING, (boolean)false);
        Matcher matcher = actualPattern.matcher(INPUT_STRING);
        String actualString = matcher.replaceAll("are");
        Assert.assertEquals((Object)INPUT_STRING, (Object)actualString);
    }

    @Test
    public void testBuildPatternWithNonLiteralParsingAndWholeWord() throws Exception {
        Pattern actualPattern = ReplaceString.buildPattern((boolean)false, (boolean)true, (boolean)true, (String)LITERAL_STRING, (boolean)false);
        Matcher matcher = actualPattern.matcher(INPUT_STRING);
        String actualString = matcher.replaceAll("are");
        Assert.assertEquals((Object)"This are String This Is String THIS IS STRING", (Object)actualString);
    }

    @Test
    public void testProcessRow() throws Exception {
        ReplaceStringData data = new ReplaceStringData();
        ReplaceString replaceString = (ReplaceString)Mockito.spy((Object)new ReplaceString(this.stepMockHelper.stepMeta, (StepDataInterface)data, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans));
        RowMeta inputRowMeta = new RowMeta();
        byte[] array = new byte[]{0, 97, 0, 65, -1, 65, -1, 33};
        byte[] matcharray = new byte[]{-1, 33};
        String match = new String(matcharray, "UTF-16BE");
        Object[] _row = new Object[]{new String(array, "UTF-16BE"), "another data"};
        ((ReplaceString)Mockito.doReturn((Object)_row).when((Object)replaceString)).getRow();
        inputRowMeta.addValueMeta(0, (ValueMetaInterface)new ValueMetaString("string"));
        ReplaceStringMeta meta = (ReplaceStringMeta)this.stepMockHelper.processRowsStepMetaInterface;
        ((ReplaceStringMeta)Mockito.doReturn((Object)new String[]{"string"}).when((Object)meta)).getFieldInStream();
        ((ReplaceStringMeta)Mockito.doReturn((Object)new String[]{"output"}).when((Object)meta)).getFieldOutStream();
        ((ReplaceStringMeta)Mockito.doReturn((Object)new int[]{1}).when((Object)meta)).isUnicode();
        ((ReplaceStringMeta)Mockito.doReturn((Object)new int[]{0}).when((Object)meta)).getUseRegEx();
        ((ReplaceStringMeta)Mockito.doReturn((Object)new int[]{0}).when((Object)meta)).getCaseSensitive();
        ((ReplaceStringMeta)Mockito.doReturn((Object)new int[]{0}).when((Object)meta)).getWholeWord();
        ((ReplaceStringMeta)Mockito.doReturn((Object)new String[]{match}).when((Object)meta)).getReplaceString();
        ((ReplaceStringMeta)Mockito.doReturn((Object)new String[]{""}).when((Object)meta)).getFieldReplaceByString();
        ((ReplaceStringMeta)Mockito.doReturn((Object)new String[]{"matched"}).when((Object)meta)).getReplaceByString();
        ((ReplaceStringMeta)Mockito.doReturn((Object)new boolean[]{false}).when((Object)meta)).isSetEmptyString();
        replaceString.init((StepMetaInterface)meta, (StepDataInterface)data);
        replaceString.setInputRowMeta((RowMetaInterface)inputRowMeta);
        data.outputRowMeta = inputRowMeta;
        data.inputFieldsNr = 1;
        data.numFields = 1;
        data.inStreamNrs = new int[]{0};
        data.replaceFieldIndex = new int[]{-1};
        data.outStreamNrs = new String[]{"", "1"};
        data.replaceByString = new String[]{"1"};
        data.setEmptyString = new boolean[]{false, false};
        replaceString.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        System.out.println(replaceString.getRow()[1]);
        Assert.assertTrue((String)"Expected: aAmatchedmatched", (boolean)"aAmatchedmatched".equals(replaceString.getRow()[1]));
    }
}

