/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.replacestring;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.BooleanLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.IntLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.PrimitiveBooleanArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.PrimitiveIntegerArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.di.trans.steps.replacestring.ReplaceStringMeta;
import org.pentaho.metastore.api.IMetaStore;

public class ReplaceStringMetaTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private static final String FIELD_NAME = "test";
    private static final String ENCODING_NAME = "UTF-8";

    @Test
    public void testGetFields() throws KettleStepException {
        ReplaceStringMeta meta = new ReplaceStringMeta();
        meta.setFieldInStream(new String[]{FIELD_NAME});
        meta.setFieldOutStream(new String[]{FIELD_NAME});
        ValueMetaInterface inputFieldMeta = (ValueMetaInterface)Mockito.mock(ValueMetaInterface.class);
        Mockito.when((Object)inputFieldMeta.getStringEncoding()).thenReturn((Object)ENCODING_NAME);
        RowMetaInterface inputRowMeta = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        Mockito.when((Object)inputRowMeta.searchValueMeta(Mockito.anyString())).thenReturn((Object)inputFieldMeta);
        StepMeta nextStep = (StepMeta)Mockito.mock(StepMeta.class);
        VariableSpace space = (VariableSpace)Mockito.mock(VariableSpace.class);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        IMetaStore metaStore = (IMetaStore)Mockito.mock(IMetaStore.class);
        meta.getFields(inputRowMeta, FIELD_NAME, null, nextStep, space, repository, metaStore);
        ArgumentCaptor argument = ArgumentCaptor.forClass(ValueMetaInterface.class);
        ((RowMetaInterface)Mockito.verify((Object)inputRowMeta)).addValueMeta((ValueMetaInterface)argument.capture());
        Assert.assertEquals((Object)ENCODING_NAME, (Object)((ValueMetaInterface)argument.getValue()).getStringEncoding());
    }

    @Test
    public void testRoundTrips() throws KettleException {
        List<String> attributes = Arrays.asList("in_stream_name", "out_stream_name", "use_regex", "replace_string", "replace_by_string", "set_empty_string", "replace_field_by_string", "whole_word", "case_sensitive", "is_unicode");
        HashMap<String, String> getterMap = new HashMap<String, String>();
        getterMap.put("in_stream_name", "getFieldInStream");
        getterMap.put("out_stream_name", "getFieldOutStream");
        getterMap.put("use_regex", "getUseRegEx");
        getterMap.put("replace_string", "getReplaceString");
        getterMap.put("replace_by_string", "getReplaceByString");
        getterMap.put("set_empty_string", "isSetEmptyString");
        getterMap.put("replace_field_by_string", "getFieldReplaceByString");
        getterMap.put("whole_word", "getWholeWord");
        getterMap.put("case_sensitive", "getCaseSensitive");
        getterMap.put("is_unicode", "isUnicode");
        HashMap<String, String> setterMap = new HashMap<String, String>();
        setterMap.put("in_stream_name", "setFieldInStream");
        setterMap.put("out_stream_name", "setFieldOutStream");
        setterMap.put("use_regex", "setUseRegEx");
        setterMap.put("replace_string", "setReplaceString");
        setterMap.put("replace_by_string", "setReplaceByString");
        setterMap.put("set_empty_string", "setEmptyString");
        setterMap.put("replace_field_by_string", "setFieldReplaceByString");
        setterMap.put("whole_word", "setWholeWord");
        setterMap.put("case_sensitive", "setCaseSensitive");
        setterMap.put("is_unicode", "setIsUnicode");
        HashMap fieldLoadSaveValidatorAttributeMap = new HashMap();
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 25);
        PrimitiveBooleanArrayLoadSaveValidator booleanArrayLoadSaveValidator = new PrimitiveBooleanArrayLoadSaveValidator(new BooleanLoadSaveValidator(), 25);
        PrimitiveIntegerArrayLoadSaveValidator useRegExArrayLoadSaveValidator = new PrimitiveIntegerArrayLoadSaveValidator(new IntLoadSaveValidator(ReplaceStringMeta.useRegExCode.length), 25);
        PrimitiveIntegerArrayLoadSaveValidator wholeWordArrayLoadSaveValidator = new PrimitiveIntegerArrayLoadSaveValidator(new IntLoadSaveValidator(ReplaceStringMeta.wholeWordCode.length), 25);
        PrimitiveIntegerArrayLoadSaveValidator caseSensitiveArrayLoadSaveValidator = new PrimitiveIntegerArrayLoadSaveValidator(new IntLoadSaveValidator(ReplaceStringMeta.caseSensitiveCode.length), 25);
        PrimitiveIntegerArrayLoadSaveValidator isUnicodeArrayLoadSaveValidator = new PrimitiveIntegerArrayLoadSaveValidator(new IntLoadSaveValidator(ReplaceStringMeta.isUnicodeCode.length), 25);
        fieldLoadSaveValidatorAttributeMap.put("in_stream_name", stringArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("out_stream_name", stringArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("use_regex", useRegExArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("replace_string", stringArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("replace_by_string", stringArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("set_empty_string", booleanArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("replace_field_by_string", stringArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("whole_word", wholeWordArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("case_sensitive", caseSensitiveArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("is_unicode", isUnicodeArrayLoadSaveValidator);
        LoadSaveTester<ReplaceStringMeta> loadSaveTester = new LoadSaveTester<ReplaceStringMeta>(ReplaceStringMeta.class, attributes, getterMap, setterMap, fieldLoadSaveValidatorAttributeMap, new HashMap());
        loadSaveTester.testSerialization();
    }

    @Test
    public void testPDI16559() throws Exception {
        ReplaceStringMeta replaceString = new ReplaceStringMeta();
        replaceString.setFieldInStream(new String[]{"field1", "field2", "field3", "field4", "field5"});
        replaceString.setFieldOutStream(new String[]{"outField1", "outField2", "outField3"});
        replaceString.setReplaceString(new String[]{"rep1", "rep 2", "rep 3"});
        replaceString.setReplaceByString(new String[]{"by1", "by 2"});
        replaceString.setFieldReplaceByString(new String[]{"fieldby1", "fieldby2", "fieldby3", "fieldby4"});
        replaceString.setUseRegEx(new int[]{0, 1, 0});
        replaceString.setWholeWord(new int[]{1, 1, 0, 0, 1});
        replaceString.setCaseSensitive(new int[]{1, 0, 0, 1});
        replaceString.setEmptyString(new boolean[]{true, false});
        replaceString.setIsUnicode(new int[]{1, 0, 0, 1});
        try {
            String badXml = replaceString.getXML();
            Assert.fail((String)"Before calling afterInjectionSynchronization, should have thrown an ArrayIndexOOB");
        }
        catch (Exception badXml) {
            // empty catch block
        }
        replaceString.afterInjectionSynchronization();
        String ktrXml = replaceString.getXML();
        int targetSz = replaceString.getFieldInStream().length;
        Assert.assertEquals((long)targetSz, (long)replaceString.getFieldOutStream().length);
        Assert.assertEquals((long)targetSz, (long)replaceString.getUseRegEx().length);
        Assert.assertEquals((long)targetSz, (long)replaceString.getReplaceString().length);
        Assert.assertEquals((long)targetSz, (long)replaceString.getReplaceByString().length);
        Assert.assertEquals((long)targetSz, (long)replaceString.isSetEmptyString().length);
        Assert.assertEquals((long)targetSz, (long)replaceString.getFieldReplaceByString().length);
        Assert.assertEquals((long)targetSz, (long)replaceString.getWholeWord().length);
        Assert.assertEquals((long)targetSz, (long)replaceString.getCaseSensitive().length);
        Assert.assertEquals((long)targetSz, (long)replaceString.isUnicode().length);
        Assert.assertEquals((Object)"", (Object)replaceString.getFieldOutStream()[3]);
        Assert.assertEquals((Object)"", (Object)replaceString.getReplaceString()[3]);
        Assert.assertEquals((Object)"", (Object)replaceString.getReplaceByString()[3]);
        Assert.assertEquals((Object)"", (Object)replaceString.getFieldReplaceByString()[4]);
        Assert.assertEquals((Object)"outField1", (Object)replaceString.getFieldOutStream()[0]);
        Assert.assertEquals((long)1L, (long)replaceString.getWholeWord()[0]);
        Assert.assertEquals((Object)true, (Object)replaceString.isSetEmptyString()[0]);
    }
}

