/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.regexeval;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.TransTestingUtil;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.StepMockUtil;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.regexeval.RegexEval;
import org.pentaho.di.trans.steps.regexeval.RegexEvalData;
import org.pentaho.di.trans.steps.regexeval.RegexEvalMeta;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
public class RegexEval_EmptyStringVsNull_Test {
    private StepMockHelper<RegexEvalMeta, StepDataInterface> helper;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @BeforeClass
    public static void initKettle() throws Exception {
        KettleEnvironment.init();
    }

    @Before
    public void setUp() {
        this.helper = StepMockUtil.getStepMockHelper(RegexEvalMeta.class, "RegexEval_EmptyStringVsNull_Test");
    }

    @After
    public void cleanUp() {
        this.helper.cleanUp();
    }

    @Test
    public void emptyAndNullsAreNotDifferent() throws Exception {
        System.setProperty("KETTLE_EMPTY_STRING_DIFFERS_FROM_NULL", "N");
        List<Object[]> expected = Arrays.asList({false, ""}, {false, ""}, {false, null});
        this.executeAndAssertResults(expected);
    }

    @Test
    public void emptyAndNullsAreDifferent() throws Exception {
        System.setProperty("KETTLE_EMPTY_STRING_DIFFERS_FROM_NULL", "Y");
        List<Object[]> expected = Arrays.asList({false, ""}, {false, ""}, {false, null});
        this.executeAndAssertResults(expected);
    }

    private void executeAndAssertResults(List<Object[]> expected) throws Exception {
        RegexEvalMeta meta = new RegexEvalMeta();
        meta.allocate(2);
        meta.getFieldName()[0] = "string";
        meta.getFieldName()[1] = "matcher";
        meta.setFieldType(new int[]{2, 2});
        meta.setResultFieldName("string");
        meta.setReplacefields(true);
        meta.setMatcher("matcher");
        meta.setAllowCaptureGroupsFlag(true);
        RegexEvalData data = new RegexEvalData();
        RegexEval step = this.createAndInitStep(meta, data);
        RowMeta input = new RowMeta();
        input.addValueMeta((ValueMetaInterface)new ValueMetaString("string"));
        input.addValueMeta((ValueMetaInterface)new ValueMetaString("matcher"));
        step.setInputRowMeta((RowMetaInterface)input);
        step = (RegexEval)Mockito.spy((Object)step);
        ((RegexEval)Mockito.doReturn((Object)new String[]{" ", " "}).doReturn((Object)new String[]{"", ""}).doReturn((Object)new String[]{null, null}).when((Object)step)).getRow();
        data.pattern = Pattern.compile("(a)(a)");
        List<Object[]> actual = TransTestingUtil.execute((BaseStep)step, (StepMetaInterface)meta, (StepDataInterface)data, 3, false);
        TransTestingUtil.assertResult(expected, actual);
    }

    private RegexEval createAndInitStep(RegexEvalMeta meta, RegexEvalData data) throws Exception {
        Mockito.when((Object)this.helper.stepMeta.getStepMetaInterface()).thenReturn((Object)meta);
        RegexEval step = new RegexEval(this.helper.stepMeta, (StepDataInterface)data, 0, this.helper.transMeta, this.helper.trans);
        step.init((StepMetaInterface)meta, (StepDataInterface)data);
        return step;
    }
}

