/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.regexeval;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.row.value.ValueMetaPluginType;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.initializer.InitializerInterface;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.IntLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.PrimitiveIntArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.di.trans.steps.regexeval.RegexEvalMeta;

public class RegexEvalMetaTest
implements InitializerInterface<StepMetaInterface> {
    RowMetaInterface mockInputRowMeta;
    VariableSpace mockVariableSpace;
    LoadSaveTester loadSaveTester;
    Class<RegexEvalMeta> testMetaClass = RegexEvalMeta.class;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @BeforeClass
    public static void setupClass() throws KettleException {
        ValueMetaPluginType.getInstance().searchPlugins();
    }

    @Before
    public void setup() {
        this.mockInputRowMeta = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        this.mockVariableSpace = (VariableSpace)Mockito.mock(VariableSpace.class);
    }

    @Test
    public void testGetFieldsReplacesResultFieldIfItExists() throws KettleStepException {
        RegexEvalMeta regexEvalMeta = new RegexEvalMeta();
        String name = "TEST_NAME";
        String resultField = "result";
        regexEvalMeta.setResultFieldName(resultField);
        Mockito.when((Object)this.mockInputRowMeta.indexOfValue(resultField)).thenReturn((Object)0);
        ValueMetaInterface mockValueMeta = (ValueMetaInterface)Mockito.mock(ValueMetaInterface.class);
        String mockName = "MOCK_NAME";
        Mockito.when((Object)mockValueMeta.getName()).thenReturn((Object)mockName);
        Mockito.when((Object)this.mockInputRowMeta.getValueMeta(0)).thenReturn((Object)mockValueMeta);
        regexEvalMeta.setReplacefields(true);
        regexEvalMeta.getFields(this.mockInputRowMeta, name, null, null, this.mockVariableSpace, null, null);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ValueMetaInterface.class);
        ((RowMetaInterface)Mockito.verify((Object)this.mockInputRowMeta)).setValueMeta(Matchers.eq((int)0), (ValueMetaInterface)captor.capture());
        Assert.assertEquals((Object)mockName, (Object)((ValueMetaInterface)captor.getValue()).getName());
    }

    @Test
    public void testGetFieldsAddsResultFieldIfDoesntExist() throws KettleStepException {
        RegexEvalMeta regexEvalMeta = new RegexEvalMeta();
        String name = "TEST_NAME";
        String resultField = "result";
        regexEvalMeta.setResultFieldName(resultField);
        Mockito.when((Object)this.mockInputRowMeta.indexOfValue(resultField)).thenReturn((Object)-1);
        ValueMetaInterface mockValueMeta = (ValueMetaInterface)Mockito.mock(ValueMetaInterface.class);
        String mockName = "MOCK_NAME";
        Mockito.when((Object)this.mockVariableSpace.environmentSubstitute(resultField)).thenReturn((Object)mockName);
        Mockito.when((Object)this.mockInputRowMeta.getValueMeta(0)).thenReturn((Object)mockValueMeta);
        regexEvalMeta.setReplacefields(true);
        regexEvalMeta.getFields(this.mockInputRowMeta, name, null, null, this.mockVariableSpace, null, null);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ValueMetaInterface.class);
        ((RowMetaInterface)Mockito.verify((Object)this.mockInputRowMeta)).addValueMeta((ValueMetaInterface)captor.capture());
        Assert.assertEquals((Object)mockName, (Object)((ValueMetaInterface)captor.getValue()).getName());
    }

    @Test
    public void testGetFieldsReplacesFieldIfItExists() throws KettleStepException {
        String fieldName;
        RegexEvalMeta regexEvalMeta = new RegexEvalMeta();
        String name = "TEST_NAME";
        regexEvalMeta.allocate(1);
        regexEvalMeta.getFieldName()[0] = fieldName = "fieldname";
        Mockito.when((Object)this.mockInputRowMeta.indexOfValue(fieldName)).thenReturn((Object)0);
        ValueMetaInterface mockValueMeta = (ValueMetaInterface)Mockito.mock(ValueMetaInterface.class);
        String mockName = "MOCK_NAME";
        Mockito.when((Object)mockValueMeta.getName()).thenReturn((Object)mockName);
        Mockito.when((Object)this.mockInputRowMeta.getValueMeta(0)).thenReturn((Object)mockValueMeta);
        regexEvalMeta.setReplacefields(true);
        regexEvalMeta.setAllowCaptureGroupsFlag(true);
        regexEvalMeta.getFields(this.mockInputRowMeta, name, null, null, this.mockVariableSpace, null, null);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ValueMetaInterface.class);
        ((RowMetaInterface)Mockito.verify((Object)this.mockInputRowMeta)).setValueMeta(Matchers.eq((int)0), (ValueMetaInterface)captor.capture());
        Assert.assertEquals((Object)mockName, (Object)((ValueMetaInterface)captor.getValue()).getName());
    }

    @Test
    public void testGetFieldsAddsFieldIfDoesntExist() throws KettleStepException {
        String fieldName;
        RegexEvalMeta regexEvalMeta = new RegexEvalMeta();
        String name = "TEST_NAME";
        regexEvalMeta.allocate(1);
        regexEvalMeta.getFieldName()[0] = fieldName = "fieldname";
        Mockito.when((Object)this.mockInputRowMeta.indexOfValue(fieldName)).thenReturn((Object)-1);
        ValueMetaInterface mockValueMeta = (ValueMetaInterface)Mockito.mock(ValueMetaInterface.class);
        String mockName = "MOCK_NAME";
        Mockito.when((Object)this.mockVariableSpace.environmentSubstitute(fieldName)).thenReturn((Object)mockName);
        Mockito.when((Object)this.mockInputRowMeta.getValueMeta(0)).thenReturn((Object)mockValueMeta);
        regexEvalMeta.setReplacefields(true);
        regexEvalMeta.setAllowCaptureGroupsFlag(true);
        regexEvalMeta.getFields(this.mockInputRowMeta, name, null, null, this.mockVariableSpace, null, null);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ValueMetaInterface.class);
        ((RowMetaInterface)Mockito.verify((Object)this.mockInputRowMeta)).addValueMeta((ValueMetaInterface)captor.capture());
        Assert.assertEquals((Object)fieldName, (Object)((ValueMetaInterface)captor.getValue()).getName());
    }

    @Before
    public void setUpLoadSave() throws Exception {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
        List<String> attributes = Arrays.asList("script", "matcher", "resultfieldname", "usevar", "allowcapturegroups", "replacefields", "canoneq", "caseinsensitive", "comment", "dotall", "multiline", "unicode", "unix", "fieldName", "fieldFormat", "fieldGroup", "fieldDecimal", "fieldCurrency", "fieldNullIf", "fieldIfNull", "fieldTrimType", "fieldLength", "fieldPrecision", "fieldType");
        HashMap<String, String> getterMap = new HashMap<String, String>(){
            {
                this.put("script", "getScript");
                this.put("matcher", "getMatcher");
                this.put("resultfieldname", "getResultFieldName");
                this.put("usevar", "isUseVariableInterpolationFlagSet");
                this.put("allowcapturegroups", "isAllowCaptureGroupsFlagSet");
                this.put("replacefields", "isReplacefields");
                this.put("canoneq", "isCanonicalEqualityFlagSet");
                this.put("caseinsensitive", "isCaseInsensitiveFlagSet");
                this.put("comment", "isCommentFlagSet");
                this.put("dotall", "isDotAllFlagSet");
                this.put("multiline", "isMultilineFlagSet");
                this.put("unicode", "isUnicodeFlagSet");
                this.put("unix", "isUnixLineEndingsFlagSet");
                this.put("fieldName", "getFieldName");
                this.put("fieldFormat", "getFieldFormat");
                this.put("fieldGroup", "getFieldGroup");
                this.put("fieldDecimal", "getFieldDecimal");
                this.put("fieldCurrency", "getFieldCurrency");
                this.put("fieldNullIf", "getFieldNullIf");
                this.put("fieldIfNull", "getFieldIfNull");
                this.put("fieldTrimType", "getFieldTrimType");
                this.put("fieldLength", "getFieldLength");
                this.put("fieldPrecision", "getFieldPrecision");
                this.put("fieldType", "getFieldType");
            }
        };
        HashMap<String, String> setterMap = new HashMap<String, String>(){
            {
                this.put("script", "setScript");
                this.put("matcher", "setMatcher");
                this.put("resultfieldname", "setResultFieldName");
                this.put("usevar", "setUseVariableInterpolationFlag");
                this.put("allowcapturegroups", "setAllowCaptureGroupsFlag");
                this.put("replacefields", "setReplacefields");
                this.put("canoneq", "setCanonicalEqualityFlag");
                this.put("caseinsensitive", "setCaseInsensitiveFlag");
                this.put("comment", "setCommentFlag");
                this.put("dotall", "setDotAllFlag");
                this.put("multiline", "setMultilineFlag");
                this.put("unicode", "setUnicodeFlag");
                this.put("unix", "setUnixLineEndingsFlag");
                this.put("fieldName", "setFieldName");
                this.put("fieldFormat", "setFieldFormat");
                this.put("fieldGroup", "setFieldGroup");
                this.put("fieldDecimal", "setFieldDecimal");
                this.put("fieldCurrency", "setFieldCurrency");
                this.put("fieldNullIf", "setFieldNullIf");
                this.put("fieldIfNull", "setFieldIfNull");
                this.put("fieldTrimType", "setFieldTrimType");
                this.put("fieldLength", "setFieldLength");
                this.put("fieldPrecision", "setFieldPrecision");
                this.put("fieldType", "setFieldType");
            }
        };
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5);
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("fieldName", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fieldFormat", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fieldGroup", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fieldDecimal", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fieldCurrency", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fieldNullIf", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fieldIfNull", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fieldTrimType", new PrimitiveIntArrayLoadSaveValidator(new IntLoadSaveValidator(ValueMetaBase.getTrimTypeCodes().length), 5));
        attrValidatorMap.put("fieldLength", new PrimitiveIntArrayLoadSaveValidator(new IntLoadSaveValidator(100), 5));
        attrValidatorMap.put("fieldPrecision", new PrimitiveIntArrayLoadSaveValidator(new IntLoadSaveValidator(9), 5));
        attrValidatorMap.put("fieldType", new PrimitiveIntArrayLoadSaveValidator(new IntLoadSaveValidator(9), 5));
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<StepMetaInterface>(this.testMetaClass, attributes, new ArrayList<String>(), new ArrayList<String>(), (Map<String, String>)getterMap, (Map<String, String>)setterMap, attrValidatorMap, typeValidatorMap, this);
    }

    @Override
    public void modify(StepMetaInterface someMeta) {
        if (someMeta instanceof RegexEvalMeta) {
            ((RegexEvalMeta)someMeta).allocate(5);
        }
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }
}

