/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.propertyinput;

import java.io.ByteArrayInputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.ini4j.Profile;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.initializer.InitializerInterface;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.di.trans.steps.propertyinput.PropertyInput;
import org.pentaho.di.trans.steps.propertyinput.PropertyInputData;
import org.pentaho.di.trans.steps.propertyinput.PropertyInputField;
import org.pentaho.di.trans.steps.propertyinput.PropertyInputMeta;

public class PropertyInputMetaTest
implements InitializerInterface<StepMetaInterface> {
    Class<PropertyInputMeta> testMetaClass = PropertyInputMeta.class;
    LoadSaveTester loadSaveTester;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Before
    public void setUp() throws Exception {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
        List<String> attributes = Arrays.asList("encoding", "fileType", "includeFilename", "resetRowNumber", "resolvevaluevariable", "filenameField", "includeRowNumber", "rowNumberField", "rowLimit", "filefield", "isaddresult", "dynamicFilenameField", "includeIniSection", "iniSectionField", "section", "shortFileFieldName", "pathFieldName", "hiddenFieldName", "lastModificationTimeFieldName", "uriNameFieldName", "rootUriNameFieldName", "extensionFieldName", "sizeFieldName", "fileName", "fileMask", "excludeFileMask", "fileRequired", "includeSubFolders", "inputFields");
        HashMap<String, String> getterMap = new HashMap<String, String>(){
            {
                this.put("encoding", "getEncoding");
                this.put("fileType", "getFileType");
                this.put("includeFilename", "includeFilename");
                this.put("resetRowNumber", "resetRowNumber");
                this.put("resolvevaluevariable", "isResolveValueVariable");
                this.put("filenameField", "getFilenameField");
                this.put("includeRowNumber", "includeRowNumber");
                this.put("rowNumberField", "getRowNumberField");
                this.put("rowLimit", "getRowLimit");
                this.put("filefield", "isFileField");
                this.put("isaddresult", "isAddResultFile");
                this.put("dynamicFilenameField", "getDynamicFilenameField");
                this.put("includeIniSection", "includeIniSection");
                this.put("iniSectionField", "getINISectionField");
                this.put("section", "getSection");
                this.put("shortFileFieldName", "getShortFileNameField");
                this.put("pathFieldName", "getPathField");
                this.put("hiddenFieldName", "isHiddenField");
                this.put("lastModificationTimeFieldName", "getLastModificationDateField");
                this.put("uriNameFieldName", "getUriField");
                this.put("rootUriNameFieldName", "getRootUriField");
                this.put("extensionFieldName", "getExtensionField");
                this.put("sizeFieldName", "getSizeField");
                this.put("fileName", "getFileName");
                this.put("fileMask", "getFileMask");
                this.put("excludeFileMask", "getExcludeFileMask");
                this.put("fileRequired", "getFileRequired");
                this.put("includeSubFolders", "getIncludeSubFolders");
                this.put("inputFields", "getInputFields");
            }
        };
        HashMap<String, String> setterMap = new HashMap<String, String>(){
            {
                this.put("encoding", "setEncoding");
                this.put("fileType", "setFileType");
                this.put("includeFilename", "setIncludeFilename");
                this.put("resetRowNumber", "setResetRowNumber");
                this.put("resolvevaluevariable", "setResolveValueVariable");
                this.put("filenameField", "setFilenameField");
                this.put("includeRowNumber", "setIncludeRowNumber");
                this.put("rowNumberField", "setRowNumberField");
                this.put("rowLimit", "setRowLimit");
                this.put("filefield", "setFileField");
                this.put("isaddresult", "setAddResultFile");
                this.put("dynamicFilenameField", "setDynamicFilenameField");
                this.put("includeIniSection", "setIncludeIniSection");
                this.put("iniSectionField", "setINISectionField");
                this.put("section", "setSection");
                this.put("shortFileFieldName", "setShortFileNameField");
                this.put("pathFieldName", "setPathField");
                this.put("hiddenFieldName", "setIsHiddenField");
                this.put("lastModificationTimeFieldName", "setLastModificationDateField");
                this.put("uriNameFieldName", "setUriField");
                this.put("rootUriNameFieldName", "setRootUriField");
                this.put("extensionFieldName", "setExtensionField");
                this.put("sizeFieldName", "setSizeField");
                this.put("fileName", "setFileName");
                this.put("fileMask", "setFileMask");
                this.put("excludeFileMask", "setExcludeFileMask");
                this.put("fileRequired", "setFileRequired");
                this.put("includeSubFolders", "setIncludeSubFolders");
                this.put("inputFields", "setInputFields");
            }
        };
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5);
        ArrayLoadSaveValidator<PropertyInputField> pifArrayLoadSaveValidator = new ArrayLoadSaveValidator<PropertyInputField>(new PropertyInputFieldLoadSaveValidator(), 5);
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("fileName", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fileMask", stringArrayLoadSaveValidator);
        attrValidatorMap.put("excludeFileMask", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fileRequired", stringArrayLoadSaveValidator);
        attrValidatorMap.put("includeSubFolders", stringArrayLoadSaveValidator);
        attrValidatorMap.put("inputFields", pifArrayLoadSaveValidator);
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<StepMetaInterface>(this.testMetaClass, attributes, new ArrayList<String>(), new ArrayList<String>(), (Map<String, String>)getterMap, (Map<String, String>)setterMap, attrValidatorMap, typeValidatorMap, this);
    }

    @Override
    public void modify(StepMetaInterface propInputMeta) {
        if (propInputMeta instanceof PropertyInputMeta) {
            ((PropertyInputMeta)propInputMeta).allocate(5, 5);
        }
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    @Test
    public void testOpenNextFile() throws Exception {
        PropertyInputMeta propertyInputMeta = (PropertyInputMeta)Mockito.mock(PropertyInputMeta.class);
        PropertyInputData propertyInputData = new PropertyInputData();
        FileInputList fileInputList = new FileInputList();
        FileObject fileObject = (FileObject)Mockito.mock(FileObject.class);
        FileName fileName = (FileName)Mockito.mock(FileName.class);
        Mockito.when((Object)fileName.getRootURI()).thenReturn((Object)"testFolder");
        Mockito.when((Object)fileName.getURI()).thenReturn((Object)"testFileName.ini");
        String header = "test ini data with umlauts";
        String key = "key";
        String testValue = "value-with-\u00e4\u00f6\u00fc";
        String testData = "[" + header + "]\r\n" + key + "=" + testValue;
        String charsetEncode = "Windows-1252";
        ByteArrayInputStream inputStream = new ByteArrayInputStream(testData.getBytes(Charset.forName(charsetEncode)));
        FileContent fileContent = (FileContent)Mockito.mock(FileContent.class);
        Mockito.when((Object)fileObject.getContent()).thenReturn((Object)fileContent);
        Mockito.when((Object)fileContent.getInputStream()).thenReturn((Object)inputStream);
        Mockito.when((Object)fileObject.getName()).thenReturn((Object)fileName);
        fileInputList.addFile(fileObject);
        propertyInputData.files = fileInputList;
        propertyInputData.propfiles = false;
        propertyInputData.realEncoding = charsetEncode;
        PropertyInput propertyInput = (PropertyInput)Mockito.mock(PropertyInput.class);
        Field logField = BaseStep.class.getDeclaredField("log");
        logField.setAccessible(true);
        logField.set(propertyInput, Mockito.mock(LogChannelInterface.class));
        ((PropertyInput)Mockito.doCallRealMethod().when((Object)propertyInput)).dispose((StepMetaInterface)propertyInputMeta, (StepDataInterface)propertyInputData);
        propertyInput.dispose((StepMetaInterface)propertyInputMeta, (StepDataInterface)propertyInputData);
        Method method = PropertyInput.class.getDeclaredMethod("openNextFile", new Class[0]);
        method.setAccessible(true);
        method.invoke((Object)propertyInput, new Object[0]);
        Assert.assertEquals((Object)testValue, (Object)((Profile.Section)propertyInputData.wini.get((Object)header)).get((Object)key));
    }

    public class PropertyInputFieldLoadSaveValidator
    implements FieldLoadSaveValidator<PropertyInputField> {
        final Random rand = new Random();

        @Override
        public PropertyInputField getTestObject() {
            PropertyInputField rtn = new PropertyInputField();
            rtn.setCurrencySymbol(UUID.randomUUID().toString());
            rtn.setDecimalSymbol(UUID.randomUUID().toString());
            rtn.setFormat(UUID.randomUUID().toString());
            rtn.setGroupSymbol(UUID.randomUUID().toString());
            rtn.setName(UUID.randomUUID().toString());
            rtn.setTrimType(this.rand.nextInt(4));
            rtn.setPrecision(this.rand.nextInt(9));
            rtn.setRepeated(this.rand.nextBoolean());
            rtn.setLength(this.rand.nextInt(50));
            rtn.setSamples(new String[]{UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString()});
            return rtn;
        }

        @Override
        public boolean validateTestObject(PropertyInputField testObject, Object actual) {
            if (!(actual instanceof PropertyInputField)) {
                return false;
            }
            PropertyInputField actualInput = (PropertyInputField)actual;
            return testObject.toString().equals(actualInput.toString());
        }
    }
}

