/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.pgbulkloader;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.pgbulkloader.PGBulkLoader;
import org.pentaho.di.trans.steps.pgbulkloader.PGBulkLoaderData;
import org.pentaho.di.trans.steps.pgbulkloader.PGBulkLoaderMeta;

public class PGBulkLoaderTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private StepMockHelper<PGBulkLoaderMeta, PGBulkLoaderData> stepMockHelper;
    private PGBulkLoader pgBulkLoader;
    private static final String CONNECTION_NAME = "PSQLConnect";
    private static final String CONNECTION_DB_NAME = "test1181";
    private static final String CONNECTION_DB_HOST = "localhost";
    private static final String CONNECTION_DB_PORT = "5093";
    private static final String CONNECTION_DB_USERNAME = "postgres";
    private static final String CONNECTION_DB_PASSWORD = "password";
    private static final String DB_NAME_OVVERRIDE = "test1181_2";
    private static final String DB_NAME_EMPTY = "";
    private static final String PG_TEST_CONNECTION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><connection> <name>PSQLConnect</name><server>localhost</server><type>POSTGRESQL</type><access>Native</access><database>test1181</database>  <port>5093</port><username>postgres</username><password>Encrypted 2be98afc86aa7f2e4bb18bd63c99dbdde</password></connection>";

    @BeforeClass
    public static void setupBeforeClass() throws KettleException {
        KettleClientEnvironment.init();
    }

    @Before
    public void setUp() throws Exception {
        this.stepMockHelper = new StepMockHelper<PGBulkLoaderMeta, PGBulkLoaderData>("PostgreSQL Bulk Loader", PGBulkLoaderMeta.class, PGBulkLoaderData.class);
        Mockito.when((Object)this.stepMockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.stepMockHelper.logChannelInterface);
        Mockito.when((Object)this.stepMockHelper.trans.isRunning()).thenReturn((Object)true);
        this.pgBulkLoader = new PGBulkLoader(this.stepMockHelper.stepMeta, this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
    }

    @After
    public void tearDown() throws Exception {
        this.stepMockHelper.cleanUp();
    }

    @Test
    public void testCreateCommandLine() throws Exception {
        PGBulkLoaderMeta meta = (PGBulkLoaderMeta)Mockito.mock(PGBulkLoaderMeta.class);
        ((PGBulkLoaderMeta)Mockito.doReturn((Object)new DatabaseMeta()).when((Object)meta)).getDatabaseMeta();
        ((PGBulkLoaderMeta)Mockito.doReturn((Object)new String[0]).when((Object)meta)).getFieldStream();
        PGBulkLoaderData data = (PGBulkLoaderData)Mockito.mock(PGBulkLoaderData.class);
        PGBulkLoader spy = (PGBulkLoader)Mockito.spy((Object)this.pgBulkLoader);
        ((PGBulkLoader)Mockito.doReturn((Object)new Object[0]).when((Object)spy)).getRow();
        ((PGBulkLoader)Mockito.doReturn((Object)DB_NAME_EMPTY).when((Object)spy)).getCopyCommand();
        ((PGBulkLoader)Mockito.doNothing().when((Object)spy)).connect();
        ((PGBulkLoader)Mockito.doNothing().when((Object)spy)).checkClientEncoding();
        ((PGBulkLoader)Mockito.doNothing().when((Object)spy)).processTruncate();
        spy.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        ((PGBulkLoader)Mockito.verify((Object)spy)).processTruncate();
    }

    @Test
    public void testDBNameOverridden_IfDbNameOverrideSetUp() throws Exception {
        PGBulkLoaderMeta pgBulkLoaderMock = PGBulkLoaderTest.getPgBulkLoaderMock(DB_NAME_OVVERRIDE);
        Database database = this.pgBulkLoader.getDatabase((LoggingObjectInterface)this.pgBulkLoader, pgBulkLoaderMock);
        Assert.assertNotNull((Object)database);
        Assert.assertEquals((Object)DB_NAME_OVVERRIDE, (Object)database.getDatabaseMeta().getDatabaseName());
        Assert.assertEquals((Object)CONNECTION_NAME, (Object)database.getDatabaseMeta().getName());
        Assert.assertEquals((Object)CONNECTION_DB_HOST, (Object)database.getDatabaseMeta().getHostname());
        Assert.assertEquals((Object)CONNECTION_DB_PORT, (Object)database.getDatabaseMeta().getDatabasePortNumberString());
        Assert.assertEquals((Object)CONNECTION_DB_USERNAME, (Object)database.getDatabaseMeta().getUsername());
        Assert.assertEquals((Object)CONNECTION_DB_PASSWORD, (Object)database.getDatabaseMeta().getPassword());
    }

    @Test
    public void testDBNameNOTOverridden_IfDbNameOverrideEmpty() throws Exception {
        PGBulkLoaderMeta pgBulkLoaderMock = PGBulkLoaderTest.getPgBulkLoaderMock(DB_NAME_EMPTY);
        Database database = this.pgBulkLoader.getDatabase((LoggingObjectInterface)this.pgBulkLoader, pgBulkLoaderMock);
        Assert.assertNotNull((Object)database);
        Assert.assertEquals((Object)CONNECTION_DB_NAME, (Object)database.getDatabaseMeta().getDatabaseName());
        Assert.assertEquals((Object)CONNECTION_NAME, (Object)database.getDatabaseMeta().getName());
        Assert.assertEquals((Object)CONNECTION_DB_HOST, (Object)database.getDatabaseMeta().getHostname());
        Assert.assertEquals((Object)CONNECTION_DB_PORT, (Object)database.getDatabaseMeta().getDatabasePortNumberString());
        Assert.assertEquals((Object)CONNECTION_DB_USERNAME, (Object)database.getDatabaseMeta().getUsername());
        Assert.assertEquals((Object)CONNECTION_DB_PASSWORD, (Object)database.getDatabaseMeta().getPassword());
    }

    @Test
    public void testDBNameNOTOverridden_IfDbNameOverrideNull() throws Exception {
        PGBulkLoaderMeta pgBulkLoaderMock = PGBulkLoaderTest.getPgBulkLoaderMock(null);
        Database database = this.pgBulkLoader.getDatabase((LoggingObjectInterface)this.pgBulkLoader, pgBulkLoaderMock);
        Assert.assertNotNull((Object)database);
        Assert.assertEquals((Object)CONNECTION_DB_NAME, (Object)database.getDatabaseMeta().getDatabaseName());
        Assert.assertEquals((Object)CONNECTION_NAME, (Object)database.getDatabaseMeta().getName());
        Assert.assertEquals((Object)CONNECTION_DB_HOST, (Object)database.getDatabaseMeta().getHostname());
        Assert.assertEquals((Object)CONNECTION_DB_PORT, (Object)database.getDatabaseMeta().getDatabasePortNumberString());
        Assert.assertEquals((Object)CONNECTION_DB_USERNAME, (Object)database.getDatabaseMeta().getUsername());
        Assert.assertEquals((Object)CONNECTION_DB_PASSWORD, (Object)database.getDatabaseMeta().getPassword());
    }

    @Test
    public void testProcessRow_StreamIsNull() throws Exception {
        PGBulkLoader pgBulkLoaderStreamIsNull = (PGBulkLoader)Mockito.mock(PGBulkLoader.class);
        ((PGBulkLoader)Mockito.doReturn(null).when((Object)pgBulkLoaderStreamIsNull)).getRow();
        PGBulkLoaderMeta meta = (PGBulkLoaderMeta)Mockito.mock(PGBulkLoaderMeta.class);
        PGBulkLoaderData data = (PGBulkLoaderData)Mockito.mock(PGBulkLoaderData.class);
        Assert.assertEquals((Object)false, (Object)pgBulkLoaderStreamIsNull.processRow((StepMetaInterface)meta, (StepDataInterface)data));
    }

    @Test
    public void testNoDatabaseConnection() {
        try {
            ((PGBulkLoaderMeta)Mockito.doReturn(null).when(this.stepMockHelper.initStepMetaInterface)).getDatabaseMeta();
            Assert.assertFalse((boolean)this.pgBulkLoader.init(this.stepMockHelper.initStepMetaInterface, this.stepMockHelper.initStepDataInterface));
            this.pgBulkLoader.verifyDatabaseConnection();
            Assert.fail((String)"Database Connection is not null, this fails the test.");
        }
        catch (KettleException aKettleException) {
            Assert.assertThat((Object)aKettleException.getMessage(), (Matcher)CoreMatchers.containsString((String)"There is no connection defined in this step."));
        }
    }

    private static PGBulkLoaderMeta getPgBulkLoaderMock(String DbNameOverride) throws KettleXMLException {
        PGBulkLoaderMeta pgBulkLoaderMetaMock = (PGBulkLoaderMeta)Mockito.mock(PGBulkLoaderMeta.class);
        Mockito.when((Object)pgBulkLoaderMetaMock.getDbNameOverride()).thenReturn((Object)DbNameOverride);
        DatabaseMeta databaseMeta = PGBulkLoaderTest.getDatabaseMetaSpy();
        Mockito.when((Object)pgBulkLoaderMetaMock.getDatabaseMeta()).thenReturn((Object)databaseMeta);
        return pgBulkLoaderMetaMock;
    }

    private static DatabaseMeta getDatabaseMetaSpy() throws KettleXMLException {
        DatabaseMeta databaseMeta = (DatabaseMeta)Mockito.spy((Object)new DatabaseMeta(PG_TEST_CONNECTION));
        return databaseMeta;
    }
}

