/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.pentahoreporting;

import java.io.OutputStream;
import java.util.Locale;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.steps.pentahoreporting.PentahoReportingSwingGuiContext;
import org.pentaho.di.trans.steps.pentahoreporting.ReportExportTask;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.layout.output.ReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusType;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.PdfOutputProcessor;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class ReportExportTaskTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private MasterReport masterReport;
    private PentahoReportingSwingGuiContext swingGuiContext;
    private String targetPath;
    private boolean createParentFolder;

    @Before
    public void setUp() {
        this.masterReport = (MasterReport)Mockito.mock(MasterReport.class);
        this.swingGuiContext = (PentahoReportingSwingGuiContext)Mockito.mock(PentahoReportingSwingGuiContext.class);
        this.targetPath = "org.pentaho.di.trans.steps.pentahoreporting.messages.messages";
        this.createParentFolder = false;
    }

    @Test(expected=NullPointerException.class)
    public void testExportReportWithNullReport() {
        this.masterReport = null;
        Mockito.when((Object)this.swingGuiContext.getLocale()).thenReturn((Object)Locale.US);
        Mockito.when((Object)this.swingGuiContext.getStatusListener()).thenReturn(Mockito.mock(StatusListener.class));
        ReportExportTask exportTask = new ReportExportTask(this.masterReport, (SwingGuiContext)this.swingGuiContext, this.targetPath, this.createParentFolder){

            protected ReportProcessor createReportProcessor(OutputStream fout) throws Exception {
                return null;
            }
        };
        Assert.assertNull((Object)exportTask);
    }

    @Test
    public void testExportReportWithSupportedLocale() {
        Mockito.when((Object)this.masterReport.getConfiguration()).thenReturn(Mockito.mock(Configuration.class));
        Mockito.when((Object)this.masterReport.getResourceManager()).thenReturn((Object)new ResourceManager());
        Mockito.when((Object)this.swingGuiContext.getLocale()).thenReturn((Object)Locale.US);
        Mockito.when((Object)this.swingGuiContext.getStatusListener()).thenReturn(Mockito.mock(StatusListener.class));
        ReportExportTask exportTask = new ReportExportTask(this.masterReport, (SwingGuiContext)this.swingGuiContext, this.targetPath, this.createParentFolder){

            protected ReportProcessor createReportProcessor(OutputStream fout) throws Exception {
                PdfOutputProcessor outputProcessor = new PdfOutputProcessor(ReportExportTaskTest.this.masterReport.getConfiguration(), fout, ReportExportTaskTest.this.masterReport.getResourceManager());
                return new PageableReportProcessor(ReportExportTaskTest.this.masterReport, (PageableOutputProcessor)outputProcessor);
            }
        };
        Assert.assertNotNull((Object)exportTask);
        exportTask.run();
        Assert.assertThat((Object)this.swingGuiContext.getStatusType(), (Matcher)IsNot.not((Object)StatusType.ERROR));
    }

    @Test
    public void testExportReportWithUnsupportedLocale() {
        Mockito.when((Object)this.masterReport.getConfiguration()).thenReturn(Mockito.mock(Configuration.class));
        Mockito.when((Object)this.masterReport.getResourceManager()).thenReturn((Object)new ResourceManager());
        Mockito.when((Object)this.swingGuiContext.getLocale()).thenReturn((Object)Locale.UK);
        Mockito.when((Object)this.swingGuiContext.getStatusListener()).thenReturn(Mockito.mock(StatusListener.class));
        ReportExportTask exportTask = new ReportExportTask(this.masterReport, (SwingGuiContext)this.swingGuiContext, this.targetPath, this.createParentFolder){

            protected ReportProcessor createReportProcessor(OutputStream fout) throws Exception {
                PdfOutputProcessor outputProcessor = new PdfOutputProcessor(ReportExportTaskTest.this.masterReport.getConfiguration(), fout, ReportExportTaskTest.this.masterReport.getResourceManager());
                return new PageableReportProcessor(ReportExportTaskTest.this.masterReport, (PageableOutputProcessor)outputProcessor);
            }
        };
        Assert.assertNotNull((Object)exportTask);
        exportTask.run();
        Assert.assertThat((Object)this.swingGuiContext.getStatusType(), (Matcher)IsNot.not((Object)StatusType.ERROR));
    }
}

