/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.orabulkloader;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Date;
import org.apache.poi.util.TempFile;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaNumber;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.orabulkloader.OraBulkLoader;
import org.pentaho.di.trans.steps.orabulkloader.OraBulkLoaderData;
import org.pentaho.di.trans.steps.orabulkloader.OraBulkLoaderMeta;

public class OraBulkLoaderTest {
    private static final String expectedDataContents1 = "OPTIONS(" + Const.CR + "  ERRORS='null'" + Const.CR + "  , ROWS='null'" + Const.CR + ")" + Const.CR + "LOAD DATA" + Const.CR + "INFILE '";
    private static final String expectedDataContents2 = "'" + Const.CR + "INTO TABLE null" + Const.CR + "null" + Const.CR + "FIELDS TERMINATED BY ',' ENCLOSED BY '\"'" + Const.CR + "(null, " + Const.CR + "null CHAR)";
    private StepMockHelper<OraBulkLoaderMeta, OraBulkLoaderData> stepMockHelper;
    private OraBulkLoader oraBulkLoader;
    private File tempControlFile;
    private File tempDataFile;
    private String tempControlFilepath;
    private String tempDataFilepath;
    private String tempControlVfsFilepath;
    private String tempDataVfsFilepath;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @BeforeClass
    public static void setupBeforeClass() throws KettleException {
        KettleClientEnvironment.init();
    }

    @Before
    public void setUp() throws Exception {
        this.stepMockHelper = new StepMockHelper<OraBulkLoaderMeta, OraBulkLoaderData>("TEST_CREATE_COMMANDLINE", OraBulkLoaderMeta.class, OraBulkLoaderData.class);
        Mockito.when((Object)this.stepMockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.stepMockHelper.logChannelInterface);
        Mockito.when((Object)this.stepMockHelper.trans.isRunning()).thenReturn((Object)true);
        this.oraBulkLoader = (OraBulkLoader)Mockito.spy((Object)new OraBulkLoader(this.stepMockHelper.stepMeta, this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans));
        this.tempControlFile = TempFile.createTempFile((String)"control", (String)"test");
        this.tempControlFile.deleteOnExit();
        this.tempDataFile = TempFile.createTempFile((String)"data", (String)"test");
        this.tempDataFile.deleteOnExit();
        this.tempControlFilepath = this.tempControlFile.getAbsolutePath();
        this.tempDataFilepath = this.tempDataFile.getAbsolutePath();
        this.tempControlVfsFilepath = "file:///" + this.tempControlFilepath;
        this.tempDataVfsFilepath = "file:///" + this.tempDataFilepath;
    }

    @After
    public void cleanUp() {
        this.stepMockHelper.cleanUp();
    }

    @Test
    public void testGetControlFileContents() throws Exception {
        String[] streamFields = new String[]{"id", "name"};
        String[] streamTable = new String[]{"id", "name"};
        String[] dateMask = new String[]{"", ""};
        DatabaseMeta databaseMeta = (DatabaseMeta)Mockito.mock(DatabaseMeta.class);
        Object[] rowData = new Object[]{1, "rowdata", new Date()};
        RowMetaInterface rowMetaInterface = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        TransMeta transMeta = (TransMeta)Mockito.spy((Object)new TransMeta());
        ValueMetaNumber idVmi = new ValueMetaNumber("id");
        ValueMetaString nameVmi = new ValueMetaString("name", 20, -1);
        OraBulkLoaderMeta oraBulkLoaderMeta = (OraBulkLoaderMeta)Mockito.spy((Object)new OraBulkLoaderMeta());
        oraBulkLoaderMeta.setDatabaseMeta(databaseMeta);
        oraBulkLoaderMeta.setControlFile(this.tempControlVfsFilepath);
        oraBulkLoaderMeta.setDataFile(this.tempDataVfsFilepath);
        ((OraBulkLoader)Mockito.doReturn((Object)transMeta).when((Object)this.oraBulkLoader)).getTransMeta();
        ((OraBulkLoaderMeta)Mockito.doReturn((Object)streamFields).when((Object)oraBulkLoaderMeta)).getFieldStream();
        ((OraBulkLoaderMeta)Mockito.doReturn((Object)streamTable).when((Object)oraBulkLoaderMeta)).getFieldTable();
        ((OraBulkLoaderMeta)Mockito.doReturn((Object)dateMask).when((Object)oraBulkLoaderMeta)).getDateMask();
        ((RowMetaInterface)Mockito.doReturn((Object)0).when((Object)rowMetaInterface)).indexOfValue("id");
        ((RowMetaInterface)Mockito.doReturn((Object)idVmi).when((Object)rowMetaInterface)).getValueMeta(0);
        ((RowMetaInterface)Mockito.doReturn((Object)1).when((Object)rowMetaInterface)).indexOfValue("name");
        ((RowMetaInterface)Mockito.doReturn((Object)nameVmi).when((Object)rowMetaInterface)).getValueMeta(1);
        String expectedDataContents = expectedDataContents1 + this.tempDataFilepath + expectedDataContents2;
        String actualDataContents = this.oraBulkLoader.getControlFileContents(oraBulkLoaderMeta, rowMetaInterface, rowData);
        Assert.assertEquals((String)"The Expected Control File Contents do not match Actual Contents", (Object)expectedDataContents, (Object)actualDataContents);
    }

    @Test
    public void testCreateControlFile() throws Exception {
        String tempTrueControlFilepath = this.tempControlFile.getAbsolutePath() + "A.txt";
        String expectedControlContents = "test";
        OraBulkLoaderMeta oraBulkLoaderMeta = (OraBulkLoaderMeta)Mockito.mock(OraBulkLoaderMeta.class);
        RowMetaInterface rowMetaInterface = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        Object[] objectRow = new Object[]{};
        ((OraBulkLoader)Mockito.doReturn((Object)rowMetaInterface).when((Object)this.oraBulkLoader)).getInputRowMeta();
        ((OraBulkLoader)Mockito.doReturn((Object)expectedControlContents).when((Object)this.oraBulkLoader)).getControlFileContents(oraBulkLoaderMeta, rowMetaInterface, objectRow);
        this.oraBulkLoader.createControlFile(tempTrueControlFilepath, objectRow, oraBulkLoaderMeta);
        Assert.assertTrue((boolean)Files.exists(Paths.get(tempTrueControlFilepath, new String[0]), new LinkOption[0]));
        File tempTrueControlFile = new File(tempTrueControlFilepath);
        String tempTrueControlFileContents = new String(Files.readAllBytes(tempTrueControlFile.toPath()));
        Assert.assertEquals((Object)expectedControlContents, (Object)tempTrueControlFileContents);
        tempTrueControlFile.delete();
    }

    @Test
    public void testCreateCommandLine() throws Exception {
        File tmp = File.createTempFile("testCreateCOmmandLine", "tmp");
        tmp.deleteOnExit();
        OraBulkLoaderMeta meta = new OraBulkLoaderMeta();
        meta.setSqlldr(tmp.getAbsolutePath());
        meta.setControlFile(tmp.getAbsolutePath());
        DatabaseMeta dm = (DatabaseMeta)Mockito.mock(DatabaseMeta.class);
        Mockito.when((Object)dm.getUsername()).thenReturn((Object)"user");
        Mockito.when((Object)dm.getPassword()).thenReturn((Object)"Encrypted 2be98afc86aa7f2e4cb298b5eeab387f5");
        meta.setDatabaseMeta(dm);
        String cmd = this.oraBulkLoader.createCommandLine(meta, true);
        String expected = tmp.getAbsolutePath() + " control='" + tmp.getAbsolutePath() + "' userid=user/PENTAHO@";
        Assert.assertEquals((String)"Comandline for oracle bulkloader is not as expected", (Object)expected, (Object)cmd);
    }

    @Test
    public void testDispose() throws Exception {
        TransMeta transMeta = (TransMeta)Mockito.spy((Object)new TransMeta());
        OraBulkLoaderData oraBulkLoaderData = new OraBulkLoaderData();
        OraBulkLoaderMeta oraBulkLoaderMeta = new OraBulkLoaderMeta();
        oraBulkLoaderMeta.setDataFile(this.tempDataVfsFilepath);
        oraBulkLoaderMeta.setControlFile(this.tempControlVfsFilepath);
        oraBulkLoaderMeta.setEraseFiles(true);
        oraBulkLoaderMeta.setLoadMethod("AUTO_END");
        Assert.assertTrue((boolean)Files.exists(Paths.get(this.tempControlFilepath, new String[0]), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(Paths.get(this.tempDataFilepath, new String[0]), new LinkOption[0]));
        ((OraBulkLoader)Mockito.doReturn((Object)transMeta).when((Object)this.oraBulkLoader)).getTransMeta();
        this.oraBulkLoader.dispose((StepMetaInterface)oraBulkLoaderMeta, (StepDataInterface)oraBulkLoaderData);
        Assert.assertFalse((boolean)Files.exists(Paths.get(this.tempControlFilepath, new String[0]), new LinkOption[0]));
        Assert.assertFalse((boolean)Files.exists(Paths.get(this.tempDataFilepath, new String[0]), new LinkOption[0]));
    }
}

