/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.orabulkloader;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.DatabaseMetaLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.di.trans.steps.orabulkloader.OraBulkLoaderMeta;

public class OraBulkLoaderMetaTest {
    Class<OraBulkLoaderMeta> testMetaClass = OraBulkLoaderMeta.class;
    LoadSaveTester loadSaveTester;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Before
    public void setUp() throws Exception {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
        List<String> attributes = Arrays.asList("schemaName", "tableName", "sqlldr", "controlFile", "dataFile", "logFile", "badFile", "discardFile", "commitSize", "bindSize", "readSize", "maxErrors", "loadMethod", "loadAction", "encoding", "characterSetName", "directPath", "eraseFiles", "dbNameOverride", "failOnWarning", "failOnError", "parallel", "altRecordTerm", "fieldTable", "fieldStream", "dateMask", "databaseMeta");
        HashMap<String, String> getterMap = new HashMap<String, String>(){
            {
                this.put("schemaName", "getSchemaName");
                this.put("tableName", "getTableName");
                this.put("sqlldr", "getSqlldr");
                this.put("controlFile", "getControlFile");
                this.put("dataFile", "getDataFile");
                this.put("logFile", "getLogFile");
                this.put("badFile", "getBadFile");
                this.put("discardFile", "getDiscardFile");
                this.put("commitSize", "getCommitSize");
                this.put("bindSize", "getBindSize");
                this.put("readSize", "getReadSize");
                this.put("maxErrors", "getMaxErrors");
                this.put("loadMethod", "getLoadMethod");
                this.put("loadAction", "getLoadAction");
                this.put("encoding", "getEncoding");
                this.put("characterSetName", "getCharacterSetName");
                this.put("directPath", "isDirectPath");
                this.put("eraseFiles", "isEraseFiles");
                this.put("dbNameOverride", "getDbNameOverride");
                this.put("failOnWarning", "isFailOnWarning");
                this.put("failOnError", "isFailOnError");
                this.put("parallel", "isParallel");
                this.put("altRecordTerm", "getAltRecordTerm");
                this.put("fieldTable", "getFieldTable");
                this.put("fieldStream", "getFieldStream");
                this.put("dateMask", "getDateMask");
                this.put("databaseMeta", "getDatabaseMeta");
            }
        };
        HashMap<String, String> setterMap = new HashMap<String, String>(){
            {
                this.put("schemaName", "setSchemaName");
                this.put("tableName", "setTableName");
                this.put("sqlldr", "setSqlldr");
                this.put("controlFile", "setControlFile");
                this.put("dataFile", "setDataFile");
                this.put("logFile", "setLogFile");
                this.put("badFile", "setBadFile");
                this.put("discardFile", "setDiscardFile");
                this.put("commitSize", "setCommitSize");
                this.put("bindSize", "setBindSize");
                this.put("readSize", "setReadSize");
                this.put("maxErrors", "setMaxErrors");
                this.put("loadMethod", "setLoadMethod");
                this.put("loadAction", "setLoadAction");
                this.put("encoding", "setEncoding");
                this.put("characterSetName", "setCharacterSetName");
                this.put("directPath", "setDirectPath");
                this.put("eraseFiles", "setEraseFiles");
                this.put("dbNameOverride", "setDbNameOverride");
                this.put("failOnWarning", "setFailOnWarning");
                this.put("failOnError", "setFailOnError");
                this.put("parallel", "setParallel");
                this.put("altRecordTerm", "setAltRecordTerm");
                this.put("fieldTable", "setFieldTable");
                this.put("fieldStream", "setFieldStream");
                this.put("dateMask", "setDateMask");
                this.put("databaseMeta", "setDatabaseMeta");
            }
        };
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5);
        ArrayLoadSaveValidator<String> datemaskArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new DateMaskLoadSaveValidator(), 5);
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("fieldTable", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fieldStream", stringArrayLoadSaveValidator);
        attrValidatorMap.put("dateMask", datemaskArrayLoadSaveValidator);
        attrValidatorMap.put("databaseMeta", new DatabaseMetaLoadSaveValidator());
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<OraBulkLoaderMeta>(this.testMetaClass, attributes, (Map<String, String>)getterMap, (Map<String, String>)setterMap, attrValidatorMap, typeValidatorMap);
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    @Test
    public void testGetXML() {
        OraBulkLoaderMeta oraBulkLoaderMeta = new OraBulkLoaderMeta();
        oraBulkLoaderMeta.setFieldTable(new String[]{"fieldTable1", "fieldTable2"});
        oraBulkLoaderMeta.setFieldStream(new String[]{"fieldStreamValue1"});
        oraBulkLoaderMeta.setDateMask(new String[0]);
        oraBulkLoaderMeta.afterInjectionSynchronization();
        oraBulkLoaderMeta.getXML();
        Assert.assertEquals((long)oraBulkLoaderMeta.getFieldStream().length, (long)oraBulkLoaderMeta.getDateMask().length);
    }

    public class DateMaskLoadSaveValidator
    implements FieldLoadSaveValidator<String> {
        Random r = new Random();

        @Override
        public String getTestObject() {
            boolean ltr = this.r.nextBoolean();
            String dm = ltr ? "DATE" : "DATETIME";
            return dm;
        }

        @Override
        public boolean validateTestObject(String test, Object actual) {
            return test.equals(actual);
        }
    }
}

