/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.orabulkloader;

import java.io.File;
import java.io.IOException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.provider.local.LocalFile;
import org.apache.poi.util.TempFile;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.steps.orabulkloader.OraBulkDataOutput;
import org.pentaho.di.trans.steps.orabulkloader.OraBulkLoaderMeta;

public class OraBulkDataOutputTest {
    private static final String loadMethod = "AUTO_END";
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private OraBulkLoaderMeta oraBulkLoaderMeta;
    private OraBulkDataOutput oraBulkDataOutput;
    private Process sqlldrProcess;
    private VariableSpace space;

    @BeforeClass
    public static void setupBeforeClass() throws KettleException {
        KettleEnvironment.init();
    }

    @Before
    public void setUp() {
        String recTerm = Const.CR;
        this.sqlldrProcess = (Process)Mockito.mock(Process.class);
        this.space = (VariableSpace)Mockito.mock(VariableSpace.class);
        this.oraBulkLoaderMeta = (OraBulkLoaderMeta)Mockito.mock(OraBulkLoaderMeta.class);
        this.oraBulkDataOutput = (OraBulkDataOutput)Mockito.spy((Object)new OraBulkDataOutput(this.oraBulkLoaderMeta, recTerm));
        Mockito.when((Object)this.oraBulkLoaderMeta.getLoadMethod()).thenReturn((Object)loadMethod);
        Mockito.when((Object)this.oraBulkLoaderMeta.getEncoding()).thenReturn(null);
    }

    @Test
    public void testOpen() {
        try {
            File tempFile = TempFile.createTempFile((String)"temp", (String)"test");
            String tempFilePath = tempFile.getAbsolutePath();
            String dataFileVfsPath = "file:///" + tempFilePath;
            LocalFile tempFileObject = (LocalFile)Mockito.mock(LocalFile.class);
            tempFile.deleteOnExit();
            ((OraBulkLoaderMeta)Mockito.doReturn((Object)dataFileVfsPath).when((Object)this.oraBulkLoaderMeta)).getDataFile();
            ((VariableSpace)Mockito.doReturn((Object)tempFilePath).when((Object)this.space)).environmentSubstitute(dataFileVfsPath);
            ((OraBulkDataOutput)Mockito.doReturn((Object)tempFileObject).when((Object)this.oraBulkDataOutput)).getFileObject(tempFilePath, this.space);
            ((OraBulkDataOutput)Mockito.doReturn((Object)tempFilePath).when((Object)this.oraBulkDataOutput)).getFilename((FileObject)tempFileObject);
            this.oraBulkDataOutput.open(this.space, this.sqlldrProcess);
            this.oraBulkDataOutput.close();
        }
        catch (Exception ex) {
            Assert.fail((String)("If any exception occurs, this test fails: " + ex));
        }
    }

    @Test
    public void testOpenFileException() {
        ((OraBulkLoaderMeta)Mockito.doThrow(IOException.class).when((Object)this.oraBulkLoaderMeta)).getDataFile();
        try {
            this.oraBulkDataOutput.open(this.space, this.sqlldrProcess);
            Assert.fail((String)"An IOException was supposed to be thrown, failing test");
        }
        catch (KettleException kex) {
            Assert.assertTrue((boolean)kex.getMessage().contains("IO exception occured:"));
        }
    }
}

