/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.nullif;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.QueueRowSet;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.nullif.NullIf;
import org.pentaho.di.trans.steps.nullif.NullIfData;
import org.pentaho.di.trans.steps.nullif.NullIfMeta;
import org.pentaho.metastore.api.IMetaStore;

public class NullIfTest {
    StepMockHelper<NullIfMeta, NullIfData> smh;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Before
    public void setUp() {
        this.smh = new StepMockHelper<NullIfMeta, NullIfData>("Field NullIf processor", NullIfMeta.class, NullIfData.class);
        Mockito.when((Object)this.smh.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.smh.logChannelInterface);
        Mockito.when((Object)this.smh.trans.isRunning()).thenReturn((Object)true);
    }

    @After
    public void cleanUp() {
        this.smh.cleanUp();
    }

    private RowSet mockInputRowSet() {
        return this.smh.getMockInputRowSet(new Object[][]{{"value1", "nullable-value", "value3"}});
    }

    private NullIfMeta mockProcessRowMeta() throws KettleStepException {
        NullIfMeta processRowMeta = (NullIfMeta)this.smh.processRowsStepMetaInterface;
        NullIfMeta.Field[] fields = NullIfTest.createArrayWithOneField("nullable-field", "nullable-value");
        ((NullIfMeta)Mockito.doReturn((Object)fields).when((Object)processRowMeta)).getFields();
        ((NullIfMeta)Mockito.doCallRealMethod().when((Object)processRowMeta)).getFields((RowMetaInterface)Matchers.any(RowMetaInterface.class), Matchers.anyString(), (RowMetaInterface[])Matchers.any(RowMetaInterface[].class), (StepMeta)Matchers.any(StepMeta.class), (VariableSpace)Matchers.any(VariableSpace.class), (Repository)Matchers.any(Repository.class), (IMetaStore)Matchers.any(IMetaStore.class));
        return processRowMeta;
    }

    private RowMeta getInputRowMeta() {
        RowMeta inputRowMeta = new RowMeta();
        inputRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("some-field"));
        inputRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("nullable-field"));
        inputRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("another-field"));
        return inputRowMeta;
    }

    @Test
    public void test() throws KettleException {
        boolean hasMoreRows;
        KettleEnvironment.init();
        NullIf step = new NullIf(this.smh.stepMeta, this.smh.stepDataInterface, 0, this.smh.transMeta, this.smh.trans);
        step.init(this.smh.initStepMetaInterface, this.smh.stepDataInterface);
        step.setInputRowMeta((RowMetaInterface)this.getInputRowMeta());
        step.addRowSetToInputRowSets(this.mockInputRowSet());
        step.addRowSetToOutputRowSets((RowSet)new QueueRowSet());
        while (hasMoreRows = step.processRow((StepMetaInterface)this.mockProcessRowMeta(), this.smh.processRowsStepDataInterface)) {
        }
        RowSet outputRowSet = (RowSet)step.getOutputRowSets().get(0);
        Object[] actualRow = outputRowSet.getRow();
        Object[] expectedRow = new Object[]{"value1", null, "value3"};
        Assert.assertEquals((String)"Output row is of an unexpected length", (int)expectedRow.length, (int)outputRowSet.getRowMeta().size());
        for (int i = 0; i < expectedRow.length; ++i) {
            Assert.assertEquals((String)("Unexpected output value at index " + i), (Object)expectedRow[i], (Object)actualRow[i]);
        }
    }

    private static NullIfMeta.Field[] createArrayWithOneField(String fieldName, String fieldValue) {
        NullIfMeta.Field field = new NullIfMeta.Field();
        field.setFieldName(fieldName);
        field.setFieldValue(fieldValue);
        return new NullIfMeta.Field[]{field};
    }

    private RowMeta getInputRowMeta2() {
        RowMeta inputRowMeta = new RowMeta();
        ValueMetaDate vmd1 = new ValueMetaDate("value1");
        vmd1.setConversionMask("yyyyMMdd");
        inputRowMeta.addValueMeta((ValueMetaInterface)vmd1);
        ValueMetaDate vmd2 = new ValueMetaDate("value2");
        vmd2.setConversionMask("yyyy/MM/dd HH:mm:ss.SSS");
        inputRowMeta.addValueMeta((ValueMetaInterface)vmd2);
        ValueMetaDate vmd3 = new ValueMetaDate("value3");
        vmd3.setConversionMask("yyyyMMdd");
        inputRowMeta.addValueMeta((ValueMetaInterface)vmd3);
        ValueMetaDate vmd4 = new ValueMetaDate("value4");
        vmd4.setConversionMask("yyyy/MM/dd HH:mm:ss.SSS");
        inputRowMeta.addValueMeta((ValueMetaInterface)vmd4);
        return inputRowMeta;
    }

    private NullIfMeta mockProcessRowMeta2() throws KettleStepException {
        NullIfMeta processRowMeta = (NullIfMeta)this.smh.processRowsStepMetaInterface;
        NullIfMeta.Field[] fields = new NullIfMeta.Field[]{NullIfTest.createArrayWithOneField("value1", "20150606")[0], NullIfTest.createArrayWithOneField("value2", "2015/06/06 00:00:00.000")[0], NullIfTest.createArrayWithOneField("value3", "20150606")[0], NullIfTest.createArrayWithOneField("value4", "2015/06/06 00:00:00.000")[0]};
        ((NullIfMeta)Mockito.doReturn((Object)fields).when((Object)processRowMeta)).getFields();
        ((NullIfMeta)Mockito.doCallRealMethod().when((Object)processRowMeta)).getFields((RowMetaInterface)Matchers.any(RowMetaInterface.class), Matchers.anyString(), (RowMetaInterface[])Matchers.any(RowMetaInterface[].class), (StepMeta)Matchers.any(StepMeta.class), (VariableSpace)Matchers.any(VariableSpace.class), (Repository)Matchers.any(Repository.class), (IMetaStore)Matchers.any(IMetaStore.class));
        return processRowMeta;
    }

    @Test
    public void testDateWithFormat() throws KettleException {
        boolean hasMoreRows;
        KettleEnvironment.init();
        NullIf step = new NullIf(this.smh.stepMeta, this.smh.stepDataInterface, 0, this.smh.transMeta, this.smh.trans);
        step.init(this.smh.initStepMetaInterface, this.smh.stepDataInterface);
        step.setInputRowMeta((RowMetaInterface)this.getInputRowMeta2());
        Date d1 = null;
        Date d2 = null;
        Date d3 = null;
        Date d4 = null;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
            d1 = formatter.parse("20150606");
            d3 = formatter.parse("20150607");
            formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
            d2 = formatter.parse("2015/06/06 00:00:00.000");
            d4 = formatter.parse("2015/07/06 00:00:00.000");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        step.addRowSetToInputRowSets(this.smh.getMockInputRowSet(new Object[][]{{d1, d2, d3, d4}}));
        step.addRowSetToOutputRowSets((RowSet)new QueueRowSet());
        while (hasMoreRows = step.processRow((StepMetaInterface)this.mockProcessRowMeta2(), this.smh.processRowsStepDataInterface)) {
        }
        RowSet outputRowSet = (RowSet)step.getOutputRowSets().get(0);
        Object[] actualRow = outputRowSet.getRow();
        Object[] expectedRow = new Object[]{null, null, d3, d4};
        Assert.assertEquals((String)"Output row is of an unexpected length", (int)expectedRow.length, (int)outputRowSet.getRowMeta().size());
        for (int i = 0; i < expectedRow.length; ++i) {
            Assert.assertEquals((String)("Unexpected output value at index " + i), (Object)expectedRow[i], (Object)actualRow[i]);
        }
    }
}

