/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.nullif;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.nullif.NullIfMeta;

public class NullIfMetaTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    LoadSaveTester loadSaveTester;

    @Before
    public void setUp() throws Exception {
        List<String> attributes = Arrays.asList("fields");
        HashMap<String, String> getterMap = new HashMap<String, String>(){
            {
                this.put("fields", "getFields");
            }
        };
        HashMap<String, String> setterMap = new HashMap<String, String>(){
            {
                this.put("fields", "setFields");
            }
        };
        NullIfMeta.Field field = new NullIfMeta.Field();
        field.setFieldName("fieldName");
        field.setFieldValue("fieldValue");
        ArrayLoadSaveValidator<NullIfMeta.Field> fieldArrayLoadSaveValidator = new ArrayLoadSaveValidator<NullIfMeta.Field>(new NullIfFieldLoadSaveValidator(field), 5);
        HashMap typeValidatorMap = new HashMap();
        typeValidatorMap.put(NullIfMeta.Field[].class.getCanonicalName(), fieldArrayLoadSaveValidator);
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("fields", fieldArrayLoadSaveValidator);
        this.loadSaveTester = new LoadSaveTester<NullIfMeta>(NullIfMeta.class, attributes, (Map<String, String>)getterMap, (Map<String, String>)setterMap, attrValidatorMap, typeValidatorMap);
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    @Test
    public void setFieldValueTest() {
        NullIfMeta.Field field = new NullIfMeta.Field();
        System.setProperty("KETTLE_EMPTY_STRING_DIFFERS_FROM_NULL", "N");
        field.setFieldValue("theValue");
        Assert.assertEquals((Object)"theValue", (Object)field.getFieldValue());
    }

    @Test
    public void setFieldValueNullTest() {
        NullIfMeta.Field field = new NullIfMeta.Field();
        System.setProperty("KETTLE_EMPTY_STRING_DIFFERS_FROM_NULL", "N");
        field.setFieldValue(null);
        Assert.assertEquals(null, (Object)field.getFieldValue());
    }

    @Test
    public void setFieldValueNullWithEmptyStringsDiffersFromNullTest() {
        NullIfMeta.Field field = new NullIfMeta.Field();
        System.setProperty("KETTLE_EMPTY_STRING_DIFFERS_FROM_NULL", "Y");
        field.setFieldValue(null);
        Assert.assertEquals((Object)"", (Object)field.getFieldValue());
    }

    public static class NullIfFieldLoadSaveValidator
    implements FieldLoadSaveValidator<NullIfMeta.Field> {
        private final NullIfMeta.Field defaultValue;

        public NullIfFieldLoadSaveValidator(NullIfMeta.Field defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public NullIfMeta.Field getTestObject() {
            return this.defaultValue;
        }

        @Override
        public boolean validateTestObject(NullIfMeta.Field testObject, Object actual) {
            return EqualsBuilder.reflectionEquals((Object)testObject, (Object)actual);
        }
    }
}

