/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.normalizer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.normaliser.NormaliserMeta;

public class NormalizerMetaTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Test
    public void loadSaveTest() throws KettleException {
        List<String> attributes = Arrays.asList("normaliserFields");
        NormaliserMeta.NormaliserField testField = new NormaliserMeta.NormaliserField();
        testField.setName("TEST_NAME");
        testField.setValue("TEST_VALUE");
        testField.setNorm("TEST");
        HashMap fieldLoadSaveValidatorTypeMap = new HashMap();
        fieldLoadSaveValidatorTypeMap.put(NormaliserMeta.NormaliserField[].class.getCanonicalName(), new ArrayLoadSaveValidator<NormaliserMeta.NormaliserField>(new NormaliserFieldLoadSaveValidator(testField), 50));
        LoadSaveTester<NormaliserMeta> tester = new LoadSaveTester<NormaliserMeta>(NormaliserMeta.class, attributes, new HashMap<String, String>(), new HashMap<String, String>(), new HashMap(), fieldLoadSaveValidatorTypeMap);
        tester.testSerialization();
    }

    public static class NormaliserFieldLoadSaveValidator
    implements FieldLoadSaveValidator<NormaliserMeta.NormaliserField> {
        private final NormaliserMeta.NormaliserField defaultValue;

        public NormaliserFieldLoadSaveValidator(NormaliserMeta.NormaliserField defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public NormaliserMeta.NormaliserField getTestObject() {
            return this.defaultValue;
        }

        @Override
        public boolean validateTestObject(NormaliserMeta.NormaliserField testObject, Object actual) {
            return testObject.equals(actual);
        }
    }
}

