/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.normaliser;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransTestFactory;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.normaliser.NormaliserMeta;

public class NormaliserTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @BeforeClass
    public static void before() throws KettleException {
        KettleEnvironment.init((boolean)false);
    }

    private NormaliserMeta.NormaliserField[] getTestNormaliserFieldsWiki() {
        NormaliserMeta.NormaliserField[] rtn = new NormaliserMeta.NormaliserField[6];
        rtn[0] = new NormaliserMeta.NormaliserField();
        rtn[0].setName("pr_sl");
        rtn[0].setNorm("Product Sales");
        rtn[0].setValue("Product1");
        rtn[1] = new NormaliserMeta.NormaliserField();
        rtn[1].setName("pr1_nr");
        rtn[1].setNorm("Product Number");
        rtn[1].setValue("Product1");
        rtn[2] = new NormaliserMeta.NormaliserField();
        rtn[2].setName("pr2_sl");
        rtn[2].setNorm("Product Sales");
        rtn[2].setValue("Product2");
        rtn[3] = new NormaliserMeta.NormaliserField();
        rtn[3].setName("pr2_nr");
        rtn[3].setNorm("Product Number");
        rtn[3].setValue("Product2");
        rtn[4] = new NormaliserMeta.NormaliserField();
        rtn[4].setName("pr3_sl");
        rtn[4].setNorm("Product Sales");
        rtn[4].setValue("Product3");
        rtn[5] = new NormaliserMeta.NormaliserField();
        rtn[5].setName("pr3_nr");
        rtn[5].setNorm("Product Number");
        rtn[5].setValue("Product3");
        return rtn;
    }

    private List<RowMetaAndData> getExpectedWikiOutputRowMetaAndData() {
        Date theDate = new Date(103, 1, 1);
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMeta rm = new RowMeta();
        rm.addValueMeta((ValueMetaInterface)new ValueMetaDate("DATE"));
        rm.addValueMeta((ValueMetaInterface)new ValueMetaString("Type"));
        rm.addValueMeta((ValueMetaInterface)new ValueMetaInteger("Product Sales"));
        rm.addValueMeta((ValueMetaInterface)new ValueMetaInteger("Product Number"));
        Object[] row = new Object[]{theDate, "Product1", 100, 5};
        list.add(new RowMetaAndData((RowMetaInterface)rm, row));
        row = new Object[]{theDate, "Product2", 250, 10};
        list.add(new RowMetaAndData((RowMetaInterface)rm, row));
        row = new Object[]{theDate, "Product3", 150, 4};
        list.add(new RowMetaAndData((RowMetaInterface)rm, row));
        return list;
    }

    private List<RowMetaAndData> getWikiInputRowMetaAndData() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        Object[] row = new Object[7];
        RowMeta rm = new RowMeta();
        rm.addValueMeta((ValueMetaInterface)new ValueMetaDate("DATE"));
        row[0] = new Date(103, 1, 1);
        rm.addValueMeta((ValueMetaInterface)new ValueMetaInteger("PR1_NR"));
        row[1] = 5;
        rm.addValueMeta((ValueMetaInterface)new ValueMetaInteger("PR_SL"));
        row[2] = 100;
        rm.addValueMeta((ValueMetaInterface)new ValueMetaInteger("PR2_NR"));
        row[3] = 10;
        rm.addValueMeta((ValueMetaInterface)new ValueMetaInteger("PR2_SL"));
        row[4] = 250;
        rm.addValueMeta((ValueMetaInterface)new ValueMetaInteger("PR3_NR"));
        row[5] = 4;
        rm.addValueMeta((ValueMetaInterface)new ValueMetaInteger("PR3_SL"));
        row[6] = 150;
        list.add(new RowMetaAndData((RowMetaInterface)rm, row));
        return list;
    }

    private void checkResults(List<RowMetaAndData> expectedOutput, List<RowMetaAndData> outputList) {
        Assert.assertEquals((long)expectedOutput.size(), (long)outputList.size());
        for (int i = 0; i < outputList.size(); ++i) {
            RowMetaAndData aRowMetaAndData = outputList.get(i);
            RowMetaAndData expectedRowMetaAndData = expectedOutput.get(i);
            RowMetaInterface rowMeta = aRowMetaAndData.getRowMeta();
            RowMetaInterface expectedRowMeta = expectedRowMetaAndData.getRowMeta();
            Object[] fields = rowMeta.getFieldNames();
            Object[] expectedFields = expectedRowMeta.getFieldNames();
            Assert.assertEquals((long)expectedFields.length, (long)fields.length);
            Assert.assertArrayEquals((Object[])expectedFields, (Object[])fields);
            Object[] aRow = aRowMetaAndData.getData();
            Object[] expectedRow = expectedRowMetaAndData.getData();
            Assert.assertEquals((long)expectedRow.length, (long)aRow.length);
            Assert.assertArrayEquals((Object[])expectedRow, (Object[])aRow);
        }
    }

    @Test
    public void testNormaliserProcessRowsWikiData() throws Exception {
        String stepName = "Row Normaliser";
        NormaliserMeta stepMeta = new NormaliserMeta();
        stepMeta.setDefault();
        stepMeta.setNormaliserFields(this.getTestNormaliserFieldsWiki());
        stepMeta.setTypeField("Type");
        TransMeta transMeta = TransTestFactory.generateTestTransformation(null, (StepMetaInterface)stepMeta, "Row Normaliser");
        List<RowMetaAndData> inputList = this.getWikiInputRowMetaAndData();
        List<RowMetaAndData> outputList = TransTestFactory.executeTestTransformation(transMeta, "injector", "Row Normaliser", "dummy", inputList);
        List<RowMetaAndData> expectedOutput = this.getExpectedWikiOutputRowMetaAndData();
        this.checkResults(expectedOutput, outputList);
    }
}

