/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.normaliser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.initializer.InitializerInterface;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.normaliser.NormaliserMeta;

public class NormaliserMetaTest
implements InitializerInterface<StepMetaInterface> {
    LoadSaveTester loadSaveTester;
    Class<NormaliserMeta> testMetaClass = NormaliserMeta.class;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Before
    public void setUpLoadSave() throws Exception {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
        List<String> attributes = Arrays.asList("typeField", "normaliserFields");
        HashMap<String, String> getterMap = new HashMap<String, String>();
        HashMap<String, String> setterMap = new HashMap<String, String>();
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("normaliserFields", new ArrayLoadSaveValidator<NormaliserMeta.NormaliserField>(new NormaliserFieldLoadSaveValidator(), 5));
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<StepMetaInterface>(this.testMetaClass, attributes, new ArrayList<String>(), new ArrayList<String>(), getterMap, setterMap, attrValidatorMap, typeValidatorMap, this);
    }

    @Override
    public void modify(StepMetaInterface someMeta) {
        if (someMeta instanceof NormaliserMeta) {
            ((NormaliserMeta)someMeta).allocate(5);
        }
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    public class NormaliserFieldLoadSaveValidator
    implements FieldLoadSaveValidator<NormaliserMeta.NormaliserField> {
        final Random rand = new Random();

        @Override
        public NormaliserMeta.NormaliserField getTestObject() {
            NormaliserMeta.NormaliserField rtn = new NormaliserMeta.NormaliserField();
            rtn.setName(UUID.randomUUID().toString());
            rtn.setNorm(UUID.randomUUID().toString());
            rtn.setValue(UUID.randomUUID().toString());
            return rtn;
        }

        @Override
        public boolean validateTestObject(NormaliserMeta.NormaliserField testObject, Object actual) {
            if (!(actual instanceof NormaliserMeta.NormaliserField)) {
                return false;
            }
            NormaliserMeta.NormaliserField another = (NormaliserMeta.NormaliserField)actual;
            return new EqualsBuilder().append((Object)testObject.getName(), (Object)another.getName()).append((Object)testObject.getNorm(), (Object)another.getNorm()).append((Object)testObject.getValue(), (Object)another.getValue()).isEquals();
        }
    }
}

