/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.named.cluster;

import java.util.Arrays;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.osgi.api.NamedClusterOsgi;
import org.pentaho.di.core.osgi.api.NamedClusterServiceOsgi;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.trans.steps.named.cluster.NamedClusterEmbedManager;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.persist.MetaStoreFactory;

public class NamedClusterEmbedManagerTest {
    private final String CLUSTER1_NAME = "cluster1_name";
    private final String CLUSTER2_NAME = "cluster2_name";
    private final String KEY = "KEY";
    private AbstractMeta mockMeta;
    private NamedClusterEmbedManager namedClusterEmbedManager;
    private LogChannelInterface mockLog;
    private NamedClusterOsgi mockNamedCluster1;
    private NamedClusterOsgi mockNamedCluster2;
    private MetaStoreFactory mockMetaStoreFactory;
    NamedClusterServiceOsgi mockNamedClusterService;

    @Before
    public void setUp() {
        this.mockLog = (LogChannelInterface)Mockito.mock(LogChannelInterface.class);
        this.mockMeta = (AbstractMeta)Mockito.mock(AbstractMeta.class);
        NamedClusterEmbedManager.testMetaStoreFactory = this.mockMetaStoreFactory = (MetaStoreFactory)Mockito.mock(MetaStoreFactory.class);
        IMetaStore mockMetaStore = (IMetaStore)Mockito.mock(IMetaStore.class);
        this.mockNamedCluster1 = (NamedClusterOsgi)Mockito.mock(NamedClusterOsgi.class);
        this.mockNamedCluster2 = (NamedClusterOsgi)Mockito.mock(NamedClusterOsgi.class);
        Mockito.when((Object)this.mockNamedCluster1.getName()).thenReturn((Object)"cluster1_name");
        Mockito.when((Object)this.mockNamedCluster2.getName()).thenReturn((Object)"cluster2_name");
        this.mockNamedClusterService = (NamedClusterServiceOsgi)Mockito.mock(NamedClusterServiceOsgi.class);
        Mockito.when((Object)this.mockMeta.getNamedClusterServiceOsgi()).thenReturn((Object)this.mockNamedClusterService);
        Mockito.when((Object)this.mockMeta.getMetaStore()).thenReturn((Object)mockMetaStore);
        Mockito.when((Object)this.mockNamedClusterService.getClusterTemplate()).thenReturn(Mockito.mock(NamedClusterOsgi.class));
        Mockito.when((Object)this.mockNamedClusterService.getNamedClusterByName((String)Matchers.eq((Object)"cluster1_name"), (IMetaStore)Matchers.any())).thenReturn((Object)this.mockNamedCluster1);
        Mockito.when((Object)this.mockNamedClusterService.getNamedClusterByName((String)Matchers.eq((Object)"cluster2_name"), (IMetaStore)Matchers.any())).thenReturn((Object)this.mockNamedCluster2);
        this.namedClusterEmbedManager = new NamedClusterEmbedManager(this.mockMeta, this.mockLog);
    }

    @Test
    public void testRegisterUrlNc() throws Exception {
        this.namedClusterEmbedManager.registerUrl("hc://cluster1_name/dir1/dir2");
        ((MetaStoreFactory)Mockito.verify((Object)this.mockMetaStoreFactory)).saveElement((Object)this.mockNamedCluster1);
    }

    @Test
    public void testRegisterUrlNotNc() throws Exception {
        this.namedClusterEmbedManager.registerUrl("hdfs://cluster1_name/dir1/dir2");
        ((MetaStoreFactory)Mockito.verify((Object)this.mockMetaStoreFactory, (VerificationMode)Mockito.never())).saveElement(Matchers.any());
    }

    @Test
    public void testRegisterUrlRegularFile() throws Exception {
        this.namedClusterEmbedManager.registerUrl("/cluster1_name/dir1/dir2");
        ((MetaStoreFactory)Mockito.verify((Object)this.mockMetaStoreFactory, (VerificationMode)Mockito.never())).saveElement(Matchers.any());
    }

    @Test
    public void testRegisterUrlFullVariable() throws Exception {
        Mockito.when((Object)this.mockNamedClusterService.listNames(this.mockMeta.getMetaStore())).thenReturn(Arrays.asList("cluster1_name", "cluster2_name"));
        this.namedClusterEmbedManager.registerUrl("${variable)");
        ((MetaStoreFactory)Mockito.verify((Object)this.mockMetaStoreFactory)).saveElement((Object)this.mockNamedCluster1);
        ((MetaStoreFactory)Mockito.verify((Object)this.mockMetaStoreFactory)).saveElement((Object)this.mockNamedCluster2);
    }

    @Test
    public void testRegisterUrlClusterVariable() throws Exception {
        Mockito.when((Object)this.mockNamedClusterService.listNames(this.mockMeta.getMetaStore())).thenReturn(Arrays.asList("cluster1_name", "cluster2_name"));
        this.namedClusterEmbedManager.registerUrl("hc://${variable)/dir1/file");
        ((MetaStoreFactory)Mockito.verify((Object)this.mockMetaStoreFactory)).saveElement((Object)this.mockNamedCluster1);
        ((MetaStoreFactory)Mockito.verify((Object)this.mockMetaStoreFactory)).saveElement((Object)this.mockNamedCluster2);
    }

    @Test
    public void testRegisterUrlAlreadyRegistered() throws Exception {
        Mockito.when((Object)this.mockMetaStoreFactory.loadElement("cluster1_name")).thenReturn((Object)this.mockNamedCluster1);
        this.namedClusterEmbedManager.registerUrl("hc://cluster1_name/dir1/dir2");
        ((MetaStoreFactory)Mockito.verify((Object)this.mockMetaStoreFactory, (VerificationMode)Mockito.times((int)0))).saveElement((Object)this.mockNamedCluster1);
    }

    @Test
    public void testClear() throws Exception {
        Mockito.when((Object)this.mockMetaStoreFactory.getElements()).thenReturn(Arrays.asList(this.mockNamedCluster1, this.mockNamedCluster2));
        this.namedClusterEmbedManager.clear();
        ((MetaStoreFactory)Mockito.verify((Object)this.mockMetaStoreFactory)).deleteElement("cluster1_name");
        ((MetaStoreFactory)Mockito.verify((Object)this.mockMetaStoreFactory)).deleteElement("cluster2_name");
    }

    @Test
    public void testPassEmbeddedMetastoreKey() {
        Variables mockVariables = (Variables)Mockito.mock(Variables.class);
        this.namedClusterEmbedManager.passEmbeddedMetastoreKey((VariableSpace)mockVariables, "key");
        ((Variables)Mockito.verify((Object)mockVariables)).setVariable(Matchers.anyString(), Matchers.anyString());
    }

    @Test
    public void testAddingClusterToMetaData() throws MetaStoreException {
        this.namedClusterEmbedManager.addClusterToMeta("cluster1_name");
        ((MetaStoreFactory)Mockito.verify((Object)this.mockMetaStoreFactory)).saveElement((Object)this.mockNamedCluster1);
    }
}

