/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mysqlbulkloader;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.MySQLDatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaNumber;
import org.pentaho.di.core.row.value.ValueMetaPluginType;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mysqlbulkloader.MySQLBulkLoader;
import org.pentaho.di.trans.steps.mysqlbulkloader.MySQLBulkLoaderData;
import org.pentaho.di.trans.steps.mysqlbulkloader.MySQLBulkLoaderMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MySQLBulkLoaderTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    MySQLBulkLoaderMeta lmeta;
    MySQLBulkLoaderData ldata;
    MySQLBulkLoader lder;
    StepMeta smeta;

    @BeforeClass
    public static void initEnvironment() throws Exception {
        KettleEnvironment.init();
    }

    @Before
    public void setUp() {
        TransMeta transMeta = new TransMeta();
        transMeta.setName("MysqlBulkLoader");
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("delim", ",");
        vars.put("enclos", "'");
        vars.put("charset", "UTF8");
        vars.put("tbl", "sometable");
        vars.put("schema", "someschema");
        transMeta.injectVariables(vars);
        MySQLDatabaseMeta mysql = new MySQLDatabaseMeta();
        mysql.setName("MySQL");
        DatabaseMeta dbMeta = new DatabaseMeta();
        dbMeta.setDatabaseInterface((DatabaseInterface)mysql);
        dbMeta.setQuoteAllFields(true);
        this.lmeta = new MySQLBulkLoaderMeta();
        this.lmeta.setDelimiter("${delim}");
        this.lmeta.setEnclosure("${enclos}");
        this.lmeta.setEncoding("${charset}");
        this.lmeta.setTableName("${tbl}");
        this.lmeta.setSchemaName("${schema}");
        this.lmeta.setDatabaseMeta(dbMeta);
        this.ldata = new MySQLBulkLoaderData();
        PluginRegistry plugReg = PluginRegistry.getInstance();
        String mblPid = plugReg.getPluginId(StepPluginType.class, (Object)this.lmeta);
        this.smeta = new StepMeta(mblPid, "MySqlBulkLoader", (StepMetaInterface)this.lmeta);
        Trans trans = new Trans(transMeta);
        transMeta.addStep(this.smeta);
        this.lder = new MySQLBulkLoader(this.smeta, (StepDataInterface)this.ldata, 1, transMeta, trans);
        this.lder.copyVariablesFrom((VariableSpace)transMeta);
    }

    @Test
    public void testFieldFormatType() throws KettleXMLException {
        MySQLBulkLoaderMeta lm = new MySQLBulkLoaderMeta();
        Document document = XMLHandler.loadXMLFile((InputStream)this.getClass().getResourceAsStream("step.xml"));
        IMetaStore metastore = null;
        Element stepNode = document.getDocumentElement();
        lm.loadXML((Node)stepNode, Collections.EMPTY_LIST, metastore);
        int[] codes = lm.getFieldFormatType();
        Assert.assertEquals((long)3L, (long)codes[0]);
        Assert.assertEquals((long)4L, (long)codes[1]);
    }

    @Test
    public void testVariableSubstitution() throws KettleException {
        this.lder.init((StepMetaInterface)this.lmeta, (StepDataInterface)this.ldata);
        String is = null;
        is = new String(this.ldata.quote);
        Assert.assertEquals((Object)"'", (Object)is);
        is = new String(this.ldata.separator);
        Assert.assertEquals((Object)",", (Object)is);
        Assert.assertEquals((Object)"UTF8", (Object)this.ldata.bulkTimestampMeta.getStringEncoding());
        Assert.assertEquals((Object)"UTF8", (Object)this.ldata.bulkDateMeta.getStringEncoding());
        Assert.assertEquals((Object)"UTF8", (Object)this.ldata.bulkNumberMeta.getStringEncoding());
        Assert.assertEquals((Object)"`someschema`.`sometable`", (Object)this.ldata.schemaTable);
    }

    @Test
    public void testNoDatabaseConnection() {
        this.lmeta.setDatabaseMeta(null);
        Assert.assertFalse((boolean)this.lder.init((StepMetaInterface)this.lmeta, (StepDataInterface)this.ldata));
        try {
            this.lder.verifyDatabaseConnection();
            Assert.fail((String)"Database Connection is not null, this fails the test.");
        }
        catch (KettleException aKettleException) {
            Assert.assertThat((Object)aKettleException.getMessage(), (Matcher)CoreMatchers.containsString((String)"There is no connection defined in this step"));
        }
    }

    @Test
    public void testEscapeCharacters() throws KettleException, IOException {
        PluginRegistry.addPluginType((PluginTypeInterface)ValueMetaPluginType.getInstance());
        PluginRegistry.init((boolean)false);
        MySQLBulkLoaderData ld = new MySQLBulkLoaderData();
        MySQLBulkLoaderMeta lm = new MySQLBulkLoaderMeta();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("loader");
        PluginRegistry plugReg = PluginRegistry.getInstance();
        String loaderPid = plugReg.getPluginId(StepPluginType.class, (Object)lm);
        StepMeta stepMeta = new StepMeta(loaderPid, "loader", (StepMetaInterface)lm);
        Trans trans = new Trans(transMeta);
        transMeta.addStep(stepMeta);
        trans.setRunning(true);
        MySQLBulkLoader loader = (MySQLBulkLoader)Mockito.spy((Object)new MySQLBulkLoader(stepMeta, (StepDataInterface)ld, 1, transMeta, trans));
        RowMeta rm = new RowMeta();
        ValueMetaString vm = new ValueMetaString("I don't want NPE!");
        rm.addValueMeta((ValueMetaInterface)vm);
        RowMeta spyRowMeta = (RowMeta)Mockito.spy((Object)new RowMeta());
        Mockito.when((Object)spyRowMeta.getValueMeta(Matchers.anyInt())).thenReturn((Object)vm);
        loader.setInputRowMeta((RowMetaInterface)spyRowMeta);
        MySQLBulkLoaderMeta smi = new MySQLBulkLoaderMeta();
        smi.setFieldStream(new String[]{"Test"});
        smi.setFieldFormatType(new int[]{4});
        smi.setEscapeChar("\\");
        smi.setEnclosure("\"");
        smi.setDatabaseMeta((DatabaseMeta)Mockito.mock(DatabaseMeta.class));
        MySQLBulkLoaderData sdi = new MySQLBulkLoaderData();
        sdi.keynrs = new int[1];
        sdi.keynrs[0] = 0;
        sdi.fifoStream = (OutputStream)Mockito.mock(OutputStream.class);
        loader.init((StepMetaInterface)smi, (StepDataInterface)sdi);
        loader.first = false;
        Mockito.when((Object)loader.getRow()).thenReturn((Object)new String[]{"test\"Escape\\"});
        loader.processRow((StepMetaInterface)smi, (StepDataInterface)sdi);
        ((OutputStream)Mockito.verify((Object)sdi.fifoStream, (VerificationMode)Mockito.times((int)1))).write("test\\\"Escape\\\\".getBytes());
    }

    @Test
    public void testNumberFormatting() throws KettleException, IOException {
        PluginRegistry.addPluginType((PluginTypeInterface)ValueMetaPluginType.getInstance());
        PluginRegistry.init((boolean)false);
        MySQLBulkLoaderData ld = new MySQLBulkLoaderData();
        MySQLBulkLoaderMeta lm = new MySQLBulkLoaderMeta();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("loader");
        PluginRegistry plugReg = PluginRegistry.getInstance();
        String loaderPid = plugReg.getPluginId(StepPluginType.class, (Object)lm);
        StepMeta stepMeta = new StepMeta(loaderPid, "loader", (StepMetaInterface)lm);
        Trans trans = new Trans(transMeta);
        transMeta.addStep(stepMeta);
        trans.setRunning(true);
        MySQLBulkLoader loader = (MySQLBulkLoader)Mockito.spy((Object)new MySQLBulkLoader(stepMeta, (StepDataInterface)ld, 1, transMeta, trans));
        RowMeta rm = new RowMeta();
        ValueMetaNumber vm = new ValueMetaNumber("Test");
        rm.addValueMeta((ValueMetaInterface)vm);
        RowMeta spyRowMeta = (RowMeta)Mockito.spy((Object)new RowMeta());
        Mockito.when((Object)spyRowMeta.getValueMeta(Matchers.anyInt())).thenReturn((Object)vm);
        loader.setInputRowMeta((RowMetaInterface)spyRowMeta);
        MySQLBulkLoaderMeta smi = new MySQLBulkLoaderMeta();
        smi.setFieldStream(new String[]{"Test"});
        smi.setFieldFormatType(new int[]{0});
        smi.setDatabaseMeta((DatabaseMeta)Mockito.mock(DatabaseMeta.class));
        ValueMetaNumber vmn = new ValueMetaNumber("Test");
        vmn.setLength(6, 3);
        MySQLBulkLoaderData sdi = new MySQLBulkLoaderData();
        sdi.keynrs = new int[1];
        sdi.keynrs[0] = 0;
        sdi.fifoStream = (OutputStream)Mockito.mock(OutputStream.class);
        sdi.bulkFormatMeta = new ValueMetaInterface[]{vmn};
        loader.init((StepMetaInterface)smi, (StepDataInterface)sdi);
        loader.first = false;
        Mockito.when((Object)loader.getRow()).thenReturn((Object)new Double[]{1.023});
        loader.processRow((StepMetaInterface)smi, (StepDataInterface)sdi);
        ((OutputStream)Mockito.verify((Object)sdi.fifoStream, (VerificationMode)Mockito.times((int)1))).write(" 001.023".getBytes());
        Assert.assertEquals((Object)" #000.000;-#000.000", (Object)vmn.getDecimalFormat().toPattern());
    }
}

