/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mysqlbulkloader;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.IntLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.PrimitiveIntArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.di.trans.steps.mysqlbulkloader.MySQLBulkLoaderMeta;

public class MySQLBulkLoaderMetaTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Test
    public void testRoundTrip() throws KettleException {
        List<String> attributes = Arrays.asList("schema", "table", "encoding", "delimiter", "enclosure", "escape_char", "replace", "ignore", "local", "fifo_file_name", "bulk_size", "stream_name", "field_name", "field_format_ok");
        HashMap<String, String> getterMap = new HashMap<String, String>();
        getterMap.put("schema", "getSchemaName");
        getterMap.put("table", "getTableName");
        getterMap.put("encoding", "getEncoding");
        getterMap.put("delimiter", "getDelimiter");
        getterMap.put("enclosure", "getEnclosure");
        getterMap.put("escape_char", "getEscapeChar");
        getterMap.put("replace", "isReplacingData");
        getterMap.put("ignore", "isIgnoringErrors");
        getterMap.put("local", "isLocalFile");
        getterMap.put("fifo_file_name", "getFifoFileName");
        getterMap.put("bulk_size", "getBulkSize");
        getterMap.put("stream_name", "getFieldTable");
        getterMap.put("field_name", "getFieldStream");
        getterMap.put("field_format_ok", "getFieldFormatType");
        HashMap<String, String> setterMap = new HashMap<String, String>();
        setterMap.put("schema", "setSchemaName");
        setterMap.put("table", "setTableName");
        setterMap.put("encoding", "setEncoding");
        setterMap.put("delimiter", "setDelimiter");
        setterMap.put("enclosure", "setEnclosure");
        setterMap.put("escape_char", "setEscapeChar");
        setterMap.put("replace", "setReplacingData");
        setterMap.put("ignore", "setIgnoringErrors");
        setterMap.put("local", "setLocalFile");
        setterMap.put("fifo_file_name", "setFifoFileName");
        setterMap.put("bulk_size", "setBulkSize");
        setterMap.put("stream_name", "setFieldTable");
        setterMap.put("field_name", "setFieldStream");
        setterMap.put("field_format_ok", "setFieldFormatType");
        HashMap fieldLoadSaveValidatorAttributeMap = new HashMap();
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 25);
        PrimitiveIntArrayLoadSaveValidator fieldFormatTypeArrayLoadSaveValidator = new PrimitiveIntArrayLoadSaveValidator(new IntLoadSaveValidator(MySQLBulkLoaderMeta.getFieldFormatTypeCodes().length), 25);
        fieldLoadSaveValidatorAttributeMap.put("stream_name", stringArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("field_name", stringArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("field_format_ok", fieldFormatTypeArrayLoadSaveValidator);
        LoadSaveTester<MySQLBulkLoaderMeta> loadSaveTester = new LoadSaveTester<MySQLBulkLoaderMeta>(MySQLBulkLoaderMeta.class, attributes, getterMap, setterMap, fieldLoadSaveValidatorAttributeMap, new HashMap());
        loadSaveTester.testSerialization();
    }

    @Test
    public void testPDI16559() throws Exception {
        MySQLBulkLoaderMeta mySQLBulkLoader = new MySQLBulkLoaderMeta();
        mySQLBulkLoader.setFieldTable(new String[]{"table1", "table2", "table3"});
        mySQLBulkLoader.setFieldStream(new String[]{"stream1"});
        mySQLBulkLoader.setFieldFormatType(new int[]{0, 1});
        mySQLBulkLoader.setSchemaName("test_schema");
        try {
            String badXml = mySQLBulkLoader.getXML();
            Assert.fail((String)"Before calling afterInjectionSynchronization, should have thrown an ArrayIndexOOB");
        }
        catch (Exception badXml) {
            // empty catch block
        }
        mySQLBulkLoader.afterInjectionSynchronization();
        String ktrXml = mySQLBulkLoader.getXML();
        int targetSz = mySQLBulkLoader.getFieldTable().length;
        Assert.assertEquals((long)targetSz, (long)mySQLBulkLoader.getFieldStream().length);
        Assert.assertEquals((long)targetSz, (long)mySQLBulkLoader.getFieldFormatType().length);
    }
}

