/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.multimerge;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.initializer.InitializerInterface;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.di.trans.steps.multimerge.MultiMergeJoinMeta;

public class MultiMergeJoinMetaTest
implements InitializerInterface<StepMetaInterface> {
    LoadSaveTester loadSaveTester;
    Class<MultiMergeJoinMeta> testMetaClass = MultiMergeJoinMeta.class;
    private MultiMergeJoinMeta multiMergeMeta;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Before
    public void setUpLoadSave() throws Exception {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
        this.multiMergeMeta = new MultiMergeJoinMeta();
        List<String> attributes = Arrays.asList("joinType", "keyFields", "inputSteps");
        HashMap<String, String> getterMap = new HashMap<String, String>();
        HashMap<String, String> setterMap = new HashMap<String, String>();
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5);
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("keyFields", stringArrayLoadSaveValidator);
        attrValidatorMap.put("inputSteps", stringArrayLoadSaveValidator);
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<StepMetaInterface>(this.testMetaClass, attributes, new ArrayList<String>(), new ArrayList<String>(), getterMap, setterMap, attrValidatorMap, typeValidatorMap, this);
    }

    @Override
    public void modify(StepMetaInterface someMeta) {
        if (someMeta instanceof MultiMergeJoinMeta) {
            ((MultiMergeJoinMeta)someMeta).allocateKeys(5);
            ((MultiMergeJoinMeta)someMeta).allocateInputSteps(5);
        }
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    @Test
    public void testSetGetInputSteps() {
        Assert.assertNull((Object)this.multiMergeMeta.getInputSteps());
        Object[] inputSteps = new String[]{"Step1", "Step2"};
        this.multiMergeMeta.setInputSteps((String[])inputSteps);
        Assert.assertArrayEquals((Object[])inputSteps, (Object[])this.multiMergeMeta.getInputSteps());
    }

    @Test
    public void testGetXml() {
        String[] inputSteps = new String[]{"Step1", "Step2"};
        this.multiMergeMeta.setInputSteps(inputSteps);
        this.multiMergeMeta.setKeyFields(new String[]{"Key1", "Key2"});
        String xml = this.multiMergeMeta.getXML();
        Assert.assertTrue((boolean)xml.contains("step0"));
        Assert.assertTrue((boolean)xml.contains("step1"));
    }

    @Test
    public void cloneTest() throws Exception {
        MultiMergeJoinMeta meta = new MultiMergeJoinMeta();
        meta.allocateKeys(2);
        meta.allocateInputSteps(3);
        meta.setKeyFields(new String[]{"key1", "key2"});
        meta.setInputSteps(new String[]{"step1", "step2", "step3"});
        meta.setJoinType("INNER");
        MultiMergeJoinMeta aClone = (MultiMergeJoinMeta)meta.clone();
        Assert.assertFalse((aClone == meta ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals(meta.getKeyFields(), aClone.getKeyFields()));
        Assert.assertTrue((boolean)Arrays.equals(meta.getInputSteps(), aClone.getInputSteps()));
        Assert.assertEquals((Object)meta.getJoinType(), (Object)aClone.getJoinType());
    }
}

