/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.monetdbbulkloader;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.pentaho.di.trans.steps.monetdbbulkloader.MonetDbVersion;
import org.pentaho.di.trans.steps.monetdbbulkloader.MonetDbVersionException;

public class MonetDbVersionTest {
    private MonetDbVersion monetDbVersion;

    @Before
    public void setup() throws Exception {
        this.monetDbVersion = null;
    }

    @Test
    public void testDbversionCreatedFromString() throws Exception {
        String dbVersion = "1.2.3";
        this.monetDbVersion = new MonetDbVersion(dbVersion);
        Assert.assertNotNull((Object)this.monetDbVersion.getMajorVersion());
        Assert.assertEquals((Object)1, (Object)this.monetDbVersion.getMajorVersion());
        Assert.assertNotNull((Object)this.monetDbVersion.getMinorVersion());
        Assert.assertEquals((Object)2, (Object)this.monetDbVersion.getMinorVersion());
        Assert.assertNotNull((Object)this.monetDbVersion.getPatchVersion());
        Assert.assertEquals((Object)3, (Object)this.monetDbVersion.getPatchVersion());
    }

    @Test
    public void testDbversionCreated() throws Exception {
        this.monetDbVersion = new MonetDbVersion(1, 2, 3);
        Assert.assertNotNull((Object)this.monetDbVersion.getMajorVersion());
        Assert.assertEquals((Object)1, (Object)this.monetDbVersion.getMajorVersion());
        Assert.assertNotNull((Object)this.monetDbVersion.getMinorVersion());
        Assert.assertEquals((Object)2, (Object)this.monetDbVersion.getMinorVersion());
        Assert.assertNotNull((Object)this.monetDbVersion.getPatchVersion());
        Assert.assertEquals((Object)3, (Object)this.monetDbVersion.getPatchVersion());
    }

    @Test
    public void testIllegalArgumentExceptionThrows_IfDbVersionNull() {
        try {
            this.monetDbVersion = new MonetDbVersion(null);
            Assert.fail((String)"Should throw MonetDbVersionException but it does not. ");
        }
        catch (MonetDbVersionException ex) {
            Assert.assertTrue((boolean)ex.getLocalizedMessage().contains("DB Version can not be null."));
        }
    }

    @Test
    public void testIllegalArgumentExceptionThrows_IfDbVersionNotMatchesVersionPattern() {
        String dbVersion = "1.8.d";
        try {
            this.monetDbVersion = new MonetDbVersion(dbVersion);
            Assert.fail((String)"Should throw MonetDbVersionException but it does not. ");
        }
        catch (MonetDbVersionException ex) {
            Assert.assertTrue((boolean)ex.getLocalizedMessage().contains("DB Version format is invalid: " + dbVersion));
        }
    }

    @Test
    public void testDbVersionWithouPatchVersion() throws Exception {
        String dbVersion = "785.2";
        this.monetDbVersion = new MonetDbVersion(dbVersion);
        Assert.assertNotNull((Object)this.monetDbVersion.getMajorVersion());
        Assert.assertEquals((Object)785, (Object)this.monetDbVersion.getMajorVersion());
        Assert.assertNotNull((Object)this.monetDbVersion.getMinorVersion());
        Assert.assertEquals((Object)2, (Object)this.monetDbVersion.getMinorVersion());
        Assert.assertNull((Object)this.monetDbVersion.getPatchVersion());
    }

    @Test
    public void testCompareVersions_DiffInPatch() throws Exception {
        String dbVersionBigger = "785.2.3";
        String dbVersion = "785.2.2";
        Assert.assertEquals((long)1L, (long)new MonetDbVersion(dbVersionBigger).compareTo(new MonetDbVersion(dbVersion)));
    }

    @Test
    public void testCompareVersions_DiffInMinor() throws Exception {
        String dbVersionBigger = "785.5.3";
        String dbVersion = "785.2.2";
        Assert.assertEquals((long)1L, (long)new MonetDbVersion(dbVersionBigger).compareTo(new MonetDbVersion(dbVersion)));
    }

    @Test
    public void testCompareVersions_DiffInMajor() throws Exception {
        String dbVersionBigger = "786.5.3";
        String dbVersion = "785.2.2";
        Assert.assertEquals((long)1L, (long)new MonetDbVersion(dbVersionBigger).compareTo(new MonetDbVersion(dbVersion)));
    }

    @Test
    public void testCompareVersions_DiffInMajor_LongVersion() throws Exception {
        String dbVersionBigger = "788.5.3.8.9.7.5";
        String dbVersion = "785.2.2";
        Assert.assertEquals((long)1L, (long)new MonetDbVersion(dbVersionBigger).compareTo(new MonetDbVersion(dbVersion)));
    }

    @Test
    public void testCompareVersions_TheSame() throws Exception {
        String dbVersionBigger = "11.11.7";
        String dbVersion = "11.11.7";
        Assert.assertEquals((long)0L, (long)new MonetDbVersion(dbVersionBigger).compareTo(new MonetDbVersion(dbVersion)));
    }

    @Test
    public void testCompareVersions_NoPatch() throws Exception {
        String dbVersionBigger = "11.18";
        String dbVersion = "11.17.17";
        Assert.assertEquals((long)1L, (long)new MonetDbVersion(dbVersionBigger).compareTo(new MonetDbVersion(dbVersion)));
    }
}

