/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.monetdbbulkloader;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.monetdbbulkloader.MonetDBBulkLoader;
import org.pentaho.di.trans.steps.monetdbbulkloader.MonetDBBulkLoaderData;
import org.pentaho.di.trans.steps.monetdbbulkloader.MonetDBBulkLoaderMeta;

public class MonetDBBulkLoaderTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private StepMockHelper<MonetDBBulkLoaderMeta, MonetDBBulkLoaderData> stepMockHelper;
    private MonetDBBulkLoader monetDbBulkLoader;

    @BeforeClass
    public static void initEnvironment() throws KettleException {
        KettleEnvironment.init();
    }

    @Before
    public void setUp() throws Exception {
        this.stepMockHelper = new StepMockHelper<MonetDBBulkLoaderMeta, MonetDBBulkLoaderData>("MonetDB Bulk Loader", MonetDBBulkLoaderMeta.class, MonetDBBulkLoaderData.class);
        Mockito.when((Object)this.stepMockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.stepMockHelper.logChannelInterface);
        Mockito.when((Object)this.stepMockHelper.trans.isRunning()).thenReturn((Object)true);
        this.monetDbBulkLoader = new MonetDBBulkLoader(this.stepMockHelper.stepMeta, this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
    }

    @After
    public void tearDown() throws Exception {
        this.stepMockHelper.cleanUp();
    }

    @Test
    public void testNoDatabaseConnection() {
        try {
            ((MonetDBBulkLoaderMeta)Mockito.doReturn(null).when(this.stepMockHelper.initStepMetaInterface)).getDatabaseMeta();
            Assert.assertFalse((boolean)this.monetDbBulkLoader.init(this.stepMockHelper.initStepMetaInterface, this.stepMockHelper.initStepDataInterface));
            this.monetDbBulkLoader.verifyDatabaseConnection();
            Assert.fail((String)"Database Connection is not null, this fails the test.");
        }
        catch (KettleException aKettleException) {
            Assert.assertThat((Object)aKettleException.getMessage(), (Matcher)CoreMatchers.containsString((String)"There is no connection defined in this step."));
        }
    }
}

