/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.monetdbbulkloader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.value.ValueMetaPluginType;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.initializer.InitializerInterface;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.BooleanLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.PrimitiveBooleanArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.di.trans.steps.monetdbbulkloader.MonetDBBulkLoader;
import org.pentaho.di.trans.steps.monetdbbulkloader.MonetDBBulkLoaderData;
import org.pentaho.di.trans.steps.monetdbbulkloader.MonetDBBulkLoaderMeta;

public class MonetDBBulkLoaderMetaTest
implements InitializerInterface<StepMetaInterface> {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private StepMeta stepMeta;
    private MonetDBBulkLoader loader;
    private MonetDBBulkLoaderData ld;
    private MonetDBBulkLoaderMeta lm;
    LoadSaveTester loadSaveTester;
    Class<MonetDBBulkLoaderMeta> testMetaClass = MonetDBBulkLoaderMeta.class;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        PluginRegistry.addPluginType((PluginTypeInterface)ValueMetaPluginType.getInstance());
        PluginRegistry.init((boolean)false);
    }

    @Before
    public void setUp() throws Exception {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
        TransMeta transMeta = new TransMeta();
        transMeta.setName("loader");
        this.lm = new MonetDBBulkLoaderMeta();
        this.ld = new MonetDBBulkLoaderData();
        PluginRegistry plugReg = PluginRegistry.getInstance();
        String loaderPid = plugReg.getPluginId(StepPluginType.class, (Object)this.lm);
        this.stepMeta = new StepMeta(loaderPid, "loader", (StepMetaInterface)this.lm);
        Trans trans = new Trans(transMeta);
        transMeta.addStep(this.stepMeta);
        this.loader = new MonetDBBulkLoader(this.stepMeta, (StepDataInterface)this.ld, 1, transMeta, trans);
        List<String> attributes = Arrays.asList("dbConnectionName", "schemaName", "tableName", "logFile", "fieldSeparator", "fieldEnclosure", "NULLrepresentation", "encoding", "truncate", "fullyQuoteSQL", "fieldTable", "fieldStream", "fieldFormatOk");
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5);
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("fieldTable", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fieldStream", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fieldFormatOk", new PrimitiveBooleanArrayLoadSaveValidator(new BooleanLoadSaveValidator(), 5));
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<StepMetaInterface>(this.testMetaClass, attributes, new ArrayList<String>(), new ArrayList<String>(), new HashMap<String, String>(), new HashMap<String, String>(), attrValidatorMap, typeValidatorMap, this);
    }

    @Override
    public void modify(StepMetaInterface someMeta) {
        if (someMeta instanceof MonetDBBulkLoaderMeta) {
            ((MonetDBBulkLoaderMeta)someMeta).allocate(5);
        }
    }

    @Test
    @Ignore(value="Fails intermittently.  Test introduced without new code so unclear what this is testing.")
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    @Test
    public void testTopLevelMetadataEntries() {
        try {
            List entries = this.loader.getStepMeta().getStepMetaInterface().getStepMetaInjectionInterface().getStepInjectionMetadataEntries();
            String masterKeys = "SCHEMA TABLE LOGFILE FIELD_SEPARATOR FIELD_ENCLOSURE NULL_REPRESENTATION ENCODING TRUNCATE FULLY_QUOTE_SQL BUFFER_SIZE MAPPINGS ";
            for (StepInjectionMetaEntry entry : entries) {
                String key = entry.getKey();
                Assert.assertTrue((boolean)masterKeys.contains(key));
                masterKeys = masterKeys.replace(key, "");
            }
            Assert.assertTrue((masterKeys.trim().length() == 0 ? 1 : 0) != 0);
        }
        catch (KettleException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testChildLevelMetadataEntries() {
        try {
            List entries = this.loader.getStepMeta().getStepMetaInterface().getStepMetaInjectionInterface().getStepInjectionMetadataEntries();
            String childKeys = "STREAMNAME FIELDNAME FIELD_FORMAT_OK ";
            StepInjectionMetaEntry mappingEntry = null;
            for (StepInjectionMetaEntry entry : entries) {
                String key = entry.getKey();
                if (!key.equals("MAPPINGS")) continue;
                mappingEntry = entry;
                break;
            }
            Assert.assertNotNull(mappingEntry);
            List fieldAttributes = ((StepInjectionMetaEntry)mappingEntry.getDetails().get(0)).getDetails();
            for (StepInjectionMetaEntry attribute : fieldAttributes) {
                String key = attribute.getKey();
                Assert.assertTrue((boolean)childKeys.contains(key));
                childKeys = childKeys.replace(key, "");
            }
            Assert.assertTrue((childKeys.trim().length() == 0 ? 1 : 0) != 0);
        }
        catch (KettleException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testInjection() {
        try {
            List entries = this.loader.getStepMeta().getStepMetaInterface().getStepMetaInjectionInterface().getStepInjectionMetadataEntries();
            for (StepInjectionMetaEntry entry : entries) {
                entry.setValueType(this.lm.findAttribute(entry.getKey()).getType());
                switch (entry.getValueType()) {
                    case 2: {
                        entry.setValue((Object)"new_".concat(entry.getKey()));
                        break;
                    }
                    case 4: {
                        entry.setValue((Object)Boolean.TRUE);
                        break;
                    }
                }
                if (entry.getDetails().isEmpty()) continue;
                List childEntries = ((StepInjectionMetaEntry)entry.getDetails().get(0)).getDetails();
                for (StepInjectionMetaEntry childEntry : childEntries) {
                    switch (childEntry.getValueType()) {
                        case 2: {
                            childEntry.setValue((Object)"new_".concat(childEntry.getKey()));
                            break;
                        }
                        case 4: {
                            childEntry.setValue((Object)Boolean.TRUE);
                            break;
                        }
                    }
                }
            }
            this.loader.getStepMeta().getStepMetaInterface().getStepMetaInjectionInterface().injectStepMetadataEntries(entries);
            Assert.assertEquals((String)"Schema name not properly injected... ", (Object)"new_SCHEMA", (Object)this.lm.getSchemaName());
            Assert.assertEquals((String)"Table name not properly injected... ", (Object)"new_TABLE", (Object)this.lm.getTableName());
            Assert.assertEquals((String)"Logfile not properly injected... ", (Object)"new_LOGFILE", (Object)this.lm.getLogFile());
            Assert.assertEquals((String)"Field separator not properly injected... ", (Object)"new_FIELD_SEPARATOR", (Object)this.lm.getFieldSeparator());
            Assert.assertEquals((String)"Field enclosure not properly injected... ", (Object)"new_FIELD_ENCLOSURE", (Object)this.lm.getFieldEnclosure());
            Assert.assertEquals((String)"Null representation not properly injected... ", (Object)"new_NULL_REPRESENTATION", (Object)this.lm.getNULLrepresentation());
            Assert.assertEquals((String)"Encoding path not properly injected... ", (Object)"new_ENCODING", (Object)this.lm.getEncoding());
            Assert.assertEquals((String)"Buffer size not properly injected... ", (Object)"new_BUFFER_SIZE", (Object)this.lm.getBufferSize());
            Assert.assertEquals((String)"Truncate not properly injected... ", (Object)Boolean.TRUE, (Object)this.lm.isTruncate());
            Assert.assertEquals((String)"Fully Quote SQL not properly injected... ", (Object)Boolean.TRUE, (Object)this.lm.isFullyQuoteSQL());
            Assert.assertEquals((String)"Field name not properly injected... ", (Object)"new_FIELDNAME", (Object)this.lm.getFieldTable()[0]);
            Assert.assertEquals((String)"Stream name not properly injected... ", (Object)"new_STREAMNAME", (Object)this.lm.getFieldStream()[0]);
            Assert.assertEquals((String)"Field Format not properly injected... ", (Object)Boolean.TRUE, (Object)this.lm.getFieldFormatOk()[0]);
        }
        catch (KettleException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

