/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mondrianinput;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.mondrianinput.MondrianData;
import org.pentaho.di.trans.steps.mondrianinput.MondrianInputMeta;

public class MondrianInputMetaTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @BeforeClass
    public static void setUpBeforeClass() throws KettleException {
        KettleEnvironment.init((boolean)false);
    }

    @Test
    public void testLoadSave() throws KettleException {
        List<String> attributes = Arrays.asList("DatabaseMeta", "SQL", "Catalog", "Role", "VariableReplacementActive");
        LoadSaveTester<MondrianInputMeta> loadSaveTester = new LoadSaveTester<MondrianInputMeta>(MondrianInputMeta.class, attributes);
        loadSaveTester.testSerialization();
    }

    @Test
    public void testDefaults() {
        MondrianInputMeta meta = new MondrianInputMeta();
        meta.setDefault();
        Assert.assertNull((Object)meta.getDatabaseMeta());
        Assert.assertNotNull((Object)meta.getSQL());
        Assert.assertFalse((boolean)Utils.isEmpty((CharSequence)meta.getSQL()));
        Assert.assertFalse((boolean)meta.isVariableReplacementActive());
    }

    @Test
    public void testGetData() {
        MondrianInputMeta meta = new MondrianInputMeta();
        Assert.assertTrue((boolean)(meta.getStepData() instanceof MondrianData));
    }
}

