/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mergerows;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.mergerows.MergeRowsMeta;
import org.pentaho.metastore.api.IMetaStore;

public class MergeRowsMetaCheckTest {
    private TransMeta transMeta;
    private MergeRowsMeta meta;
    private StepMeta stepMeta;
    private static final String STEP_NAME = "MERGE_ROWS_META_CHECK_TEST_STEP_NAME";
    private static final String REFERENCE_STEP_NAME = "REFERENCE_STEP";
    private static final String COMPARISON_STEP_NAME = "COMPARISON_STEP";
    private StepMeta referenceStepMeta;
    private StepMeta comparisonStepMeta;
    private List<CheckResultInterface> remarks;

    protected RowMetaInterface generateRowMetaEmpty() {
        return new RowMeta();
    }

    protected RowMetaInterface generateRowMeta10Strings() {
        RowMeta output = new RowMeta();
        for (int i = 0; i < 10; ++i) {
            output.addValueMeta((ValueMetaInterface)new ValueMetaString("row_" + (i + 1)));
        }
        return output;
    }

    protected RowMetaInterface generateRowMeta10MixedTypes() {
        RowMeta output = new RowMeta();
        for (int i = 0; i < 10; ++i) {
            if (i < 5) {
                output.addValueMeta((ValueMetaInterface)new ValueMetaString("row_" + (i + 1)));
                continue;
            }
            output.addValueMeta((ValueMetaInterface)new ValueMetaInteger("row_" + (i + 1)));
        }
        return output;
    }

    @Before
    public void setup() {
        this.transMeta = (TransMeta)Mockito.mock(TransMeta.class);
        this.meta = new MergeRowsMeta();
        this.stepMeta = new StepMeta(STEP_NAME, (StepMetaInterface)this.meta);
        this.referenceStepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        this.comparisonStepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        Mockito.when((Object)this.referenceStepMeta.getName()).thenReturn((Object)REFERENCE_STEP_NAME);
        Mockito.when((Object)this.comparisonStepMeta.getName()).thenReturn((Object)COMPARISON_STEP_NAME);
        ((StreamInterface)this.meta.getStepIOMeta().getInfoStreams().get(0)).setStepMeta(this.referenceStepMeta);
        ((StreamInterface)this.meta.getStepIOMeta().getInfoStreams().get(1)).setStepMeta(this.comparisonStepMeta);
        this.remarks = new ArrayList<CheckResultInterface>();
    }

    @Test
    public void testCheckInputRowsBothEmpty() throws KettleStepException {
        Mockito.when((Object)this.transMeta.getPrevStepFields(REFERENCE_STEP_NAME)).thenReturn((Object)this.generateRowMetaEmpty());
        Mockito.when((Object)this.transMeta.getPrevStepFields(COMPARISON_STEP_NAME)).thenReturn((Object)this.generateRowMetaEmpty());
        this.meta.check(this.remarks, this.transMeta, this.stepMeta, (RowMetaInterface)((RowMeta)null), new String[0], new String[0], (RowMetaInterface)((RowMeta)null), (VariableSpace)new Variables(), (Repository)null, (IMetaStore)null);
        Assert.assertNotNull(this.remarks);
        Assert.assertTrue((this.remarks.size() >= 2 ? 1 : 0) != 0);
        Assert.assertEquals((long)this.remarks.get(1).getType(), (long)1L);
    }

    @Test
    public void testCheckInputRowsBothNonEmpty() throws KettleStepException {
        Mockito.when((Object)this.transMeta.getPrevStepFields(REFERENCE_STEP_NAME)).thenReturn((Object)this.generateRowMeta10Strings());
        Mockito.when((Object)this.transMeta.getPrevStepFields(COMPARISON_STEP_NAME)).thenReturn((Object)this.generateRowMeta10Strings());
        this.meta.check(this.remarks, this.transMeta, this.stepMeta, (RowMetaInterface)((RowMeta)null), new String[0], new String[0], (RowMetaInterface)((RowMeta)null), (VariableSpace)new Variables(), (Repository)null, (IMetaStore)null);
        Assert.assertNotNull(this.remarks);
        Assert.assertTrue((this.remarks.size() >= 2 ? 1 : 0) != 0);
        Assert.assertEquals((long)this.remarks.get(1).getType(), (long)1L);
    }

    @Test
    public void testCheckInputRowsEmptyAndNonEmpty() throws KettleStepException {
        Mockito.when((Object)this.transMeta.getPrevStepFields(REFERENCE_STEP_NAME)).thenReturn((Object)this.generateRowMetaEmpty());
        Mockito.when((Object)this.transMeta.getPrevStepFields(COMPARISON_STEP_NAME)).thenReturn((Object)this.generateRowMeta10Strings());
        this.meta.check(this.remarks, this.transMeta, this.stepMeta, (RowMetaInterface)((RowMeta)null), new String[0], new String[0], (RowMetaInterface)((RowMeta)null), (VariableSpace)new Variables(), (Repository)null, (IMetaStore)null);
        Assert.assertNotNull(this.remarks);
        Assert.assertTrue((this.remarks.size() >= 2 ? 1 : 0) != 0);
        Assert.assertEquals((long)this.remarks.get(1).getType(), (long)4L);
    }

    @Test
    public void testCheckInputRowsDifferentRowMetaTypes() throws KettleStepException {
        Mockito.when((Object)this.transMeta.getPrevStepFields(REFERENCE_STEP_NAME)).thenReturn((Object)this.generateRowMeta10MixedTypes());
        Mockito.when((Object)this.transMeta.getPrevStepFields(COMPARISON_STEP_NAME)).thenReturn((Object)this.generateRowMeta10Strings());
        this.meta.check(this.remarks, this.transMeta, this.stepMeta, (RowMetaInterface)((RowMeta)null), new String[0], new String[0], (RowMetaInterface)((RowMeta)null), (VariableSpace)new Variables(), (Repository)null, (IMetaStore)null);
        Assert.assertNotNull(this.remarks);
        Assert.assertTrue((this.remarks.size() >= 2 ? 1 : 0) != 0);
        Assert.assertEquals((long)this.remarks.get(1).getType(), (long)4L);
    }
}

