/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.memgroupby;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.steps.memgroupby.Aggregate;
import org.pentaho.di.trans.steps.memgroupby.MemoryGroupBy;
import org.pentaho.di.trans.steps.memgroupby.MemoryGroupByData;
import org.pentaho.di.trans.steps.memgroupby.MemoryGroupByMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;

public class MemoryGroupByNewAggregateTest {
    static StepMockHelper<MemoryGroupByMeta, MemoryGroupByData> mockHelper;
    static List<Integer> strings;
    static List<Integer> statistics;
    MemoryGroupBy step;
    MemoryGroupByData data;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        mockHelper = new StepMockHelper<MemoryGroupByMeta, MemoryGroupByData>("Memory Group By", MemoryGroupByMeta.class, MemoryGroupByData.class);
        Mockito.when((Object)MemoryGroupByNewAggregateTest.mockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)MemoryGroupByNewAggregateTest.mockHelper.logChannelInterface);
        Mockito.when((Object)MemoryGroupByNewAggregateTest.mockHelper.trans.isRunning()).thenReturn((Object)true);
        strings = new ArrayList<Integer>();
        strings.add(8);
        strings.add(14);
        statistics = new ArrayList<Integer>();
        statistics.add(3);
        statistics.add(4);
    }

    @AfterClass
    public static void cleanUp() {
        mockHelper.cleanUp();
    }

    @Before
    public void setUp() throws Exception {
        RowMetaInterface rmi;
        this.data = new MemoryGroupByData();
        this.data.subjectnrs = new int[16];
        int[] arr = new int[16];
        Object[] arrF = new String[16];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = i + 1;
            this.data.subjectnrs[i] = i;
        }
        Arrays.fill(arrF, "x");
        MemoryGroupByMeta meta = new MemoryGroupByMeta();
        meta.setAggregateType(arr);
        meta.setAggregateField((String[])arrF);
        ValueMetaInteger vmi = new ValueMetaInteger();
        Mockito.when((Object)MemoryGroupByNewAggregateTest.mockHelper.stepMeta.getStepMetaInterface()).thenReturn((Object)meta);
        this.data.inputRowMeta = rmi = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        Mockito.when((Object)rmi.getValueMeta(Mockito.anyInt())).thenReturn((Object)vmi);
        this.data.aggMeta = rmi;
        this.step = new MemoryGroupBy(MemoryGroupByNewAggregateTest.mockHelper.stepMeta, (StepDataInterface)this.data, 0, MemoryGroupByNewAggregateTest.mockHelper.transMeta, MemoryGroupByNewAggregateTest.mockHelper.trans);
    }

    @Test
    public void testNewAggregate() throws KettleException {
        Object[] r = new Object[16];
        Arrays.fill(r, null);
        Aggregate agg = new Aggregate();
        this.step.newAggregate(r, agg);
        Assert.assertEquals((String)"All possible aggregation cases considered", (int)16, (int)agg.agg.length);
        for (int i = 0; i < agg.agg.length; ++i) {
            int type = i + 1;
            if (strings.contains(type)) {
                Assert.assertTrue((String)("This is appendable type, type=" + type), (boolean)(agg.agg[i] instanceof Appendable));
                continue;
            }
            if (statistics.contains(type)) {
                Assert.assertTrue((String)("This is collection, type=" + type), (boolean)(agg.agg[i] instanceof Collection));
                continue;
            }
            Assert.assertNull((String)("Aggregation initialized with null, type=" + type), (Object)agg.agg[i]);
        }
    }
}

