/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.memgroupby;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBigNumber;
import org.pentaho.di.core.row.value.ValueMetaBinary;
import org.pentaho.di.core.row.value.ValueMetaBoolean;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaInternetAddress;
import org.pentaho.di.core.row.value.ValueMetaNumber;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.row.value.ValueMetaTimestamp;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.initializer.InitializerInterface;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.IntLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.PrimitiveIntArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.di.trans.steps.memgroupby.MemoryGroupByMeta;

public class MemoryGroupByMetaTest
implements InitializerInterface<MemoryGroupByMeta> {
    LoadSaveTester<MemoryGroupByMeta> loadSaveTester;
    Class<MemoryGroupByMeta> testMetaClass = MemoryGroupByMeta.class;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Before
    public void setUpLoadSave() throws Exception {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
        List<String> attributes = Arrays.asList("alwaysGivingBackOneRow", "groupField", "aggregateField", "subjectField", "aggregateType", "valueField");
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5);
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("groupField", stringArrayLoadSaveValidator);
        attrValidatorMap.put("aggregateField", stringArrayLoadSaveValidator);
        attrValidatorMap.put("subjectField", stringArrayLoadSaveValidator);
        attrValidatorMap.put("valueField", stringArrayLoadSaveValidator);
        attrValidatorMap.put("aggregateType", new PrimitiveIntArrayLoadSaveValidator(new IntLoadSaveValidator(MemoryGroupByMeta.typeGroupCode.length), 5));
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<MemoryGroupByMeta>(this.testMetaClass, attributes, new ArrayList<String>(), new ArrayList<String>(), new HashMap<String, String>(), new HashMap<String, String>(), attrValidatorMap, typeValidatorMap, this);
    }

    @Override
    public void modify(MemoryGroupByMeta someMeta) {
        someMeta.allocate(5, 5);
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    private RowMetaInterface getInputRowMeta() {
        RowMeta rm = new RowMeta();
        rm.addValueMeta((ValueMetaInterface)new ValueMetaString("myGroupField2"));
        rm.addValueMeta((ValueMetaInterface)new ValueMetaString("myGroupField1"));
        rm.addValueMeta((ValueMetaInterface)new ValueMetaString("myString"));
        rm.addValueMeta((ValueMetaInterface)new ValueMetaInteger("myInteger"));
        rm.addValueMeta((ValueMetaInterface)new ValueMetaNumber("myNumber"));
        rm.addValueMeta((ValueMetaInterface)new ValueMetaBigNumber("myBigNumber"));
        rm.addValueMeta((ValueMetaInterface)new ValueMetaBinary("myBinary"));
        rm.addValueMeta((ValueMetaInterface)new ValueMetaBoolean("myBoolean"));
        rm.addValueMeta((ValueMetaInterface)new ValueMetaDate("myDate"));
        rm.addValueMeta((ValueMetaInterface)new ValueMetaTimestamp("myTimestamp"));
        rm.addValueMeta((ValueMetaInterface)new ValueMetaInternetAddress("myInternetAddress"));
        return rm;
    }

    @Test
    public void testGetFields() {
        String stepName = "this step name";
        MemoryGroupByMeta meta = new MemoryGroupByMeta();
        meta.setDefault();
        meta.allocate(1, 17);
        RowMetaInterface rm = this.getInputRowMeta();
        String[] groupFields = new String[]{"myGroupField1", "myGroupField2"};
        String[] aggregateFields = new String[24];
        String[] subjectFields = new String[24];
        int[] aggregateTypes = new int[24];
        String[] valueFields = new String[24];
        subjectFields[0] = "myString";
        aggregateTypes[0] = 8;
        aggregateFields[0] = "ConcatComma";
        valueFields[0] = null;
        subjectFields[1] = "myString";
        aggregateTypes[1] = 14;
        aggregateFields[1] = "ConcatString";
        valueFields[1] = "|";
        subjectFields[2] = "myString";
        aggregateTypes[2] = 7;
        aggregateFields[2] = "CountAll";
        valueFields[2] = null;
        subjectFields[3] = "myString";
        aggregateTypes[3] = 16;
        aggregateFields[3] = "CountAny";
        valueFields[3] = null;
        subjectFields[4] = "myString";
        aggregateTypes[4] = 15;
        aggregateFields[4] = "CountDistinct";
        valueFields[4] = null;
        subjectFields[5] = "myString";
        aggregateTypes[5] = 9;
        aggregateFields[5] = "First(String)";
        valueFields[5] = null;
        subjectFields[6] = "myInteger";
        aggregateTypes[6] = 9;
        aggregateFields[6] = "First(Integer)";
        valueFields[6] = null;
        subjectFields[7] = "myNumber";
        aggregateTypes[7] = 11;
        aggregateFields[7] = "FirstInclNull(Number)";
        valueFields[7] = null;
        subjectFields[8] = "myBigNumber";
        aggregateTypes[8] = 11;
        aggregateFields[8] = "FirstInclNull(BigNumber)";
        valueFields[8] = null;
        subjectFields[9] = "myBinary";
        aggregateTypes[9] = 10;
        aggregateFields[9] = "Last(Binary)";
        valueFields[9] = null;
        subjectFields[10] = "myBoolean";
        aggregateTypes[10] = 10;
        aggregateFields[10] = "Last(Boolean)";
        valueFields[10] = null;
        subjectFields[11] = "myDate";
        aggregateTypes[11] = 12;
        aggregateFields[11] = "LastInclNull(Date)";
        valueFields[11] = null;
        subjectFields[12] = "myTimestamp";
        aggregateTypes[12] = 12;
        aggregateFields[12] = "LastInclNull(Timestamp)";
        valueFields[12] = null;
        subjectFields[13] = "myInternetAddress";
        aggregateTypes[13] = 6;
        aggregateFields[13] = "Max(InternetAddress)";
        valueFields[13] = null;
        subjectFields[14] = "myString";
        aggregateTypes[14] = 6;
        aggregateFields[14] = "Max(String)";
        valueFields[14] = null;
        subjectFields[15] = "myInteger";
        aggregateTypes[15] = 3;
        aggregateFields[15] = "Median(Integer)";
        valueFields[15] = null;
        subjectFields[16] = "myNumber";
        aggregateTypes[16] = 5;
        aggregateFields[16] = "Min(Number)";
        valueFields[16] = null;
        subjectFields[17] = "myBigNumber";
        aggregateTypes[17] = 5;
        aggregateFields[17] = "Min(BigNumber)";
        valueFields[17] = null;
        subjectFields[18] = "myBinary";
        aggregateTypes[18] = 4;
        aggregateFields[18] = "Percentile(Binary)";
        valueFields[18] = "0.5";
        subjectFields[19] = "myBoolean";
        aggregateTypes[19] = 13;
        aggregateFields[19] = "StandardDeviation(Boolean)";
        valueFields[19] = null;
        subjectFields[20] = "myDate";
        aggregateTypes[20] = 1;
        aggregateFields[20] = "Sum(Date)";
        valueFields[20] = null;
        subjectFields[21] = "myInteger";
        aggregateTypes[21] = 1;
        aggregateFields[21] = "Sum(Integer)";
        valueFields[21] = null;
        subjectFields[22] = "myInteger";
        aggregateTypes[22] = 2;
        aggregateFields[22] = "Average(Integer)";
        valueFields[22] = null;
        subjectFields[23] = "myDate";
        aggregateTypes[23] = 2;
        aggregateFields[23] = "Average(Date)";
        valueFields[23] = null;
        meta.setGroupField(groupFields);
        meta.setSubjectField(subjectFields);
        meta.setAggregateType(aggregateTypes);
        meta.setAggregateField(aggregateFields);
        meta.setValueField(valueFields);
        Variables vars = new Variables();
        meta.getFields(rm, "this step name", null, null, (VariableSpace)vars, null, null);
        Assert.assertNotNull((Object)rm);
        Assert.assertEquals((long)26L, (long)rm.size());
        Assert.assertTrue((rm.indexOfValue("myGroupField1") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)rm.getValueMeta(rm.indexOfValue("myGroupField1")).getType());
        Assert.assertTrue((rm.indexOfValue("myGroupField2") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)rm.getValueMeta(rm.indexOfValue("myGroupField2")).getType());
        Assert.assertTrue((rm.indexOfValue("myGroupField2") > rm.indexOfValue("myGroupField1") ? 1 : 0) != 0);
        Assert.assertTrue((rm.indexOfValue("ConcatComma") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)rm.getValueMeta(rm.indexOfValue("ConcatComma")).getType());
        Assert.assertTrue((rm.indexOfValue("ConcatString") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)rm.getValueMeta(rm.indexOfValue("ConcatString")).getType());
        Assert.assertTrue((rm.indexOfValue("CountAll") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)5L, (long)rm.getValueMeta(rm.indexOfValue("CountAll")).getType());
        Assert.assertTrue((rm.indexOfValue("CountAny") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)5L, (long)rm.getValueMeta(rm.indexOfValue("CountAny")).getType());
        Assert.assertTrue((rm.indexOfValue("CountDistinct") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)5L, (long)rm.getValueMeta(rm.indexOfValue("CountDistinct")).getType());
        Assert.assertTrue((rm.indexOfValue("First(String)") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)rm.getValueMeta(rm.indexOfValue("First(String)")).getType());
        Assert.assertTrue((rm.indexOfValue("First(Integer)") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)5L, (long)rm.getValueMeta(rm.indexOfValue("First(Integer)")).getType());
        Assert.assertTrue((rm.indexOfValue("FirstInclNull(Number)") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)rm.getValueMeta(rm.indexOfValue("FirstInclNull(Number)")).getType());
        Assert.assertTrue((rm.indexOfValue("FirstInclNull(BigNumber)") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)6L, (long)rm.getValueMeta(rm.indexOfValue("FirstInclNull(BigNumber)")).getType());
        Assert.assertTrue((rm.indexOfValue("Last(Binary)") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)8L, (long)rm.getValueMeta(rm.indexOfValue("Last(Binary)")).getType());
        Assert.assertTrue((rm.indexOfValue("Last(Boolean)") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)4L, (long)rm.getValueMeta(rm.indexOfValue("Last(Boolean)")).getType());
        Assert.assertTrue((rm.indexOfValue("LastInclNull(Date)") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)rm.getValueMeta(rm.indexOfValue("LastInclNull(Date)")).getType());
        Assert.assertTrue((rm.indexOfValue("LastInclNull(Timestamp)") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)9L, (long)rm.getValueMeta(rm.indexOfValue("LastInclNull(Timestamp)")).getType());
        Assert.assertTrue((rm.indexOfValue("Max(InternetAddress)") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)10L, (long)rm.getValueMeta(rm.indexOfValue("Max(InternetAddress)")).getType());
        Assert.assertTrue((rm.indexOfValue("Max(String)") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)rm.getValueMeta(rm.indexOfValue("Max(String)")).getType());
        Assert.assertTrue((rm.indexOfValue("Median(Integer)") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)rm.getValueMeta(rm.indexOfValue("Median(Integer)")).getType());
        Assert.assertTrue((rm.indexOfValue("Min(Number)") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)rm.getValueMeta(rm.indexOfValue("Min(Number)")).getType());
        Assert.assertTrue((rm.indexOfValue("Min(BigNumber)") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)6L, (long)rm.getValueMeta(rm.indexOfValue("Min(BigNumber)")).getType());
        Assert.assertTrue((rm.indexOfValue("Percentile(Binary)") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)rm.getValueMeta(rm.indexOfValue("Percentile(Binary)")).getType());
        Assert.assertTrue((rm.indexOfValue("StandardDeviation(Boolean)") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)rm.getValueMeta(rm.indexOfValue("StandardDeviation(Boolean)")).getType());
        Assert.assertTrue((rm.indexOfValue("Sum(Date)") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)rm.getValueMeta(rm.indexOfValue("Sum(Date)")).getType());
        Assert.assertTrue((rm.indexOfValue("Sum(Integer)") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)5L, (long)rm.getValueMeta(rm.indexOfValue("Sum(Integer)")).getType());
        Assert.assertTrue((rm.indexOfValue("Average(Integer)") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)5L, (long)rm.getValueMeta(rm.indexOfValue("Average(Integer)")).getType());
        Assert.assertTrue((rm.indexOfValue("Average(Date)") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)rm.getValueMeta(rm.indexOfValue("Average(Date)")).getType());
        rm = this.getInputRowMeta();
        vars.setVariable("KETTLE_COMPATIBILITY_MEMORY_GROUP_BY_SUM_AVERAGE_RETURN_NUMBER_TYPE", "Y");
        meta.getFields(rm, "this step name", null, null, (VariableSpace)vars, null, null);
        Assert.assertNotNull((Object)rm);
        Assert.assertEquals((long)26L, (long)rm.size());
        Assert.assertTrue((rm.indexOfValue("Average(Integer)") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)rm.getValueMeta(rm.indexOfValue("Average(Integer)")).getType());
    }

    @Test
    public void testPDI16559() throws Exception {
        MemoryGroupByMeta memoryGroupBy = new MemoryGroupByMeta();
        memoryGroupBy.setGroupField(new String[]{"group1", "group 2"});
        memoryGroupBy.setSubjectField(new String[]{"field1", "field2", "field3", "field4", "field5", "field6", "field7", "field8", "field9", "field10", "field11", "field12"});
        memoryGroupBy.setAggregateField(new String[]{"fieldID1", "fieldID2", "fieldID3", "fieldID4", "fieldID5", "fieldID6", "fieldID7", "fieldID8", "fieldID9", "fieldID10", "fieldID11"});
        memoryGroupBy.setValueField(new String[]{"asdf", "asdf", "qwer", "qwer", "QErasdf", "zxvv", "fasdf", "qwerqwr"});
        memoryGroupBy.setAggregateType(new int[]{12, 6, 15, 14, 23, 177, 13, 21});
        try {
            String badXml = memoryGroupBy.getXML();
            Assert.fail((String)"Before calling afterInjectionSynchronization, should have thrown an ArrayIndexOOB");
        }
        catch (Exception badXml) {
            // empty catch block
        }
        memoryGroupBy.afterInjectionSynchronization();
        String ktrXml = memoryGroupBy.getXML();
        int targetSz = memoryGroupBy.getSubjectField().length;
        Assert.assertEquals((long)targetSz, (long)memoryGroupBy.getAggregateField().length);
        Assert.assertEquals((long)targetSz, (long)memoryGroupBy.getAggregateType().length);
        Assert.assertEquals((long)targetSz, (long)memoryGroupBy.getValueField().length);
        memoryGroupBy.setValueField(null);
        memoryGroupBy.afterInjectionSynchronization();
        Assert.assertEquals((long)targetSz, (long)memoryGroupBy.getValueField().length);
    }
}

