/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.memgroupby;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.TreeBasedTable;
import java.util.Date;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaNumber;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.memgroupby.MemoryGroupBy;
import org.pentaho.di.trans.steps.memgroupby.MemoryGroupByData;
import org.pentaho.di.trans.steps.memgroupby.MemoryGroupByMeta;

public class MemoryGroupByAggregationTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private Variables variables;
    private Map<String, Integer> aggregates;
    public static final String STEP_NAME = "testStep";
    private static final ImmutableMap<String, Integer> default_aggregates = ImmutableMap.builder().put((Object)"min", (Object)5).put((Object)"max", (Object)6).put((Object)"sum", (Object)1).put((Object)"ave", (Object)2).put((Object)"count", (Object)7).put((Object)"count_any", (Object)16).put((Object)"count_distinct", (Object)15).build();
    private RowMeta rowMeta;
    private TreeBasedTable<Integer, Integer, Optional<Object>> data;

    @BeforeClass
    public static void setUpBeforeClass() throws KettleException {
        KettleClientEnvironment.init();
    }

    @Before
    public void setUp() throws Exception {
        this.rowMeta = new RowMeta();
        this.data = TreeBasedTable.create();
        this.variables = new Variables();
        this.aggregates = Maps.newHashMap(default_aggregates);
    }

    @Test
    public void testDefault() throws Exception {
        this.addColumn((ValueMetaInterface)new ValueMetaInteger("intg"), 0L, 1L, 1L, 10L);
        this.addColumn((ValueMetaInterface)new ValueMetaInteger("nul"), new Object[0]);
        this.addColumn((ValueMetaInterface)new ValueMetaInteger("mix1"), -1L, 2L);
        this.addColumn((ValueMetaInterface)new ValueMetaInteger("mix2"), null, 7L);
        this.addColumn((ValueMetaInterface)new ValueMetaNumber("mix3"), -1.0, 2.5);
        this.addColumn((ValueMetaInterface)new ValueMetaDate("date1"), new Date(1L), new Date(2L));
        RowMetaAndData output = this.runStep();
        Assert.assertThat((Object)output.getInteger("intg_min"), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)output.getInteger("intg_max"), (Matcher)CoreMatchers.is((Object)10L));
        Assert.assertThat((Object)output.getInteger("intg_sum"), (Matcher)CoreMatchers.is((Object)12L));
        Assert.assertThat((Object)output.getInteger("intg_ave"), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)output.getInteger("intg_count"), (Matcher)CoreMatchers.is((Object)4L));
        Assert.assertThat((Object)output.getInteger("intg_count_any"), (Matcher)CoreMatchers.is((Object)4L));
        Assert.assertThat((Object)output.getInteger("intg_count_distinct"), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)output.getInteger("nul_min"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)output.getInteger("nul_max"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)output.getInteger("nul_sum"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)output.getInteger("nul_ave"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)output.getInteger("nul_count"), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)output.getInteger("nul_count_any"), (Matcher)CoreMatchers.is((Object)4L));
        Assert.assertThat((Object)output.getInteger("nul_count_distinct"), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)output.getInteger("mix1_max"), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)output.getInteger("mix1_min"), (Matcher)CoreMatchers.is((Object)-1L));
        Assert.assertThat((Object)output.getInteger("mix1_sum"), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)output.getInteger("mix1_ave"), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)output.getInteger("mix1_count"), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)output.getInteger("mix1_count_any"), (Matcher)CoreMatchers.is((Object)4L));
        Assert.assertThat((Object)output.getInteger("mix1_count_distinct"), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)output.getInteger("mix2_max"), (Matcher)CoreMatchers.is((Object)7L));
        Assert.assertThat((Object)output.getInteger("mix2_min"), (Matcher)CoreMatchers.is((Object)7L));
        Assert.assertThat((Object)output.getInteger("mix2_sum"), (Matcher)CoreMatchers.is((Object)7L));
        Assert.assertThat((Object)output.getNumber("mix2_ave", Double.NaN), (Matcher)CoreMatchers.is((Object)7.0));
        Assert.assertThat((Object)output.getInteger("mix2_count"), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)output.getInteger("mix2_count_any"), (Matcher)CoreMatchers.is((Object)4L));
        Assert.assertThat((Object)output.getInteger("mix2_count_distinct"), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)output.getNumber("mix3_max", Double.NaN), (Matcher)CoreMatchers.is((Object)2.5));
        Assert.assertThat((Object)output.getNumber("mix3_min", Double.NaN), (Matcher)CoreMatchers.is((Object)-1.0));
        Assert.assertThat((Object)output.getNumber("mix3_sum", Double.NaN), (Matcher)CoreMatchers.is((Object)1.5));
        Assert.assertThat((Object)output.getNumber("mix3_ave", Double.NaN), (Matcher)CoreMatchers.is((Object)0.75));
        Assert.assertThat((Object)output.getInteger("mix3_count"), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)output.getInteger("mix3_count_any"), (Matcher)CoreMatchers.is((Object)4L));
        Assert.assertThat((Object)output.getInteger("mix3_count_distinct"), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)output.getNumber("date1_min", Double.NaN), (Matcher)CoreMatchers.is((Object)1.0));
        Assert.assertThat((Object)output.getNumber("date1_max", Double.NaN), (Matcher)CoreMatchers.is((Object)2.0));
        Assert.assertThat((Object)output.getNumber("date1_sum", Double.NaN), (Matcher)CoreMatchers.is((Object)3.0));
        Assert.assertThat((Object)output.getNumber("date1_ave", Double.NaN), (Matcher)CoreMatchers.is((Object)1.5));
        Assert.assertThat((Object)output.getInteger("date1_count"), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)output.getInteger("date1_count_any"), (Matcher)CoreMatchers.is((Object)4L));
        Assert.assertThat((Object)output.getInteger("date1_count_distinct"), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void testCompatibility() throws KettleException {
        this.variables.setVariable("KETTLE_COMPATIBILITY_MEMORY_GROUP_BY_SUM_AVERAGE_RETURN_NUMBER_TYPE", "Y");
        this.addColumn((ValueMetaInterface)new ValueMetaInteger("intg"), 0L, 1L, 1L, 10L);
        this.addColumn((ValueMetaInterface)new ValueMetaInteger("nul"), new Object[0]);
        this.addColumn((ValueMetaInterface)new ValueMetaInteger("mix1"), -1L, 2L);
        this.addColumn((ValueMetaInterface)new ValueMetaInteger("mix2"), null, 7L);
        this.addColumn((ValueMetaInterface)new ValueMetaNumber("mix3"), -1.0, 2.5);
        RowMetaAndData output = this.runStep();
        Assert.assertThat((Object)output.getInteger("intg_min"), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)output.getInteger("intg_max"), (Matcher)CoreMatchers.is((Object)10L));
        Assert.assertThat((Object)output.getInteger("intg_sum"), (Matcher)CoreMatchers.is((Object)12L));
        Assert.assertThat((Object)output.getInteger("intg_ave"), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)output.getInteger("intg_count"), (Matcher)CoreMatchers.is((Object)4L));
        Assert.assertThat((Object)output.getInteger("intg_count_any"), (Matcher)CoreMatchers.is((Object)4L));
        Assert.assertThat((Object)output.getInteger("intg_count_distinct"), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)output.getInteger("nul_min"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)output.getInteger("nul_max"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)output.getInteger("nul_sum"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)output.getInteger("nul_ave"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)output.getInteger("nul_count"), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)output.getInteger("nul_count_any"), (Matcher)CoreMatchers.is((Object)4L));
        Assert.assertThat((Object)output.getInteger("nul_count_distinct"), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)output.getInteger("mix1_max"), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)output.getInteger("mix1_min"), (Matcher)CoreMatchers.is((Object)-1L));
        Assert.assertThat((Object)output.getInteger("mix1_sum"), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)output.getNumber("mix1_ave", Double.NaN), (Matcher)CoreMatchers.is((Object)0.5));
        Assert.assertThat((Object)output.getInteger("mix1_count"), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)output.getInteger("mix1_count_any"), (Matcher)CoreMatchers.is((Object)4L));
        Assert.assertThat((Object)output.getInteger("mix1_count_distinct"), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)output.getInteger("mix2_max"), (Matcher)CoreMatchers.is((Object)7L));
        Assert.assertThat((Object)output.getInteger("mix2_min"), (Matcher)CoreMatchers.is((Object)7L));
        Assert.assertThat((Object)output.getInteger("mix2_sum"), (Matcher)CoreMatchers.is((Object)7L));
        Assert.assertThat((Object)output.getNumber("mix2_ave", Double.NaN), (Matcher)CoreMatchers.is((Object)7.0));
        Assert.assertThat((Object)output.getInteger("mix2_count"), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)output.getInteger("mix2_count_any"), (Matcher)CoreMatchers.is((Object)4L));
        Assert.assertThat((Object)output.getInteger("mix2_count_distinct"), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)output.getNumber("mix3_max", Double.NaN), (Matcher)CoreMatchers.is((Object)2.5));
        Assert.assertThat((Object)output.getNumber("mix3_min", Double.NaN), (Matcher)CoreMatchers.is((Object)-1.0));
        Assert.assertThat((Object)output.getNumber("mix3_sum", Double.NaN), (Matcher)CoreMatchers.is((Object)1.5));
        Assert.assertThat((Object)output.getNumber("mix3_ave", Double.NaN), (Matcher)CoreMatchers.is((Object)0.75));
        Assert.assertThat((Object)output.getInteger("mix3_count"), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)output.getInteger("mix3_count_any"), (Matcher)CoreMatchers.is((Object)4L));
        Assert.assertThat((Object)output.getInteger("mix3_count_distinct"), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void testNullMin() throws Exception {
        this.variables.setVariable("KETTLE_AGGREGATION_MIN_NULL_IS_VALUED", "Y");
        this.addColumn((ValueMetaInterface)new ValueMetaInteger("intg"), null, 0L, 1L, -1L);
        this.addColumn((ValueMetaInterface)new ValueMetaString("str"), "A", null, "B", null);
        this.aggregates = Maps.toMap((Iterable)ImmutableList.of((Object)"min", (Object)"max"), (Function)Functions.forMap(default_aggregates));
        RowMetaAndData output = this.runStep();
        Assert.assertThat((Object)output.getInteger("intg_min"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)output.getInteger("intg_max"), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)output.getString("str_min", null), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)output.getString("str_max", "invalid"), (Matcher)CoreMatchers.is((Object)"B"));
    }

    @Test
    public void testNullsAreZeroCompatible() throws Exception {
        this.variables.setVariable("KETTLE_AGGREGATION_ALL_NULLS_ARE_ZERO", "Y");
        this.variables.setVariable("KETTLE_COMPATIBILITY_MEMORY_GROUP_BY_SUM_AVERAGE_RETURN_NUMBER_TYPE", "Y");
        this.addColumn((ValueMetaInterface)new ValueMetaInteger("nul"), new Object[0]);
        this.addColumn((ValueMetaInterface)new ValueMetaInteger("both"), -2L, 0L, null, 10L);
        RowMetaAndData output = this.runStep();
        Assert.assertThat((Object)output.getInteger("nul_min"), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)output.getInteger("nul_max"), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)output.getInteger("nul_sum"), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)output.getInteger("nul_ave"), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)output.getInteger("nul_count"), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)output.getInteger("nul_count_any"), (Matcher)CoreMatchers.is((Object)4L));
        Assert.assertThat((Object)output.getInteger("nul_count_distinct"), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)output.getInteger("both_max"), (Matcher)CoreMatchers.is((Object)10L));
        Assert.assertThat((Object)output.getInteger("both_min"), (Matcher)CoreMatchers.is((Object)-2L));
        Assert.assertThat((Object)output.getInteger("both_sum"), (Matcher)CoreMatchers.is((Object)8L));
        Assert.assertThat((Object)output.getInteger("both_ave"), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)output.getInteger("both_count"), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)output.getInteger("both_count_any"), (Matcher)CoreMatchers.is((Object)4L));
        Assert.assertThat((Object)output.getInteger("both_count_distinct"), (Matcher)CoreMatchers.is((Object)3L));
    }

    @Test
    public void testNullsAreZeroDefault() throws Exception {
        this.variables.setVariable("KETTLE_AGGREGATION_ALL_NULLS_ARE_ZERO", "Y");
        this.addColumn((ValueMetaInterface)new ValueMetaInteger("nul"), new Object[0]);
        this.addColumn((ValueMetaInterface)new ValueMetaInteger("both"), -2L, 0L, null, 10L);
        this.addColumn((ValueMetaInterface)new ValueMetaNumber("both_num"), -2.0, 0.0, null, 10.0);
        RowMetaAndData output = this.runStep();
        Assert.assertThat((Object)output.getInteger("nul_min"), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)output.getInteger("nul_max"), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)output.getInteger("nul_sum"), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)output.getInteger("nul_ave"), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)output.getInteger("nul_count"), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)output.getInteger("nul_count_any"), (Matcher)CoreMatchers.is((Object)4L));
        Assert.assertThat((Object)output.getInteger("nul_count_distinct"), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)output.getInteger("both_max"), (Matcher)CoreMatchers.is((Object)10L));
        Assert.assertThat((Object)output.getInteger("both_min"), (Matcher)CoreMatchers.is((Object)-2L));
        Assert.assertThat((Object)output.getInteger("both_sum"), (Matcher)CoreMatchers.is((Object)8L));
        Assert.assertThat((Object)output.getInteger("both_ave"), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)output.getInteger("both_count"), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)output.getInteger("both_count_any"), (Matcher)CoreMatchers.is((Object)4L));
        Assert.assertThat((Object)output.getInteger("both_count_distinct"), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)output.getNumber("both_num_max", Double.NaN), (Matcher)CoreMatchers.is((Object)10.0));
        Assert.assertThat((Object)output.getNumber("both_num_min", Double.NaN), (Matcher)CoreMatchers.is((Object)-2.0));
        Assert.assertThat((Object)output.getNumber("both_num_sum", Double.NaN), (Matcher)CoreMatchers.is((Object)8.0));
        Assert.assertEquals((double)2.666666, (double)output.getNumber("both_num_ave", Double.NaN), (double)1.0E-6);
        Assert.assertThat((Object)output.getInteger("both_num_count"), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)output.getInteger("both_num_count_any"), (Matcher)CoreMatchers.is((Object)4L));
        Assert.assertThat((Object)output.getInteger("both_num_count_distinct"), (Matcher)CoreMatchers.is((Object)3L));
    }

    @Test
    public void testSQLCompatible() throws Exception {
        this.addColumn((ValueMetaInterface)new ValueMetaInteger("value"), null, -2L, null, 0L, null, 10L, null, null, 0L, null);
        RowMetaAndData output = this.runStep();
        Assert.assertThat((Object)output.getInteger("value_max"), (Matcher)CoreMatchers.is((Object)10L));
        Assert.assertThat((Object)output.getInteger("value_min"), (Matcher)CoreMatchers.is((Object)-2L));
        Assert.assertThat((Object)output.getInteger("value_sum"), (Matcher)CoreMatchers.is((Object)8L));
        Assert.assertThat((Object)output.getInteger("value_ave"), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)output.getInteger("value_count"), (Matcher)CoreMatchers.is((Object)4L));
        Assert.assertThat((Object)output.getInteger("value_count_any"), (Matcher)CoreMatchers.is((Object)10L));
        Assert.assertThat((Object)output.getInteger("value_count_distinct"), (Matcher)CoreMatchers.is((Object)3L));
    }

    private RowMetaAndData runStep() throws KettleException {
        ImmutableList aggKeys = ImmutableList.copyOf(this.aggregates.keySet());
        MemoryGroupByMeta meta = new MemoryGroupByMeta();
        meta.allocate(0, this.rowMeta.size() * aggKeys.size());
        for (int i = 0; i < this.rowMeta.size(); ++i) {
            String name = this.rowMeta.getValueMeta(i).getName();
            for (int j = 0; j < aggKeys.size(); ++j) {
                String aggKey = (String)aggKeys.get(j);
                int index = i * aggKeys.size() + j;
                meta.getAggregateField()[index] = name + "_" + aggKey;
                meta.getSubjectField()[index] = name;
                meta.getAggregateType()[index] = this.aggregates.get(aggKey);
            }
        }
        MemoryGroupByData data = new MemoryGroupByData();
        data.map = Maps.newHashMap();
        TransMeta transMeta = (TransMeta)Mockito.mock(TransMeta.class);
        StepMeta stepMeta = new StepMeta(STEP_NAME, (StepMetaInterface)meta);
        Mockito.when((Object)transMeta.findStep(STEP_NAME)).thenReturn((Object)stepMeta);
        MemoryGroupBy step = (MemoryGroupBy)Mockito.spy((Object)new MemoryGroupBy(stepMeta, (StepDataInterface)data, 0, transMeta, (Trans)Mockito.mock(Trans.class)));
        step.copyVariablesFrom((VariableSpace)this.variables);
        ((MemoryGroupBy)Mockito.doNothing().when((Object)step)).putRow((RowMetaInterface)Matchers.any(), (Object[])Matchers.any());
        ((MemoryGroupBy)Mockito.doNothing().when((Object)step)).setOutputDone();
        ((MemoryGroupBy)Mockito.doReturn((Object)this.rowMeta).when((Object)step)).getInputRowMeta();
        for (Object[] row : this.getRows()) {
            ((MemoryGroupBy)Mockito.doReturn((Object)row).when((Object)step)).getRow();
            Assert.assertThat((Object)step.processRow((StepMetaInterface)meta, (StepDataInterface)data), (Matcher)CoreMatchers.is((Object)true));
        }
        ((MemoryGroupBy)Mockito.verify((Object)step, (VerificationMode)Mockito.never())).putRow((RowMetaInterface)Matchers.any(), (Object[])Matchers.any());
        ((MemoryGroupBy)Mockito.doReturn(null).when((Object)step)).getRow();
        Assert.assertThat((Object)step.processRow((StepMetaInterface)meta, (StepDataInterface)data), (Matcher)CoreMatchers.is((Object)false));
        ((MemoryGroupBy)Mockito.verify((Object)step)).setOutputDone();
        ArgumentCaptor rowMetaCaptor = ArgumentCaptor.forClass(RowMetaInterface.class);
        ArgumentCaptor rowCaptor = ArgumentCaptor.forClass(Object[].class);
        ((MemoryGroupBy)Mockito.verify((Object)step)).putRow((RowMetaInterface)rowMetaCaptor.capture(), (Object[])rowCaptor.capture());
        return new RowMetaAndData((RowMetaInterface)rowMetaCaptor.getValue(), (Object[])rowCaptor.getValue());
    }

    private void addColumn(ValueMetaInterface meta, Object ... values) {
        int column = this.rowMeta.size();
        this.rowMeta.addValueMeta(meta);
        for (int row = 0; row < values.length; ++row) {
            this.data.put((Object)row, (Object)column, (Object)Optional.fromNullable((Object)values[row]));
        }
    }

    private Iterable<Object[]> getRows() {
        if (this.data.isEmpty()) {
            return ImmutableSet.of();
        }
        Range rows = Range.closed((Comparable)Integer.valueOf(0), (Comparable)((Comparable)this.data.rowMap().lastKey()));
        return FluentIterable.from((Iterable)ContiguousSet.create((Range)rows, (DiscreteDomain)DiscreteDomain.integers())).transform(Functions.forMap((Map)this.data.rowMap(), (Object)ImmutableMap.of())).transform((Function)new Function<Map<Integer, Optional<Object>>, Object[]>(){

            public Object[] apply(Map<Integer, Optional<Object>> input) {
                Object[] row = new Object[MemoryGroupByAggregationTest.this.rowMeta.size()];
                for (Map.Entry<Integer, Optional<Object>> entry : input.entrySet()) {
                    row[entry.getKey().intValue()] = entry.getValue().orNull();
                }
                return row;
            }
        });
    }
}

