/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mappinginput;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaPluginType;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.trans.steps.mapping.MappingValueRename;
import org.pentaho.di.trans.steps.mappinginput.MappingInputMeta;

@RunWith(value=Parameterized.class)
public class MappingInputMeta_GetFields_Test {
    private final RowMeta inputRowMeta;
    private final List<MappingValueRename> renames;
    private final String[] fields;
    private final boolean sortUnspecified;
    private final String[] expectedOutputFields;

    @BeforeClass
    public static void setUpBeforeClass() throws KettlePluginException {
        ValueMetaPluginType.getInstance().searchPlugins();
    }

    @Parameterized.Parameters
    public static List<Object[]> getData() {
        return Arrays.asList(MappingInputMeta_GetFields_Test.simpleRename(), MappingInputMeta_GetFields_Test.renameAndSort(), MappingInputMeta_GetFields_Test.noRenames(), MappingInputMeta_GetFields_Test.noInputRowMeta(), MappingInputMeta_GetFields_Test.alreadyRenamed());
    }

    private static Object[] createCaseData(RowMeta inputRowMeta, List<MappingValueRename> renames, String[] fields, boolean sortUnspecified, String[] expectedOutputFields) {
        return new Object[]{inputRowMeta, renames, fields, sortUnspecified, expectedOutputFields};
    }

    private static Object[] createCaseData(RowMeta inputRowMeta, List<MappingValueRename> renames, String[] fields, String[] expectedOutputFields) {
        return MappingInputMeta_GetFields_Test.createCaseData(inputRowMeta, renames, fields, false, expectedOutputFields);
    }

    private static RowMeta createRowMeta(String ... fields) {
        RowMeta meta = new RowMeta();
        for (String field : fields) {
            meta.addValueMeta((ValueMetaInterface)new ValueMetaString(field));
        }
        return meta;
    }

    private static Object[] simpleRename() {
        RowMeta inputRowMeta = MappingInputMeta_GetFields_Test.createRowMeta("field1", "field2");
        List<MappingValueRename> renames = Collections.singletonList(new MappingValueRename("field2", "renamed"));
        String[] fields = new String[]{"field1", "renamed"};
        String[] expected = new String[]{"field1", "renamed"};
        return MappingInputMeta_GetFields_Test.createCaseData(inputRowMeta, renames, fields, expected);
    }

    private static Object[] renameAndSort() {
        RowMeta inputRowMeta = MappingInputMeta_GetFields_Test.createRowMeta("field1", "field2", "2", "1");
        List<MappingValueRename> renames = Collections.singletonList(new MappingValueRename("field2", "renamed"));
        String[] fields = new String[]{"field1", "renamed"};
        String[] expected = new String[]{"field1", "renamed", "1", "2"};
        return MappingInputMeta_GetFields_Test.createCaseData(inputRowMeta, renames, fields, true, expected);
    }

    private static Object[] noRenames() {
        RowMeta inputRowMeta = MappingInputMeta_GetFields_Test.createRowMeta("field1", "field2");
        String[] fields = new String[]{"field1", "field2"};
        String[] expected = new String[]{"field1", "field2"};
        return MappingInputMeta_GetFields_Test.createCaseData(inputRowMeta, null, fields, expected);
    }

    private static Object[] noInputRowMeta() {
        String[] fields = new String[]{"field1", "field2"};
        String[] expected = new String[]{"field1", "field2"};
        return MappingInputMeta_GetFields_Test.createCaseData(null, null, fields, expected);
    }

    private static Object[] alreadyRenamed() {
        RowMeta inputRowMeta = MappingInputMeta_GetFields_Test.createRowMeta("field1", "renamed");
        List<MappingValueRename> renames = Collections.singletonList(new MappingValueRename("field2", "renamed"));
        String[] fields = new String[]{"field1", "renamed"};
        String[] expected = new String[]{"field1", "renamed"};
        return MappingInputMeta_GetFields_Test.createCaseData(inputRowMeta, renames, fields, expected);
    }

    public MappingInputMeta_GetFields_Test(RowMeta inputRowMeta, List<MappingValueRename> renames, String[] fields, boolean sortUnspecified, String[] expectedOutputFields) {
        this.inputRowMeta = inputRowMeta;
        this.renames = renames;
        this.fields = fields;
        this.sortUnspecified = sortUnspecified;
        this.expectedOutputFields = expectedOutputFields;
    }

    @Test
    public void getFields() throws Exception {
        MappingInputMeta meta = new MappingInputMeta();
        meta.setInputRowMeta((RowMetaInterface)this.inputRowMeta);
        meta.setValueRenames(this.renames);
        meta.allocate(this.fields.length);
        meta.setFieldName(this.fields);
        meta.setSelectingAndSortingUnspecifiedFields(this.sortUnspecified);
        RowMeta rowMeta = new RowMeta();
        meta.getFields((RowMetaInterface)rowMeta, "origin", new RowMetaInterface[0], null, null, null, null);
        Assert.assertEquals((String)Arrays.toString(this.expectedOutputFields), (long)this.expectedOutputFields.length, (long)rowMeta.size());
        for (int i = 0; i < rowMeta.size(); ++i) {
            Assert.assertEquals((String)String.format("Element %d", i), (Object)this.expectedOutputFields[i], (Object)rowMeta.getValueMeta(i).getName());
        }
    }
}

