/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mappinginput;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.NonZeroIntLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.PrimitiveIntArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.di.trans.steps.mapping.MappingValueRename;
import org.pentaho.di.trans.steps.mappinginput.MappingInputMeta;

public class MappingInputMetaCloningTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    LoadSaveTester<MappingInputMeta> loadSaveTester;

    @Test
    public void clonesCorrectly() throws Exception {
        MappingInputMeta meta = new MappingInputMeta();
        meta.setFieldName(new String[]{"f1", "f2"});
        meta.setFieldType(new int[]{5, 2});
        meta.setFieldLength(new int[]{1, 2});
        meta.setFieldPrecision(new int[]{3, 4});
        meta.setChanged();
        meta.setValueRenames(Collections.singletonList(new MappingValueRename("f1", "r1")));
        Object clone = meta.clone();
        if (!EqualsBuilder.reflectionEquals((Object)meta, (Object)clone)) {
            String template = "clone() is expected to handle all values.\n\tOriginal object:\n%s\n\tCloned object:\n%s";
            Assert.fail((String)String.format(template, ToStringBuilder.reflectionToString((Object)meta), ToStringBuilder.reflectionToString((Object)clone)));
        }
    }

    @Before
    public void setUp() throws Exception {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
        List<String> attributes = Arrays.asList("selectingAndSortingUnspecifiedFields", "fieldName", "fieldType", "fieldLength", "fieldPrecision");
        HashMap<String, String> getterMap = new HashMap<String, String>(){
            {
                this.put("selectingAndSortingUnspecifiedFields", "isSelectingAndSortingUnspecifiedFields");
                this.put("fieldName", "getFieldName");
                this.put("fieldType", "getFieldType");
                this.put("fieldLength", "getFieldLength");
                this.put("fieldPrecision", "getFieldPrecision");
            }
        };
        HashMap<String, String> setterMap = new HashMap<String, String>(){
            {
                this.put("selectingAndSortingUnspecifiedFields", "setSelectingAndSortingUnspecifiedFields");
                this.put("fieldName", "setFieldName");
                this.put("fieldType", "setFieldType");
                this.put("fieldLength", "setFieldLength");
                this.put("fieldPrecision", "setFieldPrecision");
            }
        };
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5);
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("fieldName", stringArrayLoadSaveValidator);
        HashMap typeValidatorMap = new HashMap();
        typeValidatorMap.put(int[].class.getCanonicalName(), new PrimitiveIntArrayLoadSaveValidator(new NonZeroIntLoadSaveValidator(6), 5));
        this.loadSaveTester = new LoadSaveTester<MappingInputMeta>(MappingInputMeta.class, attributes, (Map<String, String>)getterMap, (Map<String, String>)setterMap, attrValidatorMap, typeValidatorMap);
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }
}

