/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mapping;

import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.SingleThreadedTransExecutor;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.StepMockUtil;
import org.pentaho.di.trans.steps.mapping.Mapping;
import org.pentaho.di.trans.steps.mapping.MappingData;
import org.pentaho.di.trans.steps.mapping.MappingIODefinition;
import org.pentaho.di.trans.steps.mapping.MappingMeta;
import org.pentaho.di.trans.steps.mappinginput.MappingInput;
import org.pentaho.di.trans.steps.mappingoutput.MappingOutput;
import org.pentaho.di.trans.steps.mock.StepMockHelper;

public class MappingUnitTest {
    private StepMockHelper<MappingMeta, StepDataInterface> mockHelper;
    private Mapping mapping;

    @Before
    public void setUp() throws Exception {
        this.mockHelper = StepMockUtil.getStepMockHelper(MappingMeta.class, "MappingUnitTest");
        this.mapping = new Mapping(this.mockHelper.stepMeta, this.mockHelper.stepDataInterface, 0, this.mockHelper.transMeta, this.mockHelper.trans);
    }

    @After
    public void cleanUp() {
        this.mockHelper.cleanUp();
    }

    @Test
    public void pickupTargetStepsFor_OutputIsNotDefined() throws Exception {
        StepMeta singleMeta = new StepMeta("single", null);
        StepMeta copiedMeta = new StepMeta("copied", null);
        Mockito.when((Object)this.mockHelper.transMeta.findNextSteps(this.mockHelper.stepMeta)).thenReturn(Arrays.asList(singleMeta, copiedMeta));
        StepInterface single = (StepInterface)Mockito.mock(StepInterface.class);
        Mockito.when((Object)this.mockHelper.trans.findStepInterfaces("single")).thenReturn(Collections.singletonList(single));
        StepInterface copy1 = (StepInterface)Mockito.mock(StepInterface.class);
        StepInterface copy2 = (StepInterface)Mockito.mock(StepInterface.class);
        Mockito.when((Object)this.mockHelper.trans.findStepInterfaces("copied")).thenReturn(Arrays.asList(copy1, copy2));
        MappingIODefinition definition = new MappingIODefinition(null, null);
        StepInterface[] targetSteps = this.mapping.pickupTargetStepsFor(definition);
        Assert.assertThat(Arrays.asList(targetSteps), (Matcher)JUnitMatchers.hasItems((Matcher[])new Matcher[]{CoreMatchers.is((Object)single), CoreMatchers.is((Object)copy1), CoreMatchers.is((Object)copy2)}));
    }

    @Test
    public void pickupTargetStepsFor_OutputIsDefined() throws Exception {
        StepInterface copy1 = (StepInterface)Mockito.mock(StepInterface.class);
        StepInterface copy2 = (StepInterface)Mockito.mock(StepInterface.class);
        Mockito.when((Object)this.mockHelper.trans.findStepInterfaces("copied")).thenReturn(Arrays.asList(copy1, copy2));
        MappingIODefinition definition = new MappingIODefinition(null, "copied");
        StepInterface[] targetSteps = this.mapping.pickupTargetStepsFor(definition);
        Assert.assertThat(Arrays.asList(targetSteps), (Matcher)JUnitMatchers.hasItems((Matcher[])new Matcher[]{CoreMatchers.is((Object)copy1), CoreMatchers.is((Object)copy2)}));
    }

    @Test(expected=KettleException.class)
    public void pickupTargetStepsFor_OutputIsDefined_ThrowsExceptionIfFindsNone() throws Exception {
        MappingIODefinition definition = new MappingIODefinition(null, "non-existing");
        this.mapping.pickupTargetStepsFor(definition);
    }

    @Test
    public void testDispose() throws Exception {
        MappingMeta meta = (MappingMeta)Mockito.mock(MappingMeta.class);
        MappingData data = (MappingData)Mockito.mock(MappingData.class);
        Mockito.when((Object)data.getMappingTrans()).thenReturn((Object)this.mockHelper.trans);
        MappingInput[] mappingInputs = new MappingInput[]{(MappingInput)Mockito.mock(MappingInput.class)};
        MappingOutput[] mappingOutputs = new MappingOutput[]{(MappingOutput)Mockito.mock(MappingOutput.class)};
        Mockito.when((Object)this.mockHelper.trans.findMappingInput()).thenReturn((Object)mappingInputs);
        Mockito.when((Object)this.mockHelper.trans.findMappingOutput()).thenReturn((Object)mappingOutputs);
        data.mappingTransMeta = this.mockHelper.transMeta;
        Mockito.when((Object)data.mappingTransMeta.getTransformationType()).thenReturn((Object)TransMeta.TransformationType.SingleThreaded);
        data.singleThreadedTransExcecutor = (SingleThreadedTransExecutor)Mockito.mock(SingleThreadedTransExecutor.class);
        Mockito.when((Object)data.singleThreadedTransExcecutor.oneIteration()).thenReturn((Object)true);
        data.mappingTrans = this.mockHelper.trans;
        Mockito.when((Object)this.mockHelper.trans.isFinished()).thenReturn((Object)false);
        Mapping mapping = (Mapping)Mockito.spy((Object)new Mapping(this.mockHelper.stepMeta, (StepDataInterface)data, 0, this.mockHelper.transMeta, this.mockHelper.trans));
        String stepName = "StepName";
        mapping.setStepname(stepName);
        mapping.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        mapping.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        ((Trans)Mockito.verify((Object)this.mockHelper.trans, (VerificationMode)Mockito.times((int)1))).removeActiveSubTransformation(stepName);
    }
}

