/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mapping;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.mapping.MappingValueRename;
import org.pentaho.di.trans.steps.mappingoutput.MappingOutputMeta;
import org.pentaho.metastore.api.IMetaStore;

public class MappingOutputMetaIT {
    private Repository repository = (Repository)Mockito.mock(Repository.class);
    private IMetaStore metaStore = (IMetaStore)Mockito.mock(IMetaStore.class);
    private VariableSpace space = (VariableSpace)Mockito.mock(VariableSpace.class);
    private StepMeta nextStep = (StepMeta)Mockito.mock(StepMeta.class);
    private RowMetaInterface[] info = new RowMetaInterface[]{(RowMetaInterface)Mockito.mock(RowMetaInterface.class)};

    @Test
    public void testGetFields_OutputValueRenames_WillRenameOutputIfValueMetaExist() throws KettleStepException {
        ValueMetaBase valueMeta1 = new ValueMetaBase("valueMeta1");
        ValueMetaBase valueMeta2 = new ValueMetaBase("valueMeta2");
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)valueMeta1);
        rowMeta.addValueMeta((ValueMetaInterface)valueMeta2);
        ArrayList<MappingValueRename> outputValueRenames = new ArrayList<MappingValueRename>();
        outputValueRenames.add(new MappingValueRename("valueMeta2", "valueMeta1"));
        MappingOutputMeta meta = new MappingOutputMeta();
        meta.setOutputValueRenames(outputValueRenames);
        meta.getFields((RowMetaInterface)rowMeta, null, this.info, this.nextStep, this.space, this.repository, this.metaStore);
        Assert.assertEquals((long)2L, (long)rowMeta.getValueMetaList().size());
        Assert.assertEquals((Object)valueMeta1, (Object)rowMeta.getValueMeta(0));
        Assert.assertFalse((boolean)"valueMeta1".equals(rowMeta.getValueMeta(1).getName()));
        Assert.assertTrue((boolean)"valueMeta1_1".equals(rowMeta.getValueMeta(1).getName()));
    }
}

