/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mailinput;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.commons.lang.StringUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.AdditionalMatchers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.job.entries.getpop.MailConnection;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mailinput.MailInput;
import org.pentaho.di.trans.steps.mailinput.MailInputData;
import org.pentaho.di.trans.steps.mailinput.MailInputField;
import org.pentaho.di.trans.steps.mailinput.MailInputMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;

public class ParseMailInputTest {
    private static StepMockHelper<MailInputMeta, StepDataInterface> stepMockHelper;
    public static final int MSG_NUMB = 3;
    public static final String MSG_BODY = "msg_body";
    public static final String FLD_NAME = "junit_folder";
    public static final int ATTCH_COUNT = 3;
    public static final String CNTNT_TYPE = "text/html";
    public static final String FROM1 = "localhost_1";
    public static final String FROM2 = "localhost_2";
    public static final String REP1 = "127.0.0.1";
    public static final String REP2 = "127.0.0.2";
    public static final String REC1 = "Vasily";
    public static final String REC2 = "Pupkin";
    public static final String SUBJ = "mocktest";
    public static final String DESC = "desc";
    public static final Date DATE1;
    public static final Date DATE2;
    public static final String CNTNT_TYPE_EMAIL = "application/acad";
    public static int CNTNT_SIZE;
    public static String HDR_EX1;
    public static String HDR_EX1V;
    public static String HDR_EX2;
    public static String HDR_EX2V;
    private Message message;
    private MailInputData data;
    private MailInputMeta meta;
    private MailInput mailInput;

    @BeforeClass
    public static void setup() {
        stepMockHelper = new StepMockHelper<MailInputMeta, StepDataInterface>("ABORT TEST", MailInputMeta.class, StepDataInterface.class);
        Mockito.when((Object)ParseMailInputTest.stepMockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)ParseMailInputTest.stepMockHelper.logChannelInterface);
        Mockito.when((Object)ParseMailInputTest.stepMockHelper.trans.isRunning()).thenReturn((Object)true);
    }

    @AfterClass
    public static void tearDown() {
        stepMockHelper.cleanUp();
    }

    @Before
    public void beforeTest() throws MessagingException, IOException, KettleException {
        this.message = (Message)Mockito.mock(Message.class);
        MailConnection conn = (MailConnection)Mockito.mock(MailConnection.class);
        Mockito.when((Object)conn.getMessageBody((Message)Matchers.any(Message.class))).thenReturn((Object)MSG_BODY);
        Mockito.when((Object)conn.getFolderName()).thenReturn((Object)FLD_NAME);
        Mockito.when((Object)conn.getAttachedFilesCount((Message)Matchers.any(Message.class), (Pattern)Matchers.any(Pattern.class))).thenReturn((Object)3);
        Mockito.when((Object)conn.getMessageBodyContentType((Message)Matchers.any(Message.class))).thenReturn((Object)CNTNT_TYPE);
        this.data = (MailInputData)Mockito.mock(MailInputData.class);
        this.data.mailConn = conn;
        this.mailInput = new MailInput(ParseMailInputTest.stepMockHelper.stepMeta, (StepDataInterface)this.data, 0, ParseMailInputTest.stepMockHelper.transMeta, ParseMailInputTest.stepMockHelper.trans);
        Address addrFrom1 = (Address)Mockito.mock(Address.class);
        Mockito.when((Object)addrFrom1.toString()).thenReturn((Object)FROM1);
        Address addrFrom2 = (Address)Mockito.mock(Address.class);
        Mockito.when((Object)addrFrom2.toString()).thenReturn((Object)FROM2);
        Address addrRep1 = (Address)Mockito.mock(Address.class);
        Mockito.when((Object)addrRep1.toString()).thenReturn((Object)REP1);
        Address addrRep2 = (Address)Mockito.mock(Address.class);
        Mockito.when((Object)addrRep2.toString()).thenReturn((Object)REP2);
        Address allRec1 = (Address)Mockito.mock(Address.class);
        Mockito.when((Object)allRec1.toString()).thenReturn((Object)REC1);
        Address allRec2 = (Address)Mockito.mock(Address.class);
        Mockito.when((Object)allRec2.toString()).thenReturn((Object)REC2);
        Address[] adrFr = new Address[]{addrFrom1, addrFrom2};
        Address[] adrRep = new Address[]{addrRep1, addrRep2};
        Address[] adrRecip = new Address[]{allRec1, allRec2};
        this.message = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)this.message.getMessageNumber()).thenReturn((Object)3);
        Mockito.when((Object)this.message.getSubject()).thenReturn((Object)SUBJ);
        Mockito.when((Object)this.message.getFrom()).thenReturn((Object)adrFr);
        Mockito.when((Object)this.message.getReplyTo()).thenReturn((Object)adrRep);
        Mockito.when((Object)this.message.getAllRecipients()).thenReturn((Object)adrRecip);
        Mockito.when((Object)this.message.getDescription()).thenReturn((Object)DESC);
        Mockito.when((Object)this.message.getReceivedDate()).thenReturn((Object)DATE1);
        Mockito.when((Object)this.message.getSentDate()).thenReturn((Object)DATE2);
        Mockito.when((Object)this.message.getContentType()).thenReturn((Object)CNTNT_TYPE_EMAIL);
        Mockito.when((Object)this.message.getSize()).thenReturn((Object)CNTNT_SIZE);
        Header ex1 = new Header(HDR_EX1, HDR_EX1V);
        Header ex2 = new Header(HDR_EX2, HDR_EX2V);
        Mockito.when((Object)this.message.getMatchingHeaders((String[])AdditionalMatchers.aryEq((Object[])new String[]{HDR_EX1}))).thenReturn(this.getEnum(new Header[]{ex1}));
        Mockito.when((Object)this.message.getMatchingHeaders((String[])AdditionalMatchers.aryEq((Object[])new String[]{HDR_EX2}))).thenReturn(this.getEnum(new Header[]{ex2}));
        Mockito.when((Object)this.message.getMatchingHeaders((String[])AdditionalMatchers.aryEq((Object[])new String[]{HDR_EX1, HDR_EX2}))).thenReturn(this.getEnum(new Header[]{ex1, ex2}));
        Mockito.when((Object)this.message.getHeader((String)Matchers.eq((Object)HDR_EX1))).thenReturn((Object)new String[]{ex1.getValue()});
        Mockito.when((Object)this.message.getHeader((String)Matchers.eq((Object)HDR_EX2))).thenReturn((Object)new String[]{ex2.getValue()});
    }

    @Test
    public void testHeadersParsedPositive() throws Exception {
        int[] fields = new int[]{18};
        MailInputField[] farr = this.getDefaultInputFields(fields);
        farr[0].setName(HDR_EX1);
        this.mockMailInputMeta(farr);
        try {
            this.mailInput.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        MailInput.MessageParser underTest = new MailInput.MessageParser(this.mailInput);
        Object[] r = RowDataUtil.allocateRowData((int)this.data.nrFields);
        underTest.parseToArray(r, this.message);
        Assert.assertEquals((String)"Header is correct", (Object)HDR_EX1V, String.class.cast(r[0]));
    }

    @Test
    public void testHeadersParsedNegative() throws Exception {
        int[] fields = new int[]{18};
        MailInputField[] farr = this.getDefaultInputFields(fields);
        farr[0].setName(HDR_EX1 + "salt");
        this.mockMailInputMeta(farr);
        try {
            this.mailInput.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        MailInput.MessageParser underTest = new MailInput.MessageParser(this.mailInput);
        Object[] r = RowDataUtil.allocateRowData((int)this.data.nrFields);
        underTest.parseToArray(r, this.message);
        Assert.assertEquals((String)"Header is correct", (Object)"", String.class.cast(r[0]));
    }

    @Test
    public void testMessageNumberIsParsed() throws Exception {
        int[] fields = new int[]{0};
        MailInputField[] farr = this.getDefaultInputFields(fields);
        this.mockMailInputMeta(farr);
        try {
            this.mailInput.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        MailInput.MessageParser underTest = new MailInput.MessageParser(this.mailInput);
        Object[] r = RowDataUtil.allocateRowData((int)this.data.nrFields);
        underTest.parseToArray(r, this.message);
        Assert.assertEquals((String)"Message number is correct", (Object)new Long(3L), Long.class.cast(r[0]));
    }

    @Test
    public void testMessageSubjectIsParsed() throws Exception {
        int[] fields = new int[]{1};
        MailInputField[] farr = this.getDefaultInputFields(fields);
        this.mockMailInputMeta(farr);
        try {
            this.mailInput.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        MailInput.MessageParser underTest = new MailInput.MessageParser(this.mailInput);
        Object[] r = RowDataUtil.allocateRowData((int)this.data.nrFields);
        underTest.parseToArray(r, this.message);
        Assert.assertEquals((String)"Message subject is correct", (Object)SUBJ, String.class.cast(r[0]));
    }

    @Test
    public void testMessageFromIsParsed() throws Exception {
        int[] fields = new int[]{2};
        MailInputField[] farr = this.getDefaultInputFields(fields);
        this.mockMailInputMeta(farr);
        try {
            this.mailInput.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        MailInput.MessageParser underTest = new MailInput.MessageParser(this.mailInput);
        Object[] r = RowDataUtil.allocateRowData((int)this.data.nrFields);
        underTest.parseToArray(r, this.message);
        String expected = StringUtils.join((Object[])new String[]{FROM1, FROM2}, (String)";");
        Assert.assertEquals((String)"Message From is correct", (Object)expected, String.class.cast(r[0]));
    }

    @Test
    public void testMessageReplayToIsParsed() throws Exception {
        int[] fields = new int[]{3};
        MailInputField[] farr = this.getDefaultInputFields(fields);
        this.mockMailInputMeta(farr);
        try {
            this.mailInput.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        MailInput.MessageParser underTest = new MailInput.MessageParser(this.mailInput);
        Object[] r = RowDataUtil.allocateRowData((int)this.data.nrFields);
        underTest.parseToArray(r, this.message);
        String expected = StringUtils.join((Object[])new String[]{REP1, REP2}, (String)";");
        Assert.assertEquals((String)"Message ReplayTo is correct", (Object)expected, String.class.cast(r[0]));
    }

    @Test
    public void testMessageRecipientsIsParsed() throws Exception {
        int[] fields = new int[]{4};
        MailInputField[] farr = this.getDefaultInputFields(fields);
        this.mockMailInputMeta(farr);
        try {
            this.mailInput.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        MailInput.MessageParser underTest = new MailInput.MessageParser(this.mailInput);
        Object[] r = RowDataUtil.allocateRowData((int)this.data.nrFields);
        underTest.parseToArray(r, this.message);
        String expected = StringUtils.join((Object[])new String[]{REC1, REC2}, (String)";");
        Assert.assertEquals((String)"Message Recipients is correct", (Object)expected, String.class.cast(r[0]));
    }

    @Test
    public void testMessageDescriptionIsParsed() throws Exception {
        int[] fields = new int[]{5};
        MailInputField[] farr = this.getDefaultInputFields(fields);
        this.mockMailInputMeta(farr);
        try {
            this.mailInput.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        MailInput.MessageParser underTest = new MailInput.MessageParser(this.mailInput);
        Object[] r = RowDataUtil.allocateRowData((int)this.data.nrFields);
        underTest.parseToArray(r, this.message);
        Assert.assertEquals((String)"Message Description is correct", (Object)DESC, String.class.cast(r[0]));
    }

    @Test
    public void testMessageRecivedDateIsParsed() throws Exception {
        int[] fields = new int[]{7};
        MailInputField[] farr = this.getDefaultInputFields(fields);
        this.mockMailInputMeta(farr);
        try {
            this.mailInput.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        MailInput.MessageParser underTest = new MailInput.MessageParser(this.mailInput);
        Object[] r = RowDataUtil.allocateRowData((int)this.data.nrFields);
        underTest.parseToArray(r, this.message);
        Assert.assertEquals((String)"Message Recived date is correct", (Object)DATE1, Date.class.cast(r[0]));
    }

    @Test
    public void testMessageSentDateIsParsed() throws Exception {
        int[] fields = new int[]{8};
        MailInputField[] farr = this.getDefaultInputFields(fields);
        this.mockMailInputMeta(farr);
        try {
            this.mailInput.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        MailInput.MessageParser underTest = new MailInput.MessageParser(this.mailInput);
        Object[] r = RowDataUtil.allocateRowData((int)this.data.nrFields);
        underTest.parseToArray(r, this.message);
        Assert.assertEquals((String)"Message Sent date is correct", (Object)DATE2, Date.class.cast(r[0]));
    }

    @Test
    public void testMessageContentTypeIsParsed() throws Exception {
        int[] fields = new int[]{9};
        MailInputField[] farr = this.getDefaultInputFields(fields);
        this.mockMailInputMeta(farr);
        try {
            this.mailInput.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        MailInput.MessageParser underTest = new MailInput.MessageParser(this.mailInput);
        Object[] r = RowDataUtil.allocateRowData((int)this.data.nrFields);
        underTest.parseToArray(r, this.message);
        Assert.assertEquals((String)"Message Content type is correct", (Object)CNTNT_TYPE_EMAIL, String.class.cast(r[0]));
    }

    @Test
    public void testMessageSizeIsParsed() throws Exception {
        int[] fields = new int[]{11};
        MailInputField[] farr = this.getDefaultInputFields(fields);
        this.mockMailInputMeta(farr);
        try {
            this.mailInput.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        MailInput.MessageParser underTest = new MailInput.MessageParser(this.mailInput);
        Object[] r = RowDataUtil.allocateRowData((int)this.data.nrFields);
        underTest.parseToArray(r, this.message);
        Assert.assertEquals((String)"Message Size is correct", (Object)new Long(CNTNT_SIZE), Long.class.cast(r[0]));
    }

    @Test
    public void testMessageBodyIsParsed() throws Exception {
        int[] fields = new int[]{6};
        MailInputField[] farr = this.getDefaultInputFields(fields);
        this.mockMailInputMeta(farr);
        try {
            this.mailInput.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        MailInput.MessageParser underTest = new MailInput.MessageParser(this.mailInput);
        Object[] r = RowDataUtil.allocateRowData((int)this.data.nrFields);
        underTest.parseToArray(r, this.message);
        Assert.assertEquals((String)"Message Body is correct", (Object)MSG_BODY, String.class.cast(r[0]));
    }

    @Test
    public void testMessageFolderNameIsParsed() throws Exception {
        int[] fields = new int[]{10};
        MailInputField[] farr = this.getDefaultInputFields(fields);
        this.mockMailInputMeta(farr);
        try {
            this.mailInput.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        MailInput.MessageParser underTest = new MailInput.MessageParser(this.mailInput);
        Object[] r = RowDataUtil.allocateRowData((int)this.data.nrFields);
        underTest.parseToArray(r, this.message);
        Assert.assertEquals((String)"Message Folder Name is correct", (Object)FLD_NAME, String.class.cast(r[0]));
    }

    @Test
    public void testMessageAttachedFilesCountNameIsParsed() throws Exception {
        int[] fields = new int[]{17};
        MailInputField[] farr = this.getDefaultInputFields(fields);
        this.mockMailInputMeta(farr);
        try {
            this.mailInput.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        MailInput.MessageParser underTest = new MailInput.MessageParser(this.mailInput);
        Object[] r = RowDataUtil.allocateRowData((int)this.data.nrFields);
        underTest.parseToArray(r, this.message);
        Assert.assertEquals((String)"Message Attached files count is correct", (Object)new Long(3L), Long.class.cast(r[0]));
    }

    @Test
    public void testMessageBodyContentTypeIsParsed() throws Exception {
        int[] fields = new int[]{19};
        MailInputField[] farr = this.getDefaultInputFields(fields);
        this.mockMailInputMeta(farr);
        try {
            this.mailInput.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        MailInput.MessageParser underTest = new MailInput.MessageParser(this.mailInput);
        Object[] r = RowDataUtil.allocateRowData((int)this.data.nrFields);
        underTest.parseToArray(r, this.message);
        Assert.assertEquals((String)"Message body content type is correct", (Object)CNTNT_TYPE, String.class.cast(r[0]));
    }

    private void mockMailInputMeta(MailInputField[] arr) {
        this.data.nrFields = arr.length;
        this.meta = (MailInputMeta)Mockito.mock(MailInputMeta.class);
        Mockito.when((Object)this.meta.getInputFields()).thenReturn((Object)arr);
    }

    private MailInputField[] getDefaultInputFields(int[] arr) {
        MailInputField[] fields = new MailInputField[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            fields[i] = new MailInputField();
            fields[i].setColumn(arr[i]);
            fields[i].setName(MailInputField.getColumnDesc((int)arr[i]));
        }
        return fields;
    }

    private Enumeration<Header> getEnum(Header[] headers) {
        return Collections.enumeration(Arrays.asList(headers));
    }

    static {
        DATE1 = new Date(0L);
        DATE2 = new Date(60000L);
        CNTNT_SIZE = 23;
        HDR_EX1 = "header_ex1";
        HDR_EX1V = "header_ex1_value";
        HDR_EX2 = "header_ex2";
        HDR_EX2V = "header_ex2_value";
    }
}

