/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mailinput;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.job.entries.getpop.MailConnectionMeta;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.initializer.InitializerInterface;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.IntLoadSaveValidator;
import org.pentaho.di.trans.steps.mailinput.MailInputField;
import org.pentaho.di.trans.steps.mailinput.MailInputMeta;

public class MailInputMetaTest
implements InitializerInterface<StepMetaInterface> {
    LoadSaveTester loadSaveTester;
    Class<MailInputMeta> testMetaClass = MailInputMeta.class;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Before
    public void setUpLoadSave() throws Exception {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
        List<String> attributes = Arrays.asList("conditionReceivedDate", "valueimaplist", "serverName", "userName", "password", "useSSL", "port", "firstMails", "retrievemails", "delete", "protocol", "firstIMAPMails", "IMAPFolder", "senderSearchTerm", "notTermSenderSearch", "recipientSearch", "subjectSearch", "receivedDate1", "receivedDate2", "notTermSubjectSearch", "notTermRecipientSearch", "notTermReceivedDateSearch", "includeSubFolders", "useProxy", "proxyUsername", "folderField", "dynamicFolder", "rowLimit", "useBatch", "start", "end", "batchSize", "stopOnError", "inputFields");
        HashMap<String, String> getterMap = new HashMap<String, String>();
        HashMap<String, String> setterMap = new HashMap<String, String>();
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("inputFields", new ArrayLoadSaveValidator<MailInputField>(new MailInputFieldLoadSaveValidator(), 5));
        attrValidatorMap.put("batchSize", new IntLoadSaveValidator(1000));
        attrValidatorMap.put("conditionReceivedDate", new IntLoadSaveValidator(MailConnectionMeta.conditionDateCode.length));
        attrValidatorMap.put("valueimaplist", new IntLoadSaveValidator(MailConnectionMeta.valueIMAPListCode.length));
        attrValidatorMap.put("port", new StringIntLoadSaveValidator(65534));
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<StepMetaInterface>(this.testMetaClass, attributes, new ArrayList<String>(), new ArrayList<String>(), getterMap, setterMap, attrValidatorMap, typeValidatorMap, this);
    }

    @Override
    public void modify(StepMetaInterface someMeta) {
        if (someMeta instanceof MailInputMeta) {
            ((MailInputMeta)someMeta).allocate(5);
        }
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    public class StringIntLoadSaveValidator
    implements FieldLoadSaveValidator<String> {
        final Random rand = new Random();
        int intBound;

        public StringIntLoadSaveValidator() {
            this.intBound = 0;
        }

        public StringIntLoadSaveValidator(int bounds) {
            if (bounds <= 0) {
                throw new IllegalArgumentException("Bad boundary for StringIntLoadSaveValidator");
            }
            this.intBound = bounds;
        }

        @Override
        public String getTestObject() {
            int someInt = 0;
            someInt = this.intBound > 0 ? this.rand.nextInt(this.intBound) : this.rand.nextInt();
            return Integer.toString(someInt);
        }

        @Override
        public boolean validateTestObject(String testObject, Object actual) {
            return actual.equals(testObject);
        }
    }

    public class MailInputFieldLoadSaveValidator
    implements FieldLoadSaveValidator<MailInputField> {
        final Random rand = new Random();

        @Override
        public MailInputField getTestObject() {
            MailInputField rtn = new MailInputField();
            rtn.setName(UUID.randomUUID().toString());
            rtn.setColumn(this.rand.nextInt(MailInputField.ColumnDesc.length));
            return rtn;
        }

        @Override
        public boolean validateTestObject(MailInputField testObject, Object actual) {
            if (!(actual instanceof MailInputField)) {
                return false;
            }
            MailInputField another = (MailInputField)actual;
            return new EqualsBuilder().append((Object)testObject.getName(), (Object)another.getName()).append(testObject.getColumn(), another.getColumn()).isEquals();
        }
    }
}

