/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.loadsave.validator;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.trans.steps.loadsave.getter.Getter;
import org.pentaho.di.trans.steps.loadsave.setter.Setter;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidatorFactory;
import org.pentaho.test.util.JavaBeanManipulator;

public class ObjectValidator<T>
implements FieldLoadSaveValidator<T> {
    private final FieldLoadSaveValidatorFactory fieldLoadSaveValidatorFactory;
    private final JavaBeanManipulator<T> manipulator;
    private final Class<T> clazz;
    private final List<String> fieldNames;

    public ObjectValidator(FieldLoadSaveValidatorFactory fieldLoadSaveValidatorFactory, Class<T> clazz, List<String> fieldNames, Map<String, String> getterMap, Map<String, String> setterMap) {
        this.fieldLoadSaveValidatorFactory = fieldLoadSaveValidatorFactory;
        this.manipulator = new JavaBeanManipulator<T>(clazz, fieldNames, getterMap, setterMap);
        this.clazz = clazz;
        this.fieldNames = new ArrayList<String>(fieldNames);
    }

    public ObjectValidator(FieldLoadSaveValidatorFactory fieldLoadSaveValidatorFactory, Class<T> clazz, List<String> fieldNames) {
        this(fieldLoadSaveValidatorFactory, clazz, fieldNames, new HashMap<String, String>(), new HashMap<String, String>());
    }

    @Override
    public T getTestObject() {
        try {
            T object = this.clazz.newInstance();
            for (String attribute : this.fieldNames) {
                Setter<?> setter = this.manipulator.getSetter(attribute);
                setter.set(object, this.fieldLoadSaveValidatorFactory.createValidator(this.manipulator.getGetter(attribute)).getTestObject());
            }
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate " + this.clazz, e);
        }
    }

    @Override
    public boolean validateTestObject(T testObject, Object actual) {
        if (actual == null || !this.clazz.isAssignableFrom(actual.getClass())) {
            return false;
        }
        try {
            for (String attribute : this.fieldNames) {
                Getter<?> getter = this.manipulator.getGetter(attribute);
                FieldLoadSaveValidator<?> validator = this.fieldLoadSaveValidatorFactory.createValidator(getter);
                Method validatorMethod = null;
                for (Method method : validator.getClass().getMethods()) {
                    Class<?>[] types;
                    if (!"validateTestObject".equals(method.getName()) || (types = method.getParameterTypes()).length != 2) continue;
                    validatorMethod = method;
                    break;
                }
                if (validatorMethod == null) {
                    throw new RuntimeException("Unable to find validator for " + attribute + " " + getter.getGenericType());
                }
                if (((Boolean)validatorMethod.invoke(validator, getter.get(testObject), getter.get(actual))).booleanValue()) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate " + this.clazz, e);
        }
    }
}

