/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.loadsave.validator;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;

public class MapLoadSaveValidator<KeyObjectType, ValueObjectType>
implements FieldLoadSaveValidator<Map<KeyObjectType, ValueObjectType>> {
    private final FieldLoadSaveValidator<KeyObjectType> keyValidator;
    private final FieldLoadSaveValidator<ValueObjectType> valueValidator;
    private final Integer elements;

    public MapLoadSaveValidator(FieldLoadSaveValidator<KeyObjectType> keyFieldValidator, FieldLoadSaveValidator<ValueObjectType> valueFieldValidator) {
        this.keyValidator = keyFieldValidator;
        this.valueValidator = valueFieldValidator;
        this.elements = null;
    }

    public MapLoadSaveValidator(FieldLoadSaveValidator<KeyObjectType> keyFieldValidator, FieldLoadSaveValidator<ValueObjectType> valueFieldValidator, Integer elements) {
        this.keyValidator = keyFieldValidator;
        this.valueValidator = valueFieldValidator;
        this.elements = elements;
    }

    @Override
    public Map<KeyObjectType, ValueObjectType> getTestObject() {
        int max = this.elements == null ? new Random().nextInt(100) + 50 : this.elements;
        LinkedHashMap<KeyObjectType, ValueObjectType> result = new LinkedHashMap<KeyObjectType, ValueObjectType>();
        for (int i = 0; i < max; ++i) {
            result.put(this.keyValidator.getTestObject(), this.valueValidator.getTestObject());
        }
        return result;
    }

    @Override
    public boolean validateTestObject(Map<KeyObjectType, ValueObjectType> original, Object actual) {
        if (actual instanceof Map) {
            Map actualMap = (Map)actual;
            if (original.size() != actualMap.size()) {
                return false;
            }
            for (KeyObjectType originalKey : original.keySet()) {
                if (!actualMap.containsKey(originalKey)) {
                    return false;
                }
                if (this.valueValidator.validateTestObject(original.get(originalKey), actualMap.get(originalKey))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

