/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.loadsave.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;

public class ListLoadSaveValidator<ObjectType>
implements FieldLoadSaveValidator<List<ObjectType>> {
    private final FieldLoadSaveValidator<ObjectType> validator;
    private final Integer elements;

    public ListLoadSaveValidator(FieldLoadSaveValidator<ObjectType> fieldValidator) {
        this.validator = fieldValidator;
        this.elements = null;
    }

    public ListLoadSaveValidator(FieldLoadSaveValidator<ObjectType> fieldValidator, Integer elements) {
        this.validator = fieldValidator;
        this.elements = elements;
    }

    @Override
    public List<ObjectType> getTestObject() {
        int max = this.elements == null ? new Random().nextInt(100) + 50 : this.elements;
        ArrayList<ObjectType> result = new ArrayList<ObjectType>(max);
        for (int i = 0; i < max; ++i) {
            result.add(this.validator.getTestObject());
        }
        return result;
    }

    @Override
    public boolean validateTestObject(List<ObjectType> original, Object actual) {
        if (actual instanceof List) {
            List otherList = (List)actual;
            if (original.size() != otherList.size()) {
                return false;
            }
            for (int i = 0; i < original.size(); ++i) {
                if (this.validator.validateTestObject(original.get(i), otherList.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

