/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.loadsave;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.pentaho.di.base.LoadSaveBase;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.loadsave.MemoryRepository;
import org.pentaho.di.trans.steps.loadsave.getter.Getter;
import org.pentaho.di.trans.steps.loadsave.initializer.InitializerInterface;
import org.pentaho.di.trans.steps.loadsave.setter.Setter;
import org.pentaho.di.trans.steps.loadsave.validator.DatabaseMetaLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidatorFactory;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class LoadSaveTester<T extends StepMetaInterface>
extends LoadSaveBase<T> {
    public LoadSaveTester(Class<T> clazz, List<String> commonAttributes, List<String> xmlAttributes, List<String> repoAttributes, Map<String, String> getterMap, Map<String, String> setterMap, Map<String, FieldLoadSaveValidator<?>> fieldLoadSaveValidatorAttributeMap, Map<String, FieldLoadSaveValidator<?>> fieldLoadSaveValidatorTypeMap, InitializerInterface<T> metaInitializerIFace) {
        super(clazz, commonAttributes, xmlAttributes, repoAttributes, getterMap, setterMap, fieldLoadSaveValidatorAttributeMap, fieldLoadSaveValidatorTypeMap, metaInitializerIFace);
    }

    public LoadSaveTester(Class<T> clazz, List<String> commonAttributes, List<String> xmlAttributes, List<String> repoAttributes, Map<String, String> getterMap, Map<String, String> setterMap, Map<String, FieldLoadSaveValidator<?>> fieldLoadSaveValidatorAttributeMap, Map<String, FieldLoadSaveValidator<?>> fieldLoadSaveValidatorTypeMap) {
        this(clazz, commonAttributes, xmlAttributes, repoAttributes, getterMap, setterMap, fieldLoadSaveValidatorAttributeMap, fieldLoadSaveValidatorTypeMap, null);
    }

    public LoadSaveTester(Class<T> clazz, List<String> commonAttributes, Map<String, String> getterMap, Map<String, String> setterMap, Map<String, FieldLoadSaveValidator<?>> fieldLoadSaveValidatorAttributeMap, Map<String, FieldLoadSaveValidator<?>> fieldLoadSaveValidatorTypeMap) {
        this(clazz, commonAttributes, new ArrayList<String>(), new ArrayList<String>(), getterMap, setterMap, fieldLoadSaveValidatorAttributeMap, fieldLoadSaveValidatorTypeMap);
    }

    public LoadSaveTester(Class<T> clazz, List<String> commonAttributes, Map<String, String> getterMap, Map<String, String> setterMap, Map<String, FieldLoadSaveValidator<?>> fieldLoadSaveValidatorAttributeMap, Map<String, FieldLoadSaveValidator<?>> fieldLoadSaveValidatorTypeMap, InitializerInterface<T> metaInitializerIFace) {
        this(clazz, commonAttributes, new ArrayList<String>(), new ArrayList<String>(), getterMap, setterMap, fieldLoadSaveValidatorAttributeMap, fieldLoadSaveValidatorTypeMap, metaInitializerIFace);
    }

    public LoadSaveTester(Class<T> clazz, List<String> commonAttributes, List<String> xmlAttributes, List<String> repoAttributes, Map<String, String> getterMap, Map<String, String> setterMap) {
        this(clazz, commonAttributes, xmlAttributes, repoAttributes, getterMap, setterMap, new HashMap(), new HashMap());
    }

    public LoadSaveTester(Class<T> clazz, List<String> commonAttributes, Map<String, String> getterMap, Map<String, String> setterMap) {
        this(clazz, commonAttributes, new ArrayList<String>(), new ArrayList<String>(), getterMap, setterMap, new HashMap(), new HashMap());
    }

    public LoadSaveTester(Class<T> clazz, List<String> commonAttributes) {
        this(clazz, commonAttributes, new HashMap<String, String>(), new HashMap<String, String>());
    }

    public FieldLoadSaveValidatorFactory getFieldLoadSaveValidatorFactory() {
        return this.fieldLoadSaveValidatorFactory;
    }

    @Override
    protected Map<String, FieldLoadSaveValidator<?>> createValidatorMapAndInvokeSetters(List<String> attributes, T metaToSave) {
        HashMap validatorMap = new HashMap();
        for (String attribute : attributes) {
            Getter<?> getter = this.manipulator.getGetter(attribute);
            Setter<?> setter = this.manipulator.getSetter(attribute);
            FieldLoadSaveValidator<?> validator = this.fieldLoadSaveValidatorFactory.createValidator(getter);
            try {
                Object testValue = validator.getTestObject();
                setter.set(metaToSave, testValue);
                if (validator instanceof DatabaseMetaLoadSaveValidator) {
                    this.addDatabase((DatabaseMeta)testValue);
                    this.validateStepUsesDatabaseMeta(metaToSave, (DatabaseMeta)testValue);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to invoke setter for " + attribute, e);
            }
            validatorMap.put(attribute, validator);
        }
        return validatorMap;
    }

    private void validateStepUsesDatabaseMeta(T metaToSave, DatabaseMeta dbMeta) throws KettleException {
        DatabaseMeta[] usedConnections = metaToSave.getUsedDatabaseConnections();
        if (usedConnections == null || usedConnections.length <= 0 || !Arrays.asList(usedConnections).contains(dbMeta)) {
            throw new KettleException("The step did not report a DatabaseMeta in getUsedDatabaseConnections()");
        }
    }

    public void testSerialization() throws KettleException {
        this.testXmlRoundTrip();
        this.testRepoRoundTrip();
        this.testClone();
        this.testMixedXmlRepoRoundTrip();
    }

    protected void testClone() throws KettleException {
        StepMetaInterface metaToSave = (StepMetaInterface)this.createMeta();
        if (this.initializer != null) {
            this.initializer.modify(metaToSave);
        }
        Map<String, FieldLoadSaveValidator<?>> validatorMap = this.createValidatorMapAndInvokeSetters((List<String>)this.xmlAttributes, metaToSave);
        StepMetaInterface metaLoaded = (StepMetaInterface)metaToSave.clone();
        Assert.assertNotSame((Object)metaToSave, (Object)metaLoaded);
        this.validateLoadedMeta(this.xmlAttributes, validatorMap, metaToSave, metaLoaded);
        this.validateLoadedMeta(this.repoAttributes, validatorMap, metaToSave, metaLoaded);
    }

    @Deprecated
    public void testXmlRoundTrip() throws KettleException {
        StepMetaInterface metaToSave = (StepMetaInterface)this.createMeta();
        if (this.initializer != null) {
            this.initializer.modify(metaToSave);
        }
        Map<String, FieldLoadSaveValidator<?>> validatorMap = this.createValidatorMapAndInvokeSetters((List<String>)this.xmlAttributes, metaToSave);
        StepMetaInterface metaLoaded = (StepMetaInterface)this.createMeta();
        String xml = "<step>" + metaToSave.getXML() + "</step>";
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
        metaLoaded.loadXML(XMLHandler.getSubNode((Node)XMLHandler.loadXMLFile((InputStream)is, null, (boolean)false, (boolean)false), (String)"step"), this.databases, (IMetaStore)null);
        this.validateLoadedMeta(this.xmlAttributes, validatorMap, metaToSave, metaLoaded);
        this.testClone();
    }

    @Deprecated
    public void testRepoRoundTrip() throws KettleException {
        StepMetaInterface metaToSave = (StepMetaInterface)this.createMeta();
        if (this.initializer != null) {
            this.initializer.modify(metaToSave);
        }
        Map<String, FieldLoadSaveValidator<?>> validatorMap = this.createValidatorMapAndInvokeSetters((List<String>)this.repoAttributes, metaToSave);
        StepMetaInterface metaLoaded = (StepMetaInterface)this.createMeta();
        MemoryRepository rep = new MemoryRepository();
        metaToSave.saveRep((Repository)rep, null, null, null);
        metaLoaded.readRep((Repository)rep, (IMetaStore)null, null, this.databases);
        this.validateLoadedMeta(this.repoAttributes, validatorMap, metaToSave, metaLoaded);
    }

    protected void testMixedXmlRepoRoundTrip() throws KettleException {
        StepMetaInterface metaToSave = (StepMetaInterface)this.createMeta();
        if (this.initializer != null) {
            this.initializer.modify(metaToSave);
        }
        Map<String, FieldLoadSaveValidator<?>> validatorMap = this.createValidatorMapAndInvokeSetters((List<String>)this.repoAttributes, metaToSave);
        StepMetaInterface metaRepoLoaded = (StepMetaInterface)this.createMeta();
        MemoryRepository rep = new MemoryRepository();
        metaToSave.saveRep((Repository)rep, null, null, null);
        metaRepoLoaded.readRep((Repository)rep, (IMetaStore)null, null, this.databases);
        String xml = "<step>" + metaRepoLoaded.getXML() + "</step>";
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
        StepMetaInterface metaXMLLoaded = (StepMetaInterface)this.createMeta();
        metaXMLLoaded.loadXML(XMLHandler.getSubNode((Node)XMLHandler.loadXMLFile((InputStream)is, null, (boolean)false, (boolean)false), (String)"step"), this.databases, (IMetaStore)null);
        this.validateLoadedMeta(this.xmlAttributes, validatorMap, metaToSave, metaXMLLoaded);
    }
}

