/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.loadfileinput;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBinary;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.loadfileinput.LoadFileInput;
import org.pentaho.di.trans.steps.loadfileinput.LoadFileInputData;
import org.pentaho.di.trans.steps.loadfileinput.LoadFileInputField;
import org.pentaho.di.trans.steps.loadfileinput.LoadFileInputMeta;

public class LoadFileInputTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private FileSystemManager fs;
    private String filesPath;
    private String transName;
    private TransMeta transMeta;
    private Trans trans;
    private LoadFileInputMeta stepMetaInterface;
    private StepDataInterface stepDataInterface;
    private StepMeta stepMeta;
    private FileInputList stepInputFiles;
    private int stepCopyNr;
    private LoadFileInput stepLoadFileInput;
    private StepMetaInterface runtimeSMI;
    private StepDataInterface runtimeSDI;
    private LoadFileInputField inputField;
    private static String wasEncoding;

    @BeforeClass
    public static void setupBeforeClass() throws KettleException {
        if (Const.isWindows()) {
            wasEncoding = System.getProperty("file.encoding");
            LoadFileInputTest.fiddleWithDefaultCharset("utf8");
        }
        KettleClientEnvironment.init();
    }

    @AfterClass
    public static void teardownAfterClass() {
        if (wasEncoding != null) {
            LoadFileInputTest.fiddleWithDefaultCharset(wasEncoding);
        }
    }

    private static void fiddleWithDefaultCharset(String fiddleValue) {
        try {
            Class<Charset> charSet = Charset.class;
            Field defaultCharsetFld = charSet.getDeclaredField("defaultCharset");
            defaultCharsetFld.setAccessible(true);
            defaultCharsetFld.set(null, Charset.forName(fiddleValue));
        }
        catch (Exception ex) {
            System.out.println("*** Fiddling with Charset class failed");
        }
    }

    @Before
    public void setup() throws FileSystemException {
        this.fs = VFS.getManager();
        this.filesPath = '/' + this.getClass().getPackage().getName().replace('.', '/') + "/files/";
        this.transName = "LoadFileInput";
        this.transMeta = new TransMeta();
        this.transMeta.setName(this.transName);
        this.trans = new Trans(this.transMeta);
        this.stepMetaInterface = (LoadFileInputMeta)Mockito.spy((Object)new LoadFileInputMeta());
        this.stepInputFiles = new FileInputList();
        ((LoadFileInputMeta)Mockito.doReturn((Object)this.stepInputFiles).when((Object)this.stepMetaInterface)).getFiles((VariableSpace)Matchers.any(VariableSpace.class));
        String stepId = PluginRegistry.getInstance().getPluginId(StepPluginType.class, (Object)this.stepMetaInterface);
        this.stepMeta = new StepMeta(stepId, "Load File Input", (StepMetaInterface)this.stepMetaInterface);
        this.transMeta.addStep(this.stepMeta);
        this.stepDataInterface = new LoadFileInputData();
        this.stepCopyNr = 0;
        this.stepLoadFileInput = new LoadFileInput(this.stepMeta, this.stepDataInterface, this.stepCopyNr, this.transMeta, this.trans);
        Assert.assertSame((Object)this.stepMetaInterface, (Object)this.stepMeta.getStepMetaInterface());
        this.runtimeSMI = this.stepMetaInterface;
        this.runtimeSDI = this.runtimeSMI.getStepData();
        this.inputField = new LoadFileInputField();
        ((LoadFileInputMeta)this.runtimeSMI).setInputFields(new LoadFileInputField[]{this.inputField});
        this.stepLoadFileInput.init(this.runtimeSMI, this.runtimeSDI);
    }

    private FileObject getFile(String filename) {
        try {
            return this.fs.resolveFile(this.getClass().getResource(this.filesPath + filename));
        }
        catch (Exception e) {
            throw new RuntimeException("fail. " + e.getMessage(), e);
        }
    }

    @Test
    public void testOpenNextFile_noFiles() {
        Assert.assertFalse((boolean)this.stepMetaInterface.isIgnoreEmptyFile());
        Assert.assertFalse((boolean)this.stepLoadFileInput.openNextFile());
    }

    @Test
    public void testOpenNextFile_noFiles_ignoreEmpty() {
        this.stepMetaInterface.setIgnoreEmptyFile(true);
        Assert.assertFalse((boolean)this.stepLoadFileInput.openNextFile());
    }

    @Test
    public void testOpenNextFile_0() {
        Assert.assertFalse((boolean)this.stepMetaInterface.isIgnoreEmptyFile());
        this.stepInputFiles.addFile(this.getFile("input0.txt"));
        Assert.assertTrue((boolean)this.stepLoadFileInput.openNextFile());
        Assert.assertFalse((boolean)this.stepLoadFileInput.openNextFile());
    }

    @Test
    public void testOpenNextFile_0_ignoreEmpty() {
        this.stepMetaInterface.setIgnoreEmptyFile(true);
        this.stepInputFiles.addFile(this.getFile("input0.txt"));
        Assert.assertFalse((boolean)this.stepLoadFileInput.openNextFile());
    }

    @Test
    public void testOpenNextFile_000() {
        Assert.assertFalse((boolean)this.stepMetaInterface.isIgnoreEmptyFile());
        this.stepInputFiles.addFile(this.getFile("input0.txt"));
        this.stepInputFiles.addFile(this.getFile("input0.txt"));
        this.stepInputFiles.addFile(this.getFile("input0.txt"));
        Assert.assertTrue((boolean)this.stepLoadFileInput.openNextFile());
        Assert.assertTrue((boolean)this.stepLoadFileInput.openNextFile());
        Assert.assertTrue((boolean)this.stepLoadFileInput.openNextFile());
        Assert.assertFalse((boolean)this.stepLoadFileInput.openNextFile());
    }

    @Test
    public void testOpenNextFile_000_ignoreEmpty() {
        this.stepMetaInterface.setIgnoreEmptyFile(true);
        this.stepInputFiles.addFile(this.getFile("input0.txt"));
        this.stepInputFiles.addFile(this.getFile("input0.txt"));
        this.stepInputFiles.addFile(this.getFile("input0.txt"));
        Assert.assertFalse((boolean)this.stepLoadFileInput.openNextFile());
    }

    @Test
    public void testOpenNextFile_10() {
        Assert.assertFalse((boolean)this.stepMetaInterface.isIgnoreEmptyFile());
        this.stepInputFiles.addFile(this.getFile("input1.txt"));
        this.stepInputFiles.addFile(this.getFile("input0.txt"));
        Assert.assertTrue((boolean)this.stepLoadFileInput.openNextFile());
        Assert.assertTrue((boolean)this.stepLoadFileInput.openNextFile());
        Assert.assertFalse((boolean)this.stepLoadFileInput.openNextFile());
    }

    @Test
    public void testOpenNextFile_10_ignoreEmpty() {
        this.stepMetaInterface.setIgnoreEmptyFile(true);
        this.stepInputFiles.addFile(this.getFile("input1.txt"));
        this.stepInputFiles.addFile(this.getFile("input0.txt"));
        Assert.assertTrue((boolean)this.stepLoadFileInput.openNextFile());
        Assert.assertFalse((boolean)this.stepLoadFileInput.openNextFile());
    }

    @Test
    public void testOpenNextFile_01() {
        Assert.assertFalse((boolean)this.stepMetaInterface.isIgnoreEmptyFile());
        this.stepInputFiles.addFile(this.getFile("input0.txt"));
        this.stepInputFiles.addFile(this.getFile("input1.txt"));
        Assert.assertTrue((boolean)this.stepLoadFileInput.openNextFile());
        Assert.assertTrue((boolean)this.stepLoadFileInput.openNextFile());
        Assert.assertFalse((boolean)this.stepLoadFileInput.openNextFile());
    }

    @Test
    public void testOpenNextFile_01_ignoreEmpty() {
        this.stepMetaInterface.setIgnoreEmptyFile(true);
        this.stepInputFiles.addFile(this.getFile("input0.txt"));
        this.stepInputFiles.addFile(this.getFile("input1.txt"));
        Assert.assertTrue((boolean)this.stepLoadFileInput.openNextFile());
        Assert.assertFalse((boolean)this.stepLoadFileInput.openNextFile());
    }

    @Test
    public void testOpenNextFile_010() {
        Assert.assertFalse((boolean)this.stepMetaInterface.isIgnoreEmptyFile());
        this.stepInputFiles.addFile(this.getFile("input0.txt"));
        this.stepInputFiles.addFile(this.getFile("input1.txt"));
        this.stepInputFiles.addFile(this.getFile("input0.txt"));
        Assert.assertTrue((boolean)this.stepLoadFileInput.openNextFile());
        Assert.assertTrue((boolean)this.stepLoadFileInput.openNextFile());
        Assert.assertTrue((boolean)this.stepLoadFileInput.openNextFile());
        Assert.assertFalse((boolean)this.stepLoadFileInput.openNextFile());
    }

    @Test
    public void testOpenNextFile_010_ignoreEmpty() {
        this.stepMetaInterface.setIgnoreEmptyFile(true);
        this.stepInputFiles.addFile(this.getFile("input0.txt"));
        this.stepInputFiles.addFile(this.getFile("input1.txt"));
        this.stepInputFiles.addFile(this.getFile("input0.txt"));
        Assert.assertTrue((boolean)this.stepLoadFileInput.openNextFile());
        Assert.assertFalse((boolean)this.stepLoadFileInput.openNextFile());
    }

    @Test
    public void testGetOneRow() throws Exception {
        this.stepInputFiles.addFile(this.getFile("input1.txt"));
        Assert.assertNotNull((Object)this.stepLoadFileInput.getOneRow());
        Assert.assertEquals((Object)"input1 - not empty", (Object)new String(this.stepLoadFileInput.data.filecontent));
    }

    @Test
    public void testUTF8Encoding() throws KettleException, FileSystemException {
        this.stepMetaInterface.setIncludeFilename(true);
        this.stepMetaInterface.setFilenameField("filename");
        this.stepMetaInterface.setIncludeRowNumber(true);
        this.stepMetaInterface.setRowNumberField("rownumber");
        this.stepMetaInterface.setShortFileNameField("shortname");
        this.stepMetaInterface.setExtensionField("extension");
        this.stepMetaInterface.setPathField("path");
        this.stepMetaInterface.setIsHiddenField("hidden");
        this.stepMetaInterface.setLastModificationDateField("lastmodified");
        this.stepMetaInterface.setUriField("uri");
        this.stepMetaInterface.setRootUriField("root uri");
        ((LoadFileInputMeta)this.runtimeSMI).setEncoding("UTF-8");
        this.stepInputFiles.addFile(this.getFile("UTF-8.txt"));
        Object[] result = this.stepLoadFileInput.getOneRow();
        Assert.assertEquals((Object)" UTF-8 string \u00d5\u00d5\u00d5\u20ac ", (Object)result[0]);
        Assert.assertEquals((Object)1L, (Object)result[2]);
        Assert.assertEquals((Object)"UTF-8.txt", (Object)result[3]);
        Assert.assertEquals((Object)"txt", (Object)result[4]);
        Assert.assertEquals((Object)false, (Object)result[6]);
        Assert.assertEquals((Object)this.getFile("UTF-8.txt").getURL().toString(), (Object)result[8]);
        Assert.assertEquals((Object)this.getFile("UTF-8.txt").getName().getRootURI(), (Object)result[9]);
    }

    @Test
    public void testUTF8TrimLeft() throws KettleException {
        ((LoadFileInputMeta)this.runtimeSMI).setEncoding("UTF-8");
        this.inputField.setTrimType(1);
        this.stepInputFiles.addFile(this.getFile("UTF-8.txt"));
        Assert.assertEquals((Object)"UTF-8 string \u00d5\u00d5\u00d5\u20ac ", (Object)this.stepLoadFileInput.getOneRow()[0]);
    }

    @Test
    public void testUTF8TrimRight() throws KettleException {
        ((LoadFileInputMeta)this.runtimeSMI).setEncoding("UTF-8");
        this.inputField.setTrimType(2);
        this.stepInputFiles.addFile(this.getFile("UTF-8.txt"));
        Assert.assertEquals((Object)" UTF-8 string \u00d5\u00d5\u00d5\u20ac", (Object)this.stepLoadFileInput.getOneRow()[0]);
    }

    @Test
    public void testUTF8Trim() throws KettleException {
        ((LoadFileInputMeta)this.runtimeSMI).setEncoding("UTF-8");
        this.inputField.setTrimType(3);
        this.stepInputFiles.addFile(this.getFile("UTF-8.txt"));
        Assert.assertEquals((Object)"UTF-8 string \u00d5\u00d5\u00d5\u20ac", (Object)this.stepLoadFileInput.getOneRow()[0]);
    }

    @Test
    public void testWindowsEncoding() throws KettleException {
        ((LoadFileInputMeta)this.runtimeSMI).setEncoding("Windows-1252");
        this.inputField.setTrimType(0);
        this.stepInputFiles.addFile(this.getFile("Windows-1252.txt"));
        Assert.assertEquals((Object)" Windows-1252 string \u00d5\u00d5\u00d5\u20ac ", (Object)this.stepLoadFileInput.getOneRow()[0]);
    }

    @Test
    public void testWithNoEncoding() throws KettleException, UnsupportedEncodingException {
        ((LoadFileInputMeta)this.runtimeSMI).setEncoding(null);
        this.stepInputFiles.addFile(this.getFile("Windows-1252.txt"));
        Assert.assertNotEquals((Object)" Windows-1252 string \u00d5\u00d5\u00d5\u20ac ", (Object)this.stepLoadFileInput.getOneRow()[0]);
        Assert.assertEquals((Object)" Windows-1252 string \u00d5\u00d5\u00d5\u20ac ", (Object)new String(this.stepLoadFileInput.data.filecontent, "Windows-1252"));
    }

    @Test
    public void testByteArray() throws Exception {
        RowMetaInterface mockedRowMetaInterface;
        this.stepLoadFileInput.data.outputRowMeta = mockedRowMetaInterface = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        this.stepLoadFileInput.data.convertRowMeta = mockedRowMetaInterface;
        ((RowMetaInterface)Mockito.doReturn((Object)new ValueMetaString()).when((Object)mockedRowMetaInterface)).getValueMeta(Matchers.anyInt());
        ((RowMetaInterface)Mockito.doReturn((Object)new ValueMetaBinary()).when((Object)mockedRowMetaInterface)).getValueMeta(Matchers.anyInt());
        ((LoadFileInputMeta)this.runtimeSMI).setEncoding("UTF-8");
        this.stepInputFiles.addFile(this.getFile("pentaho_splash.png"));
        this.inputField = new LoadFileInputField();
        this.inputField.setType(8);
        ((LoadFileInputMeta)this.runtimeSMI).setInputFields(new LoadFileInputField[]{this.inputField});
        Assert.assertNotNull((Object)this.stepLoadFileInput.getOneRow());
        Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)this.getFile("pentaho_splash.png").getContent().getInputStream()), (byte[])this.stepLoadFileInput.data.filecontent);
    }

    @Test
    public void testCopyOrCloneArrayFromLoadFileWithSmallerSizedReadRowArray() {
        int size = 5;
        Object[] rowData = new Object[size];
        Object[] readrow = new Object[size - 1];
        LoadFileInput loadFileInput = (LoadFileInput)Mockito.mock(LoadFileInput.class);
        Mockito.when((Object)loadFileInput.copyOrCloneArrayFromLoadFile(rowData, readrow)).thenCallRealMethod();
        Assert.assertEquals((long)5L, (long)loadFileInput.copyOrCloneArrayFromLoadFile(rowData, readrow).length);
    }

    @Test
    public void testCopyOrCloneArrayFromLoadFileWithBiggerSizedReadRowArray() {
        int size = 5;
        Object[] rowData = new Object[size];
        Object[] readrow = new Object[size + 1];
        LoadFileInput loadFileInput = (LoadFileInput)Mockito.mock(LoadFileInput.class);
        Mockito.when((Object)loadFileInput.copyOrCloneArrayFromLoadFile(rowData, readrow)).thenCallRealMethod();
        Assert.assertEquals((long)6L, (long)loadFileInput.copyOrCloneArrayFromLoadFile(rowData, readrow).length);
    }

    @Test
    public void testCopyOrCloneArrayFromLoadFileWithSameSizedReadRowArray() {
        int size = 5;
        Object[] rowData = new Object[size];
        Object[] readrow = new Object[size];
        LoadFileInput loadFileInput = (LoadFileInput)Mockito.mock(LoadFileInput.class);
        Mockito.when((Object)loadFileInput.copyOrCloneArrayFromLoadFile(rowData, readrow)).thenCallRealMethod();
        Assert.assertEquals((long)5L, (long)loadFileInput.copyOrCloneArrayFromLoadFile(rowData, readrow).length);
    }
}

